/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.pu.events;

import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.pu.ProvisionStatus;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceProvisionFailure;

public class ProcessingUnitInstanceProvisionStatusChangedEvent {
    private final ProcessingUnit processingUnit;
    private final String processingUnitInstanceName;
    private final ProvisionStatus previousStatus;
    private final ProvisionStatus newStatus;
    private final ProcessingUnitInstanceProvisionFailure provisionFailure;
    private final String gscServiceId;
    private GridServiceContainer cachedGridServiceContainer;
    private ProcessingUnitInstance cachedProcessingUnitInstance;

    public ProcessingUnitInstanceProvisionStatusChangedEvent(ProcessingUnit processingUnit, String processingUnitInstanceName, ProvisionStatus previousStatus, ProvisionStatus newStatus, GridServiceContainer gridServiceContainer, ProcessingUnitInstance processingUnitInstance, ProcessingUnitInstanceProvisionFailure provisionFailure) {
        this.processingUnit = processingUnit;
        this.processingUnitInstanceName = processingUnitInstanceName;
        this.previousStatus = previousStatus;
        this.newStatus = newStatus;
        this.cachedGridServiceContainer = gridServiceContainer;
        this.cachedProcessingUnitInstance = processingUnitInstance;
        this.gscServiceId = null;
        this.provisionFailure = provisionFailure;
    }

    public ProcessingUnitInstanceProvisionStatusChangedEvent(ProcessingUnit processingUnit, String processingUnitInstanceName, ProvisionStatus previousStatus, ProvisionStatus newStatus, String gscServiceId, ProcessingUnitInstanceProvisionFailure provisionFailure) {
        this.processingUnit = processingUnit;
        this.processingUnitInstanceName = processingUnitInstanceName;
        this.previousStatus = previousStatus;
        this.newStatus = newStatus;
        this.gscServiceId = gscServiceId;
        this.cachedGridServiceContainer = null;
        this.cachedProcessingUnitInstance = null;
        this.provisionFailure = provisionFailure;
    }

    public ProcessingUnit getProcessingUnit() {
        return this.processingUnit;
    }

    public String getProcessingUnitInstanceName() {
        return this.processingUnitInstanceName;
    }

    public ProvisionStatus getPreviousStatus() {
        return this.previousStatus;
    }

    public ProvisionStatus getNewStatus() {
        return this.newStatus;
    }

    public GridServiceContainer getGridServiceContainer() {
        if (this.cachedGridServiceContainer == null && this.gscServiceId != null) {
            this.cachedGridServiceContainer = this.processingUnit.getAdmin().getGridServiceContainers().getContainerByUID(this.gscServiceId);
        }
        return this.cachedGridServiceContainer;
    }

    public ProcessingUnitInstance getProcessingUnitInstance() {
        if (this.cachedProcessingUnitInstance == null) {
            for (ProcessingUnitInstance instance : this.processingUnit.getInstances()) {
                if (!this.processingUnitInstanceName.equals(instance.getProcessingUnitInstanceName())) continue;
                this.cachedProcessingUnitInstance = instance;
                return instance;
            }
        }
        return this.cachedProcessingUnitInstance;
    }

    public ProcessingUnitInstanceProvisionFailure getProvisionFailure() {
        return this.provisionFailure;
    }
}

