/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.pu.statistics;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openspaces.admin.config.AbstractConfig;
import org.openspaces.admin.pu.statistics.TimeWindowStatisticsConfig;

public abstract class AbstractTimeWindowStatisticsConfig
extends AbstractConfig
implements TimeWindowStatisticsConfig {
    private static final String TIMEWINDOW_SECONDS_KEY = "time-window-seconds";
    private static final long TIMEWINDOW_SECONDS_DEFAULT = 60L;
    private static final String MINIMUM_TIMEWINDOW_SECONDS_KEY = "minimum-time-window-seconds";
    private static final String MAXIMUM_TIMEWINDOW_SECONDS_KEY = "maximum-time-window-seconds";

    protected AbstractTimeWindowStatisticsConfig(Map<String, String> properties) {
        super(properties);
    }

    public Long getTimeWindowSeconds() {
        return this.getStringProperties().getLong(TIMEWINDOW_SECONDS_KEY, 60L);
    }

    public void setTimeWindowSeconds(long timeWindowSeconds) {
        this.getStringProperties().putLong(TIMEWINDOW_SECONDS_KEY, timeWindowSeconds);
    }

    public Long getMinimumTimeWindowSeconds() {
        return this.getStringProperties().getLong(MINIMUM_TIMEWINDOW_SECONDS_KEY, this.getTimeWindowSeconds().longValue());
    }

    public void setMinimumTimeWindowSeconds(long minimumTimeWindowSeconds) {
        this.getStringProperties().putLong(MINIMUM_TIMEWINDOW_SECONDS_KEY, minimumTimeWindowSeconds);
    }

    public Long getMaximumTimeWindowSeconds() {
        return this.getStringProperties().getLong(MAXIMUM_TIMEWINDOW_SECONDS_KEY, this.getDefaultMaximumTimeWindowSeconds());
    }

    private long getDefaultMaximumTimeWindowSeconds() {
        return this.getTimeWindowSeconds() * 2L;
    }

    public void setMaximumTimeWindowSeconds(long maximumTimeWindowSeconds) {
        this.getStringProperties().putLong(MAXIMUM_TIMEWINDOW_SECONDS_KEY, maximumTimeWindowSeconds);
    }

    @Override
    public void validate() throws IllegalStateException {
        if (this.getTimeWindowSeconds() <= 0L) {
            throw new IllegalStateException("timeWindowSeconds must be positive");
        }
        if (this.getMinimumTimeWindowSeconds() < 0L) {
            throw new IllegalStateException("minimumTimeWindowSeconds must not be negative");
        }
        if (this.getMaximumTimeWindowSeconds() <= 0L) {
            throw new IllegalStateException("maximumTimeWindowSeconds must be positive");
        }
        if (this.getMaximumTimeWindowSeconds() < this.getTimeWindowSeconds()) {
            throw new IllegalStateException("maximumTimeWindowSeconds (" + this.getMaximumTimeWindowSeconds() + ") must be bigger or equals timeWindowSeconds (" + this.getTimeWindowSeconds() + ")");
        }
        if (this.getMinimumTimeWindowSeconds() > this.getTimeWindowSeconds()) {
            throw new IllegalStateException("minimumTimeWindowSeconds must be less or equals timeWindowSeconds");
        }
    }

    @Override
    public int getMaxNumberOfSamples(long statisticsPollingInterval, TimeUnit timeUnit) {
        long intervalSeconds = timeUnit.toSeconds(statisticsPollingInterval);
        int numberOfPollingIntervals = (int)Math.ceil(1.0 * (double)this.getMaximumTimeWindowSeconds().longValue() / (double)intervalSeconds);
        return 1 + numberOfPollingIntervals;
    }
}

