/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.pu.statistics;

import java.util.HashMap;
import java.util.Map;
import org.openspaces.admin.pu.statistics.InstancesStatisticsConfig;
import org.openspaces.admin.pu.statistics.TimeWindowStatisticsConfig;
import org.openspaces.admin.zone.config.ZonesConfig;
import org.openspaces.core.util.StringProperties;

public class ProcessingUnitStatisticsId {
    private static final String MONITOR_KEY = "monitor";
    private static final String METRIC_KEY = "metric";
    private static final String TIMEWINDOW_STATISTICS_KEY = "timewindow-statistics";
    private static final String INSTANCES_STATISTICS_KEY = "instances-statistics";
    private static final String AGENT_ZONES_KEY = "agent-zones";
    StringProperties properties;

    public ProcessingUnitStatisticsId() {
        this.properties = new StringProperties();
    }

    public ProcessingUnitStatisticsId(Map<String, String> properties) {
        this.properties = new StringProperties(properties);
    }

    public String getMonitor() {
        return this.properties.get(MONITOR_KEY);
    }

    public void setMonitor(String monitor) {
        this.properties.put(MONITOR_KEY, monitor);
    }

    public String getMetric() {
        return this.properties.get(METRIC_KEY);
    }

    public void setMetric(String metric) {
        this.properties.put(METRIC_KEY, metric);
    }

    public TimeWindowStatisticsConfig getTimeWindowStatistics() {
        return (TimeWindowStatisticsConfig)this.properties.getConfig(TIMEWINDOW_STATISTICS_KEY, null);
    }

    public void setTimeWindowStatistics(TimeWindowStatisticsConfig timeWindowStatistics) {
        this.properties.putConfig(TIMEWINDOW_STATISTICS_KEY, (Object)timeWindowStatistics);
    }

    public InstancesStatisticsConfig getInstancesStatistics() {
        return (InstancesStatisticsConfig)this.properties.getConfig(INSTANCES_STATISTICS_KEY, null);
    }

    public void setInstancesStatistics(InstancesStatisticsConfig instancesStatistics) {
        this.properties.putConfig(INSTANCES_STATISTICS_KEY, (Object)instancesStatistics);
    }

    public ZonesConfig getAgentZones() {
        return (ZonesConfig)this.properties.getConfig(AGENT_ZONES_KEY, null);
    }

    public void setAgentZones(ZonesConfig zoneStatistics) {
        this.properties.putConfig(AGENT_ZONES_KEY, (Object)zoneStatistics);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessingUnitStatisticsId other = (ProcessingUnitStatisticsId)obj;
        return !(this.properties == null ? other.properties != null : !this.properties.equals((Object)other.properties));
    }

    public String toString() {
        return "processingUnitStatisticsId " + this.properties.toString();
    }

    public void validate() throws IllegalStateException {
        TimeWindowStatisticsConfig timeWindowStatistics = this.getTimeWindowStatistics();
        if (timeWindowStatistics == null) {
            throw new IllegalStateException("timeWindowStatistics cannot be null");
        }
        this.getTimeWindowStatistics().validate();
        InstancesStatisticsConfig instancesStatistics = this.getInstancesStatistics();
        if (instancesStatistics == null) {
            throw new IllegalStateException("instancesStatistics cannot be null");
        }
        instancesStatistics.validate();
        ZonesConfig zoneStatistics = this.getAgentZones();
        if (zoneStatistics == null) {
            throw new IllegalStateException("zoneStatistics cannot be null");
        }
        zoneStatistics.validate();
        if (this.getMetric() == null || this.getMonitor().isEmpty()) {
            throw new IllegalStateException("metric name cannot be null or empty");
        }
        if (this.getMonitor() == null || this.getMonitor().isEmpty()) {
            throw new IllegalStateException("monitor name cannot be null or empty");
        }
    }

    public Map<String, String> getProperties() {
        return this.properties.getProperties();
    }

    public ProcessingUnitStatisticsId shallowClone() {
        return new ProcessingUnitStatisticsId(new HashMap<String, String>(this.getProperties()));
    }
}

