/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.rest;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;

public class Response {
    private int statusCode;
    private String entity;
    private Map<String, String> headers;

    private Response(int statusCode, String entity, Map<String, String> headers) {
        this.statusCode = statusCode;
        this.entity = entity;
        this.headers = headers;
    }

    public int getStatus() {
        return this.statusCode;
    }

    public String getEntity() {
        return this.entity;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public static ResponseBuilder status(int statusCode) {
        return new ResponseBuilder(statusCode);
    }

    public static ResponseBuilder status(Response.StatusType statusType) {
        return new ResponseBuilder(statusType.getStatusCode());
    }

    public static ResponseBuilder ok() {
        return new ResponseBuilder(200);
    }

    public static ResponseBuilder ok(String entity) {
        return new ResponseBuilder(200, entity);
    }

    public static class ResponseBuilder {
        private int statusCode;
        private String entity;
        private Map<String, String> headers = new HashMap<String, String>();

        private ResponseBuilder(int statusCode) {
            this.statusCode = statusCode;
        }

        private ResponseBuilder(int statusCode, String entity) {
            this.statusCode = statusCode;
            this.entity = entity;
        }

        public ResponseBuilder header(String key, String value) {
            String currentValue = this.headers.get(key);
            if (currentValue == null) {
                this.headers.put(key, value);
            } else {
                this.headers.put(key, currentValue + "," + value);
            }
            return this;
        }

        public ResponseBuilder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Response build() {
            return new Response(this.statusCode, this.entity, this.headers);
        }
    }
}

