/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.samples;

import java.util.Iterator;
import org.openspaces.admin.Admin;
import org.openspaces.admin.AdminFactory;
import org.openspaces.admin.esm.ElasticServiceManager;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.gsm.GridServiceManager;
import org.openspaces.admin.lus.LookupService;
import org.openspaces.admin.machine.Machine;
import org.openspaces.admin.os.OperatingSystemStatistics;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.space.Space;
import org.openspaces.admin.space.SpaceInstance;
import org.openspaces.admin.space.SpacePartition;
import org.openspaces.admin.vm.VirtualMachine;
import org.openspaces.pu.service.ServiceMonitors;

public class TestSampler {
    public static void main(String[] args) throws InterruptedException {
        Admin admin = new AdminFactory().addGroup("kimchy").createAdmin();
        ProcessingUnit myPU = admin.getProcessingUnits().getProcessingUnit("myPU");
        while (true) {
            try {
                for (LookupService lookupService : admin.getLookupServices()) {
                    System.out.println("Lookup [" + lookupService.getUid() + "] : " + lookupService.getMachine());
                }
                for (ElasticServiceManager esm : admin.getElasticServiceManagers()) {
                    System.out.println("ESM [" + esm.getUid() + "] running on Machine " + esm.getMachine().getHostAddress());
                }
                for (GridServiceManager gsm : admin.getGridServiceManagers()) {
                    System.out.println("GSM [" + gsm.getUid() + "] running on Machine " + gsm.getMachine().getHostAddress());
                }
                for (GridServiceContainer gsc : admin.getGridServiceContainers()) {
                    System.out.println("GSC [" + gsc.getUid() + "] running on Machine " + gsc.getMachine().getHostAddress());
                    for (ProcessingUnitInstance puInstance : gsc) {
                        System.out.println("   -> PU [" + puInstance.getName() + "][" + puInstance.getInstanceId() + "][" + puInstance.getBackupId() + "]");
                    }
                }
                for (VirtualMachine virtualMachine : admin.getVirtualMachines()) {
                    System.out.println("VM [" + virtualMachine.getUid() + "] PID [" + virtualMachine.getDetails().getPid() + "] Host [" + virtualMachine.getMachine().getHostAddress() + "] CPU [" + virtualMachine.getStatistics().getCpuPercFormatted() + "] GC Perc [" + virtualMachine.getStatistics().getGcCollectionPerc() + "], Heap Usage [" + virtualMachine.getStatistics().getMemoryHeapUsedPerc() + "%]");
                }
                for (Machine machine : admin.getMachines()) {
                    System.out.println("Machine [" + machine.getUid() + "], Processors [" + machine.getOperatingSystem().getDetails().getAvailableProcessors() + "] CPU [" + machine.getOperatingSystem().getStatistics().getCpuPerc() + "]");
                    System.out.println(" | " + machine.getOperatingSystem().getStatistics().getTimestamp() + " -> " + machine.getOperatingSystem().getStatistics().getAdminTimestamp());
                    if (machine.getOperatingSystem().getStatistics().getNetworkStats() == null) continue;
                    for (OperatingSystemStatistics.NetworkStatistics netStats : machine.getOperatingSystem().getStatistics().getNetworkStats().values()) {
                        System.out.println("   -> " + netStats.getName() + ", Rx " + netStats.getRxBytes() + ", Tx " + netStats.getTxBytes() + ", RxPerSecond " + netStats.getRxBytesPerSecond() + ", TxPerSecond " + netStats.getTxBytesPerSecond());
                    }
                }
                for (ProcessingUnit processingUnit : admin.getProcessingUnits()) {
                    System.out.println("Processing Unit: " + processingUnit.getName() + " status: " + (Object)((Object)processingUnit.getStatus()));
                    if (processingUnit.isManaged()) {
                        System.out.println("   -> Managing GSM: " + processingUnit.getManagingGridServiceManager().getUid());
                    } else {
                        System.out.println("   -> Managing GSM: NA");
                    }
                    for (GridServiceManager backupGSM : processingUnit.getBackupGridServiceManagers()) {
                        System.out.println("   -> Backup GSM: " + backupGSM.getUid());
                    }
                    for (ProcessingUnitInstance processingUnitInstance : processingUnit) {
                        System.out.println("   [" + processingUnitInstance.getClusterInfo() + "] on GSC [" + processingUnitInstance.getGridServiceContainer().getUid() + "]");
                        for (ServiceMonitors monitors : processingUnitInstance.getStatistics()) {
                            System.out.println("      -> Service [" + monitors.getDetails().getId() + "] " + monitors.getMonitors());
                        }
                    }
                }
                for (Space space : admin.getSpaces()) {
                    System.out.println("Space [" + space.getUid() + "] numberOfInstances [" + space.getNumberOfInstances() + "] numberOfbackups [" + space.getNumberOfBackups() + "]");
                    System.out.println("  Stats: Write [" + space.getStatistics().getWriteCount() + "/" + space.getStatistics().getWritePerSecond() + "]");
                    for (SpaceInstance spaceInstance : space) {
                        System.out.println("   -> INSTANCE [" + spaceInstance.getUid() + "] instanceId [" + spaceInstance.getInstanceId() + "] backupId [" + spaceInstance.getBackupId() + "] Mode [" + spaceInstance.getMode() + "]");
                        System.out.println("         -> Host: " + spaceInstance.getMachine().getHostAddress());
                        System.out.println("         -> Stats: Write [" + spaceInstance.getStatistics().getWriteCount() + "/" + spaceInstance.getStatistics().getWritePerSecond() + "]");
                        System.out.println("         -> Stats: Read [" + spaceInstance.getStatistics().getReadCount() + "/" + spaceInstance.getStatistics().getReadPerSecond() + "]");
                    }
                    for (SpacePartition spacePartition : space.getPartitions()) {
                        System.out.println("   -> Partition [" + spacePartition.getPartitionId() + "]");
                        Iterator iterator = spacePartition.iterator();
                        while (iterator.hasNext()) {
                            SpaceInstance spaceInstance = (SpaceInstance)iterator.next();
                            System.out.println("      -> INSTANCE [" + spaceInstance.getUid() + "]");
                        }
                    }
                }
                System.out.println("*********************************************************************");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Thread.sleep(1000L);
        }
    }
}

