/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.space;

import com.gigaspaces.security.directory.UserDetails;
import java.io.File;
import org.openspaces.admin.internal.pu.dependency.InternalProcessingUnitDependencies;
import org.openspaces.admin.internal.pu.dependency.ProcessingUnitDetailedDependencies;
import org.openspaces.admin.pu.config.UserDetailsConfig;
import org.openspaces.admin.pu.dependency.ProcessingUnitDependency;
import org.openspaces.admin.pu.dependency.ProcessingUnitDeploymentDependenciesConfigurer;
import org.openspaces.admin.pu.topology.ProcessingUnitConfigHolder;
import org.openspaces.admin.pu.topology.ProcessingUnitDeploymentTopology;
import org.openspaces.admin.space.config.SpaceConfig;

public class SpaceDeployment
implements ProcessingUnitDeploymentTopology {
    private final SpaceConfig config = new SpaceConfig();

    public SpaceDeployment(String spaceName) {
        this.config.setName(spaceName);
    }

    @Deprecated
    public String getSpaceName() {
        return this.config.getName();
    }

    public SpaceDeployment partitioned(int numberOfPartitions, int numberOfBackups) {
        this.clusterSchema("partitioned");
        this.numberOfInstances(numberOfPartitions);
        this.numberOfBackups(numberOfBackups);
        return this;
    }

    public SpaceDeployment replicated(boolean async, int numberOfInstances) {
        if (async) {
            this.clusterSchema("async_replicated");
        } else {
            this.clusterSchema("sync_replicated");
        }
        this.numberOfInstances(numberOfInstances);
        this.numberOfBackups(0);
        return this;
    }

    public SpaceDeployment clusterSchema(String clusterSchema) {
        this.config.setClusterSchema(clusterSchema);
        return this;
    }

    public SpaceDeployment numberOfInstances(int numberOfInstances) {
        this.config.setNumberOfInstances(numberOfInstances);
        return this;
    }

    public SpaceDeployment numberOfBackups(int numberOfBackups) {
        this.config.setNumberOfBackups(numberOfBackups);
        return this;
    }

    public SpaceDeployment requiresIsolation(boolean requiresIsolation) {
        this.config.setRequiresIsolation(requiresIsolation);
        return this;
    }

    public SpaceDeployment maxInstancesPerVM(int maxInstancesPerVM) {
        this.config.setMaxInstancesPerVM(maxInstancesPerVM);
        return this;
    }

    public SpaceDeployment maxInstancesPerMachine(int maxInstancesPerMachine) {
        this.config.setMaxInstancesPerMachine(maxInstancesPerMachine);
        return this;
    }

    public SpaceDeployment maxInstancesPerZone(String zone, int maxInstancesPerZone) {
        this.config.setMaxInstancesPerZone(zone, maxInstancesPerZone);
        return this;
    }

    public SpaceDeployment addZone(String zone) {
        this.config.addZone(zone);
        return this;
    }

    public SpaceDeployment primaryZone(String zone) {
        this.config.setPrimaryZone(zone);
        return this;
    }

    public SpaceDeployment setContextProperty(String key, String value) {
        this.config.setContextProperty(key, value);
        return this;
    }

    @Override
    public SpaceDeployment secured(boolean secured) {
        this.config.setSecured(secured);
        return this;
    }

    @Override
    public SpaceDeployment userDetails(UserDetails userDetails) {
        this.userDetails(userDetails.getUsername(), userDetails.getPassword());
        return this;
    }

    @Override
    public SpaceDeployment userDetails(String userName, String password) {
        UserDetailsConfig userDetailsConfig = new UserDetailsConfig();
        userDetailsConfig.setUsername(userName);
        userDetailsConfig.setPassword(password);
        this.config.setUserDetails(userDetailsConfig);
        return this;
    }

    public SpaceDeployment slaLocation(String slaLocation) {
        this.config.setSlaLocation(slaLocation);
        return this;
    }

    public SpaceDeployment slaLocation(File slaLocation) {
        this.slaLocation(slaLocation.getAbsolutePath());
        return this;
    }

    @Override
    public SpaceDeployment addDependencies(ProcessingUnitDetailedDependencies<? extends ProcessingUnitDependency> deploymentDependencies) {
        ((InternalProcessingUnitDependencies)this.config.getDependencies()).addDetailedDependencies(deploymentDependencies);
        return this;
    }

    @Override
    public SpaceDeployment addDependency(String requiredProcessingUnitName) {
        this.addDependencies((ProcessingUnitDetailedDependencies)new ProcessingUnitDeploymentDependenciesConfigurer().dependsOnDeployed(requiredProcessingUnitName).create());
        return this;
    }

    @Override
    public ProcessingUnitConfigHolder create() {
        return this.config;
    }
}

