/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.support;

import java.text.DecimalFormat;

public class StatisticsUtils {
    static double megabytesFactor = 9.53674316 * Math.pow(10.0, -7.0);
    static double gigabyesFactor = 9.53674316 * Math.pow(10.0, -10.0);
    private static final DecimalFormat _numberFloatFormatter = new DecimalFormat();

    public static double convertToKilobytes(long bytes) {
        return 9.765625E-4 * (double)bytes;
    }

    public static double convertToMB(long bytes) {
        return megabytesFactor * (double)bytes;
    }

    public static double convertToGB(long bytes) {
        return gigabyesFactor * (double)bytes;
    }

    public static double computePerc(int value, int max) {
        return (double)value / (double)max * 100.0;
    }

    public static double computePerc(long value, long max) {
        return (double)value / (double)max * 100.0;
    }

    public static double computePerc(double percVal) {
        return percVal / 100.0;
    }

    public static double computePercByTime(long currentTime, long previousTime, long currentTimestamp, long previousTimestamp) {
        return (double)(currentTime - previousTime) / (double)(currentTimestamp - previousTimestamp);
    }

    public static double computePerSecond(long currentCount, long previousCount, long currentTimestamp, long previousTimestamp) {
        double stat = (double)(currentCount - previousCount) / (double)(currentTimestamp - previousTimestamp) * 1000.0;
        if (stat < 0.0) {
            return 0.0;
        }
        return stat;
    }

    public static String formatPerc(double perc) {
        if (perc == -1.0) {
            return "NA";
        }
        return _numberFloatFormatter.format(perc * 100.0) + '%';
    }

    static {
        _numberFloatFormatter.setMaximumFractionDigits(1);
    }
}

