/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.zone.config;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openspaces.admin.config.AbstractConfig;
import org.openspaces.admin.zone.config.ZonesConfig;

public abstract class AbstractZonesConfig
extends AbstractConfig
implements ZonesConfig {
    private static final String ZONES_KEY = "zones";

    protected AbstractZonesConfig(Map<String, String> properties) {
        super(properties);
    }

    @Override
    public void validate() throws IllegalStateException {
        Set<String> zones = this.getZones();
        if (zones == null) {
            throw new IllegalStateException("zones cannot be null");
        }
        for (String zone : zones) {
            if (zone == null) {
                throw new IllegalStateException("zone cannot be null");
            }
            if (!zone.isEmpty()) continue;
            throw new IllegalStateException("zone cannot be empty");
        }
    }

    @Override
    public Set<String> getZones() {
        return super.getStringProperties().getSet(ZONES_KEY, ",", new HashSet());
    }

    @Override
    public void setZones(Set<String> zones) {
        for (String zone : zones) {
            if (!zone.isEmpty()) continue;
            throw new IllegalArgumentException("zone cannot be empty");
        }
        super.getStringProperties().putSet(ZONES_KEY, zones, ",");
        this.validate();
    }
}

