/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.bean;

import java.util.Map;
import org.openspaces.admin.Admin;
import org.openspaces.admin.bean.BeanConfigNotFoundException;
import org.openspaces.admin.bean.BeanConfigurationException;
import org.openspaces.admin.bean.BeanInitializationException;
import org.openspaces.core.bean.Bean;
import org.openspaces.core.bean.BeanFactory;
import org.openspaces.core.bean.BeanServer;

public class DefaultBeanFactory<T extends Bean>
implements BeanFactory<T> {
    Admin admin;

    public DefaultBeanFactory(Admin admin) {
        this.admin = admin;
    }

    @Override
    public T create(String beanClassName, Map<String, String> properties, BeanServer<T> beanServer) throws BeanConfigNotFoundException, BeanInitializationException {
        T instance = this.createInstance(beanClassName, properties, beanServer);
        this.initInstance(beanClassName, instance);
        return instance;
    }

    private void initInstance(String beanClassName, T instance) throws BeanInitializationException {
        try {
            instance.afterPropertiesSet();
        }
        catch (BeanInitializationException e) {
            throw e;
        }
        catch (BeanConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanInitializationException(beanClassName + " initialization error", e);
        }
    }

    protected T createInstance(String beanClassName, Map<String, String> properties, BeanServer<T> beanServer) {
        Bean instance = null;
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(beanClassName);
            instance = (Bean)clazz.newInstance();
        }
        catch (Exception e) {
            throw new BeanConfigNotFoundException("Failed to instantiate bean bean class [" + beanClassName + "]", e);
        }
        instance.setAdmin(this.admin);
        instance.setProperties(properties);
        return (T)instance;
    }
}

