/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.Admin;
import org.openspaces.admin.bean.BeanConfigNotFoundException;
import org.openspaces.admin.bean.BeanConfigurationException;
import org.openspaces.admin.bean.BeanInitializationException;
import org.openspaces.admin.bean.EnabledBeanConfigCannotBeChangedException;
import org.openspaces.core.bean.Bean;
import org.openspaces.core.bean.BeanFactory;
import org.openspaces.core.bean.BeanServer;
import org.openspaces.core.bean.DefaultBeanFactory;

public class DefaultBeanServer<T extends Bean>
implements BeanServer<T> {
    private static final Log logger = LogFactory.getLog(DefaultBeanServer.class);
    private final Map<String, Map<String, String>> beansProperties = new HashMap<String, Map<String, String>>();
    private final Map<String, T> enabledBeans = new HashMap<String, T>();
    private final BeanFactory<T> beanFactory;

    public DefaultBeanServer(Admin admin) {
        this(new DefaultBeanFactory(admin));
    }

    public DefaultBeanServer(BeanFactory<T> beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public void setBeanConfig(String beanClassName, Map<String, String> properties) throws EnabledBeanConfigCannotBeChangedException {
        if (this.isBeanEnabled(beanClassName)) {
            throw new EnabledBeanConfigCannotBeChangedException("Cannot modify bean [" + beanClassName + "] configuration while it is enabled. Disable it first.");
        }
        this.beansProperties.put(beanClassName, properties);
    }

    @Override
    public void enableBean(String beanClassName) throws BeanConfigNotFoundException, BeanConfigurationException, BeanInitializationException {
        if (beanClassName == null) {
            throw new IllegalArgumentException("beanClassName cannot be null");
        }
        Map<String, String> properties = this.beansProperties.get(beanClassName);
        if (properties == null) {
            throw new BeanConfigNotFoundException("Failed to enable bean [" + beanClassName + "] since it does not exist.");
        }
        if (!this.isBeanEnabled(beanClassName)) {
            T beanInstance = this.beanFactory.create(beanClassName, properties, this);
            this.enabledBeans.put(beanClassName, beanInstance);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Bean " + beanClassName + " enabled."));
            }
        }
    }

    @Override
    public void disableBean(String beanClassName) throws BeanConfigNotFoundException {
        if (!this.beansProperties.containsKey(beanClassName)) {
            throw new BeanConfigNotFoundException("Failed to disable bean [" + beanClassName + "] - doesn't exist.");
        }
        Bean instance = (Bean)this.enabledBeans.remove(beanClassName);
        if (instance != null) {
            this.disableBeanInternal(instance);
        }
    }

    private void disableBeanInternal(T instance) {
        try {
            instance.destroy();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Bean " + instance.getClass() + " disabled."));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error destroying beanClassName " + instance.getClass().getName()), (Throwable)e);
        }
    }

    @Override
    public boolean removeBeanConfig(String beanClassName) throws BeanConfigNotFoundException {
        if (this.isBeanEnabled(beanClassName)) {
            throw new EnabledBeanConfigCannotBeChangedException("Cannot remove configuration of beanClassName " + beanClassName + " since it is enabled. disable it first.");
        }
        return this.beansProperties.remove(beanClassName) != null;
    }

    @Override
    public boolean isBeanEnabled(String beanClassName) {
        return this.enabledBeans.containsKey(beanClassName);
    }

    @Override
    public Map<String, String> getBeanConfig(String beanClassName) throws BeanConfigNotFoundException {
        if (!this.beansProperties.containsKey(beanClassName)) {
            throw new BeanConfigNotFoundException("Failed to get bean [" + beanClassName + "] since it does not exist.");
        }
        HashMap<String, String> properties = new HashMap<String, String>(this.beansProperties.get(beanClassName));
        return properties;
    }

    @Override
    public String[] getBeansClassNames() {
        String[] startegies = this.beansProperties.keySet().toArray(new String[this.beansProperties.size()]);
        return startegies;
    }

    @Override
    public String[] getEnabledBeansClassNames() {
        String[] startegies = this.enabledBeans.keySet().toArray(new String[this.enabledBeans.size()]);
        return startegies;
    }

    @Override
    public void disableAllBeans() {
        for (Bean instance : this.enabledBeans.values()) {
            this.disableBeanInternal(instance);
        }
        this.enabledBeans.clear();
    }

    @Override
    public T getEnabledBean(String beanClassName) {
        return (T)((Bean)this.enabledBeans.get(beanClassName));
    }

    @Override
    public void disableAllBeansAssignableTo(Class<?> interfaceClass) {
        for (String beanClassName : this.getEnabledBeansClassNamesAssignableTo(interfaceClass)) {
            this.disableBean(beanClassName);
        }
    }

    private List<String> getEnabledBeansClassNamesAssignableTo(Class<?> interfaceClass) {
        ArrayList<String> beanClassNames = new ArrayList<String>();
        for (String beanClassName : this.enabledBeans.keySet()) {
            if (!interfaceClass.isInstance(this.enabledBeans.get(beanClassName))) continue;
            beanClassNames.add(beanClassName);
        }
        return beanClassNames;
    }

    @Override
    public boolean replaceBeanAssignableTo(Class<?>[] interfaceClasses, String newBeanClassName, Map<String, String> newBeanProperties) throws BeanInitializationException {
        List<String> enabledBeansClassNames;
        if (newBeanClassName == null) {
            throw new IllegalArgumentException("config.getBeanClassName() cannot be null.");
        }
        if (newBeanProperties == null) {
            throw new IllegalArgumentException("config.getProperties() cannot be null.");
        }
        try {
            if (!this.isClassNameAssignableFrom(newBeanClassName, interfaceClasses)) {
                throw new BeanConfigurationException(newBeanClassName + " does not implement any of the supplied classes " + Arrays.toString(interfaceClasses));
            }
            enabledBeansClassNames = this.getEnabledBeansClassNamesAssignableTo(interfaceClasses);
            if (enabledBeansClassNames.size() > 1) {
                throw new IllegalStateException("Calling replaceBeanAssignableTo assumes there is only one enabled bean assignable to " + Arrays.toString(interfaceClasses) + ". Instead there are " + enabledBeansClassNames.size() + ": " + Arrays.toString(enabledBeansClassNames.toArray(new String[0])));
            }
        }
        catch (ClassNotFoundException e) {
            throw new BeanConfigurationException("Problem creating new bean instance of class " + newBeanClassName, e);
        }
        String enabledBeanClassName = null;
        Map<String, String> beanProperties = null;
        boolean noChangeRequired = false;
        if (enabledBeansClassNames.size() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Request was made to enable bean instance " + newBeanClassName));
            }
        } else {
            enabledBeanClassName = enabledBeansClassNames.get(0);
            beanProperties = this.getBeanConfig(enabledBeanClassName);
            boolean bl = noChangeRequired = newBeanClassName.equals(enabledBeanClassName) && newBeanProperties.equals(beanProperties);
            if (logger.isDebugEnabled()) {
                if (!newBeanClassName.equals(enabledBeanClassName)) {
                    logger.debug((Object)("Request was made to replace enabled bean instance " + enabledBeanClassName + " with " + newBeanClassName));
                } else if (!newBeanProperties.equals(beanProperties)) {
                    logger.debug((Object)("Request was made to update enabled bean instance " + enabledBeanClassName + " with new configuration."));
                } else {
                    logger.debug((Object)("Request to update enabled bean instance " + enabledBeanClassName + " is ignored since no configuration change detected."));
                }
            }
        }
        if (!noChangeRequired) {
            if (enabledBeanClassName != null) {
                this.disableBean(enabledBeanClassName);
            }
            this.setBeanConfig(newBeanClassName, newBeanProperties);
            this.enableBean(newBeanClassName);
        }
        return !noChangeRequired;
    }

    @Override
    public List<String> getEnabledBeansClassNamesAssignableTo(Class<?>[] interfaceClasses) throws ClassNotFoundException {
        ArrayList<String> beansClassNames = new ArrayList<String>();
        for (String beanClassName : this.enabledBeans.keySet()) {
            if (!this.isClassNameAssignableFrom(beanClassName, interfaceClasses)) continue;
            beansClassNames.add(beanClassName);
        }
        return beansClassNames;
    }

    private boolean isClassNameAssignableFrom(String implementationClassName, Class<?>[] interfaceClassNames) throws ClassNotFoundException {
        boolean classNameInstanceof = false;
        for (Class<?> interfaceClass : interfaceClassNames) {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(implementationClassName);
            if (!interfaceClass.isAssignableFrom(clazz)) continue;
            classNameInstanceof = true;
            break;
        }
        return classNameInstanceof;
    }

    @Override
    public void destroy() {
        this.disableAllBeans();
    }

    @Override
    public List<T> getEnabledBeansAssignableTo(Class<?>[] interfaceClasses) {
        ArrayList<T> beanInstances = new ArrayList<T>();
        try {
            for (String beanClassName : this.getEnabledBeansClassNamesAssignableTo(interfaceClasses)) {
                beanInstances.add(this.enabledBeans.get(beanClassName));
            }
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"Problem occurred while scanning list of enabled containers", (Throwable)e);
        }
        return beanInstances;
    }
}

