/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.gateway;

import com.gigaspaces.internal.dump.InternalDump;
import com.gigaspaces.internal.dump.InternalDumpProcessor;
import com.gigaspaces.internal.dump.InternalDumpProcessorFailedException;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.lrmi.LRMIRuntime;
import com.gigaspaces.lrmi.ProtocolAdapter;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.DefaultCredentialsProvider;
import com.gigaspaces.security.directory.UserDetails;
import java.io.PrintWriter;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.Admin;
import org.openspaces.admin.AdminFactory;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceAddedEventListener;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.cluster.ClusterInfoAware;
import org.openspaces.core.gateway.GSCForkHandler;
import org.openspaces.core.gateway.GatewayLookup;
import org.openspaces.core.gateway.GatewayLookupsFactoryBean;
import org.openspaces.core.properties.BeanLevelMergedPropertiesAware;
import org.openspaces.core.space.SecurityConfig;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractGatewayComponentFactoryBean
implements DisposableBean,
InitializingBean,
ClusterInfoAware,
ProcessingUnitInstanceAddedEventListener,
BeanLevelMergedPropertiesAware,
InternalDumpProcessor,
BeanNameAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String localGatewayName;
    private GatewayLookupsFactoryBean gatewayLookups;
    private Boolean startEmbeddedLus = null;
    private boolean relocateIfWrongPorts = true;
    private int communicationPort;
    private int discoveryPort;
    private String puName;
    private boolean relocatingInvoked;
    private Admin admin;
    private boolean communicationPortIsSet;
    private SecurityConfig securityConfig;
    private Properties beanLevelProperties;
    private String beanName;
    private static String customJvmProperties;
    private static final Object relocationDecisionLock;
    private static boolean relocationInProgress;

    public void setClusterInfo(ClusterInfo clusterInfo) {
        this.puName = clusterInfo.getName();
    }

    public String getLocalGatewayName() {
        return this.localGatewayName;
    }

    public void setLocalGatewayName(String localGatewayName) {
        this.localGatewayName = localGatewayName;
    }

    public GatewayLookupsFactoryBean getGatewayLookups() {
        return this.gatewayLookups;
    }

    public void setGatewayLookups(GatewayLookupsFactoryBean gatewayLookups) {
        this.gatewayLookups = gatewayLookups;
    }

    public boolean isStartEmbeddedLus() {
        if (this.startEmbeddedLus == null) {
            return this.gatewayLookups != null;
        }
        return this.startEmbeddedLus;
    }

    public void setStartEmbeddedLus(boolean startEmbeddedLus) {
        this.startEmbeddedLus = startEmbeddedLus;
    }

    public boolean isRelocateIfWrongPorts() {
        return this.relocateIfWrongPorts;
    }

    public void setRelocateIfWrongPorts(boolean relocateIfWrongPorts) {
        this.relocateIfWrongPorts = relocateIfWrongPorts;
    }

    public void setCustomJvmProperties(String jvmProperties) {
        if (customJvmProperties != null) {
            throw new IllegalStateException("customJvmProperties has already been set");
        }
        customJvmProperties = jvmProperties;
    }

    public String getCustomJvmProperties() {
        return customJvmProperties;
    }

    public int getCommunicationPort() {
        return this.communicationPort;
    }

    public int getDiscoveryPort() {
        return this.discoveryPort;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getName() {
        return this.beanName;
    }

    public void setCommunicationPort(int communicationPort) {
        this.communicationPort = communicationPort;
        this.communicationPortIsSet = true;
    }

    public void setSecurityConfig(SecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
    }

    public void setUserDetails(UserDetails userDetails) {
        this.setCredentialsProvider((CredentialsProvider)new DefaultCredentialsProvider(userDetails));
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.securityConfig = new SecurityConfig(credentialsProvider);
    }

    public void setMergedBeanLevelProperties(Properties beanLevelProperties) {
        this.beanLevelProperties = beanLevelProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        Object securityConfig;
        if (this.beanLevelProperties != null) {
            securityConfig = SecurityConfig.fromMarshalledProperties((Properties)this.beanLevelProperties);
            if (securityConfig != null) {
                this.setSecurityConfig((SecurityConfig)securityConfig);
            }
            this.beanLevelProperties = null;
        }
        if (this.puName != null) {
            securityConfig = relocationDecisionLock;
            synchronized (securityConfig) {
                if (relocationInProgress) {
                    return;
                }
                if (!this.checkDeployedWithProperPorts()) {
                    relocationInProgress = true;
                    AdminFactory adminFactory = new AdminFactory();
                    if (this.securityConfig != null) {
                        adminFactory.credentialsProvider(this.securityConfig.getCredentialsProvider());
                    }
                    this.admin = adminFactory.create();
                    this.admin.getProcessingUnits().getProcessingUnitInstanceAdded().add(this);
                    return;
                }
            }
        }
        SecurityConfig transientSecurityConfig = this.securityConfig;
        this.securityConfig = null;
        this.afterPropertiesSetImpl(transientSecurityConfig);
    }

    protected abstract void afterPropertiesSetImpl(SecurityConfig var1);

    public void destroy() throws Exception {
        this.destroyImpl();
        if (this.admin != null) {
            this.admin.close();
        }
    }

    protected abstract void destroyImpl();

    private boolean checkDeployedWithProperPorts() {
        this.initNeededPorts();
        int currentCommunicationPort = 0;
        ProtocolAdapter port = (ProtocolAdapter)LRMIRuntime.getRuntime().getProtocolRegistry().get((Object)"NIO");
        if (port != null) {
            currentCommunicationPort = port.getPort();
        }
        this.logger.info((Object)("current communication port: " + currentCommunicationPort + ", target GSC port: " + this.communicationPort));
        if (currentCommunicationPort == 0) {
            this.logger.info((Object)"Could not find the NIO protocol adapter. This is normal if running in an IntegratedProcessingUnitContainer");
        } else if (this.communicationPort != 0 && currentCommunicationPort != this.communicationPort) {
            if (this.isRelocateIfWrongPorts()) {
                this.logger.info((Object)"This GSC is not running on the required communication port. This instance will be relocated to GSC with required communication port.");
                return false;
            }
            this.logger.info((Object)"This GSC is not running on the required communication port. Relocate if wrong ports encountered is disabled.");
        }
        if (this.isStartEmbeddedLus()) {
            int currentDiscoPort = Integer.parseInt(System.getProperty("com.sun.jini.reggie.initialUnicastDiscoveryPort", "0"));
            this.logger.info((Object)("Discovery port: " + currentDiscoPort + ", target Discovery port: " + this.discoveryPort));
            if (this.discoveryPort != 0 && currentDiscoPort != this.discoveryPort) {
                if (this.isRelocateIfWrongPorts()) {
                    this.logger.info((Object)"This GSC is not running with the required Unicast Discovery port. This instance will be relocated to GSC with required communication port.");
                    return false;
                }
                this.logger.info((Object)"This GSC is not running with the required Unicast Discovery port. Relocate if wrong ports encountered is disabled.");
            }
        }
        return true;
    }

    private void initNeededPorts() {
        StringBuilder foundGateways = null;
        if (this.getGatewayLookups() == null) {
            return;
        }
        for (GatewayLookup gatewayLookup : this.getGatewayLookups().getGatewayLookups()) {
            if (gatewayLookup.getGatewayName().equals(this.getLocalGatewayName())) {
                if (!this.communicationPortIsSet) {
                    this.communicationPort = StringUtils.hasLength((String)gatewayLookup.getCommunicationPort()) ? Integer.valueOf(gatewayLookup.getCommunicationPort()) : 0;
                }
                this.discoveryPort = Integer.valueOf(gatewayLookup.getDiscoveryPort());
                return;
            }
            if (foundGateways == null) {
                foundGateways = new StringBuilder("found gateways: [");
                foundGateways.append(gatewayLookup.getGatewayName());
            }
            foundGateways.append(", ");
            foundGateways.append(gatewayLookup.getGatewayName());
        }
        foundGateways.append("]");
        throw new IllegalArgumentException("Could not locate local gateway [" + this.getLocalGatewayName() + "] in lookup parameters - " + foundGateways.toString());
    }

    @Override
    public synchronized void processingUnitInstanceAdded(ProcessingUnitInstance processingUnitInstance) {
        if (!this.relocatingInvoked && this.puName.equals(processingUnitInstance.getProcessingUnit().getName())) {
            this.relocatingInvoked = true;
            final GSCForkHandler gscForkHandler = new GSCForkHandler(this.communicationPort, this.discoveryPort, this.isStartEmbeddedLus(), processingUnitInstance, customJvmProperties);
            ((InternalAdmin)this.admin).scheduleAdminOperation(new Runnable(){

                @Override
                public void run() {
                    gscForkHandler.movePuToAlternativeGSC();
                    AbstractGatewayComponentFactoryBean.this.admin.close();
                }
            });
        }
    }

    public void process(InternalDump dump) throws InternalDumpProcessorFailedException {
        dump.addPrefix("gateway/");
        try {
            PrintWriter writer = new PrintWriter(dump.createFileWriter(this.beanName + ".txt"));
            writer.println("=============================================");
            writer.println(" Gateway component type: " + this.getGatewayComponentTypeName());
            writer.println("=============================================");
            writer.println(this.dumpState());
            writer.close();
        }
        finally {
            dump.removePrefix();
        }
    }

    protected abstract String getGatewayComponentTypeName();

    protected abstract String dumpState();

    static {
        relocationDecisionLock = new Object();
        relocationInProgress = false;
    }
}

