/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.gateway;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.gsa.GridServiceContainerOptions;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.core.gateway.GatewayUtils;
import org.springframework.util.StringUtils;

public class GSCForkHandler {
    private static final int ADMIN_GSC_STARTUP_TIMEOUT_SECS = 600;
    protected final Log logger = LogFactory.getLog(GSCForkHandler.class);
    private final ProcessingUnitInstance pui;
    private final int lrmiPort;
    private final int discoveryPort;
    private static final String LRMI_PORT_SYSTEM_PROPERTY = "com.gs.transport_protocol.lrmi.bind-port";
    private static final String LRMI_PORT_PROPERTY_TEMPLATE = "-Dcom.gs.transport_protocol.lrmi.bind-port=<LRMI_PORT>";
    private static final String DISCOVERY_PORT_SYSTEM_PROPERTY = "com.sun.jini.reggie.initialUnicastDiscoveryPort";
    private static final String DISCOVERY_PORT_PROPERTY_TEMPLATE = "-Dcom.sun.jini.reggie.initialUnicastDiscoveryPort=<DISCOVERY_PORT>";
    public static final String AGENT_EXT_JAVA_OPTIONS = "-Dcom.gs.transport_protocol.lrmi.bind-port=<LRMI_PORT> -Dcom.sun.jini.reggie.initialUnicastDiscoveryPort=<DISCOVERY_PORT>";
    private final boolean startEmbeddedLus;
    private final String customJvmProperties;

    public GSCForkHandler(int lrmiPort, int discoveryPort, boolean startEmbeddedLus, ProcessingUnitInstance pui, String customJvmProperties) {
        this.lrmiPort = lrmiPort;
        this.startEmbeddedLus = startEmbeddedLus;
        this.pui = pui;
        this.discoveryPort = discoveryPort;
        this.customJvmProperties = customJvmProperties;
    }

    private String createDiscoveryPortProperty(int discoveryPort) {
        return DISCOVERY_PORT_PROPERTY_TEMPLATE.replace("<DISCOVERY_PORT>", Integer.toString(discoveryPort));
    }

    private String createLrmiPortProperty(int gscPort) {
        return LRMI_PORT_PROPERTY_TEMPLATE.replace("<LRMI_PORT>", Integer.toString(gscPort));
    }

    private String[] createGSCExtraCommandLineArguments() {
        LinkedList<String> arguments = new LinkedList<String>();
        if (this.lrmiPort != 0) {
            arguments.add(this.createLrmiPortProperty(this.lrmiPort));
        }
        if (this.startEmbeddedLus) {
            arguments.add(this.createDiscoveryPortProperty(this.discoveryPort));
        }
        if (StringUtils.hasLength((String)this.customJvmProperties)) {
            arguments.addAll(Arrays.asList(this.customJvmProperties.split(" ")));
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    public void movePuToAlternativeGSC() {
        this.logger.info((Object)"Locating GSC which meets communication/discovery ports requirement");
        GridServiceContainer gsc = this.locateExistingGSCWithPorts();
        if (gsc == null) {
            this.logger.info((Object)"Suitable GSC not found - attempting to create a new GSC");
            if (!GatewayUtils.checkPortAvailable(this.lrmiPort)) {
                String exceptionMessage = "The required communication port for the new GSC(" + this.lrmiPort + ") is not available!";
                this.logger.error((Object)exceptionMessage);
                throw new IllegalArgumentException(exceptionMessage);
            }
            if (this.startEmbeddedLus && !GatewayUtils.checkPortAvailable(this.discoveryPort)) {
                String exceptionMessage = "The required discovery port for the new GSC(" + this.discoveryPort + ") is not available!";
                this.logger.error((Object)exceptionMessage);
                throw new IllegalArgumentException(exceptionMessage);
            }
            GridServiceAgent gsa = null;
            this.logger.info((Object)"Looking up GSA on local machine");
            gsa = this.findLocalGSA();
            if (gsa == null) {
                this.logger.error((Object)"Could not find local GSA. Cannot start alternative GSC");
                throw new IllegalStateException("Could not find local GSA. Cannot start alternative GSC");
            }
            this.logger.info((Object)"Found local GSA - starting new GSC");
            gsc = this.createGSCWithGsa(gsa);
            this.logger.info((Object)("Created new GSC: " + gsc.getUid() + ", relocating this instance into it"));
        } else {
            this.logger.info((Object)("Found existing GSC: " + gsc.getUid() + " with matching ports, relocating this instance into it"));
        }
        this.logger.info((Object)("Relocating " + this.pui.getProcessingUnitInstanceName() + " to GSC uid=" + gsc.getUid() + " machine=" + gsc.getMachine().getHostAddress() + " pid=" + gsc.getVirtualMachine().getDetails().getPid()));
        this.pui.relocate(gsc);
    }

    private GridServiceContainer locateExistingGSCWithPorts() {
        for (GridServiceContainer gsc : this.pui.getAdmin().getGridServiceContainers()) {
            int gscPort = gsc.getTransport().getPort();
            if (gscPort != this.lrmiPort) continue;
            return gsc;
        }
        return null;
    }

    private GridServiceContainer createGSCWithGsa(GridServiceAgent gsa) {
        Object[] props;
        GridServiceContainerOptions gsco = new GridServiceContainerOptions();
        for (String string : props = this.createGSCExtraCommandLineArguments()) {
            gsco.vmInputArgument(string);
        }
        this.logger.info((Object)("starting GSC with parameters: " + Arrays.toString(props)));
        GridServiceContainer gsc = gsa.startGridServiceAndWait(gsco, 600L, TimeUnit.SECONDS);
        if (gsc == null) {
            throw new IllegalStateException("Failed to create new GSC for gateway");
        }
        return gsc;
    }

    private GridServiceAgent findLocalGSA() {
        GridServiceContainer gsc = this.pui.getGridServiceContainer();
        if (gsc == null) {
            this.logger.error((Object)"Error - could not find the GSC that this PUI belongs to");
            return null;
        }
        GridServiceAgent gsa = gsc.getGridServiceAgent();
        return gsa;
    }
}

