/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.gateway;

import com.gigaspaces.internal.cluster.node.impl.gateway.ReplicationDelegationConfig;
import com.gigaspaces.internal.cluster.node.impl.gateway.delegator.ReplicationConnectionDelegatorConfig;
import com.gigaspaces.internal.cluster.node.impl.gateway.delegator.ReplicationConnectionDelegatorContainer;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.ReplicationLookupParameters;
import com.gigaspaces.lrmi.nio.info.NIOInfoHelper;
import java.util.Iterator;
import java.util.List;
import org.openspaces.core.gateway.AbstractGatewayComponentFactoryBean;
import org.openspaces.core.gateway.GatewayDelegation;
import org.openspaces.core.gateway.GatewayDelegatorServiceDetails;
import org.openspaces.core.space.SecurityConfig;
import org.openspaces.pu.service.ServiceDetails;
import org.openspaces.pu.service.ServiceDetailsProvider;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class GatewayDelegatorFactoryBean
extends AbstractGatewayComponentFactoryBean
implements DisposableBean,
InitializingBean,
ServiceDetailsProvider {
    private ReplicationConnectionDelegatorContainer replicationConnectiondelegatorContainer;
    private List<GatewayDelegation> gatewayDelegations;

    public List<GatewayDelegation> getGatewayDelegations() {
        return this.gatewayDelegations;
    }

    public void setGatewayDelegations(List<GatewayDelegation> gatewayDelegations) {
        this.gatewayDelegations = gatewayDelegations;
    }

    @Override
    protected void afterPropertiesSetImpl(SecurityConfig securityConfig) {
        ReplicationConnectionDelegatorConfig config = new ReplicationConnectionDelegatorConfig(this.getLocalGatewayName());
        config.setStartLookupService(this.isStartEmbeddedLus());
        if (this.getGatewayDelegations() != null) {
            Iterator<GatewayDelegation> iterator = this.getGatewayDelegations().iterator();
            while (iterator.hasNext()) {
                GatewayDelegation target = iterator.next();
                if (!target.getTarget().equals(this.getLocalGatewayName())) continue;
                iterator.remove();
            }
            for (GatewayDelegation delegation : this.getGatewayDelegations()) {
                ReplicationDelegationConfig replicationRoutingConfig = new ReplicationDelegationConfig();
                replicationRoutingConfig.setTargetName(delegation.getTarget());
                replicationRoutingConfig.setDelegation(delegation.getDelegateThrough());
                config.addDelegator(replicationRoutingConfig);
            }
        }
        if (this.getGatewayLookups() != null) {
            ReplicationLookupParameters lookupParameters = this.getGatewayLookups().asReplicationLookupParameters();
            config.setGatewayLookupParameters(lookupParameters);
        }
        this.replicationConnectiondelegatorContainer = new ReplicationConnectionDelegatorContainer(config);
    }

    @Override
    protected void destroyImpl() {
        if (this.replicationConnectiondelegatorContainer != null) {
            this.replicationConnectiondelegatorContainer.close();
            this.replicationConnectiondelegatorContainer = null;
        }
    }

    public ServiceDetails[] getServicesDetails() {
        return new ServiceDetails[]{new GatewayDelegatorServiceDetails(this.getLocalGatewayName(), this.getGatewayDelegations().toArray(new GatewayDelegation[this.getGatewayDelegations().size()]), NIOInfoHelper.getDetails().getPort(), this.getDiscoveryPort(), this.isStartEmbeddedLus())};
    }

    @Override
    protected String getGatewayComponentTypeName() {
        return "Delegator";
    }

    @Override
    protected String dumpState() {
        return this.replicationConnectiondelegatorContainer != null ? this.replicationConnectiondelegatorContainer.dumpState() : "";
    }
}

