/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.gateway;

import com.gigaspaces.internal.io.IOUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openspaces.core.gateway.GatewayDelegation;
import org.openspaces.core.gateway.GatewayServiceDetails;

public class GatewayDelegatorServiceDetails
extends GatewayServiceDetails {
    private static final long serialVersionUID = 1L;
    private GatewayDelegation[] _delegationTargets;
    public static final String SERVICE_SUB_TYPE = "gateway-delegator";

    public GatewayDelegatorServiceDetails() {
    }

    public GatewayDelegatorServiceDetails(String localGatewayName, GatewayDelegation[] gatewayDelegations, int discoveryPort, int communicationPort, boolean embeddedLus) {
        super(localGatewayName + "-delegator", SERVICE_SUB_TYPE, "gateway delegator (" + localGatewayName + ")", "gateway delegator (" + localGatewayName + ")", localGatewayName, discoveryPort, communicationPort, embeddedLus);
        this._delegationTargets = gatewayDelegations;
    }

    public GatewayDelegation[] getDelegationTargets() {
        return this._delegationTargets;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this._delegationTargets == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this._delegationTargets.length);
            for (int i = 0; i < this._delegationTargets.length; ++i) {
                IOUtils.writeRepetitiveString((ObjectOutput)out, (String)this._delegationTargets[i].getTarget());
                IOUtils.writeRepetitiveString((ObjectOutput)out, (String)this._delegationTargets[i].getDelegateThrough());
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int length = in.readInt();
        if (length == -1) {
            this._delegationTargets = null;
        } else {
            this._delegationTargets = new GatewayDelegation[length];
            for (int i = 0; i < this._delegationTargets.length; ++i) {
                String target = IOUtils.readRepetitiveString((ObjectInput)in);
                String delegateThrough = IOUtils.readRepetitiveString((ObjectInput)in);
                this._delegationTargets[i] = new GatewayDelegation(target, delegateThrough);
            }
        }
    }
}

