/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.gateway;

import com.gigaspaces.internal.cluster.node.impl.gateway.lus.ReplicationLookupParameters;
import java.util.List;
import java.util.UUID;
import net.jini.core.discovery.LookupLocator;
import org.openspaces.core.gateway.GatewayLookup;

public class GatewayLookupsFactoryBean {
    private String lookupGroup = GatewayLookupsFactoryBean.getAutoGeneratedLookupGroup();
    private List<GatewayLookup> gatewayLookups;

    public String getLookupGroup() {
        return this.lookupGroup;
    }

    public void setLookupGroup(String lookupGroup) {
        this.lookupGroup = lookupGroup;
    }

    public List<GatewayLookup> getGatewayLookups() {
        return this.gatewayLookups;
    }

    public void setGatewayLookups(List<GatewayLookup> gatewayLookups) {
        this.gatewayLookups = gatewayLookups;
    }

    public ReplicationLookupParameters asReplicationLookupParameters() {
        ReplicationLookupParameters parameters = new ReplicationLookupParameters();
        parameters.setLookupGroups(new String[]{this.lookupGroup});
        if (this.gatewayLookups != null) {
            LookupLocator[] locators = new LookupLocator[this.gatewayLookups.size()];
            for (int i = 0; i < this.gatewayLookups.size(); ++i) {
                GatewayLookup gatewayLookup = this.gatewayLookups.get(i);
                locators[i] = new LookupLocator(gatewayLookup.getHost(), Integer.valueOf(gatewayLookup.getDiscoveryPort()).intValue());
            }
            parameters.setLookupLocators(locators);
        }
        return parameters;
    }

    private static String getAutoGeneratedLookupGroup() {
        return "gateway-" + UUID.randomUUID().toString();
    }
}

