/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.gateway;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openspaces.pu.service.PlainServiceDetails;

public class GatewayServiceDetails
extends PlainServiceDetails {
    public static final String SERVICE_TYPE = "gateway";
    private static final long serialVersionUID = 1L;
    private String _localGatewayName;
    private int _discoveryPort;
    private int _communicationPort;
    private boolean _embeddedLus;

    public GatewayServiceDetails() {
    }

    public GatewayServiceDetails(String id, String subserviceType, String description, String longDescription, String localGatewayName, int discoveryPort, int communicationPort, boolean embeddedLus) {
        super(id, SERVICE_TYPE, subserviceType, description, longDescription);
        this._localGatewayName = localGatewayName;
        this._discoveryPort = discoveryPort;
        this._communicationPort = communicationPort;
        this._embeddedLus = embeddedLus;
    }

    public String getLocalGatewayName() {
        return this._localGatewayName;
    }

    public int getCommunicationPort() {
        return this._communicationPort;
    }

    public int getDiscoveryPort() {
        return this._discoveryPort;
    }

    public boolean isStartEmbeddedLus() {
        return this._embeddedLus;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeRepetitiveString((ObjectOutput)out, (String)this._localGatewayName);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_5_0)) {
            out.writeInt(this._communicationPort);
            out.writeInt(this._discoveryPort);
            out.writeBoolean(this._embeddedLus);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._localGatewayName = IOUtils.readRepetitiveString((ObjectInput)in);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_5_0)) {
            this._communicationPort = in.readInt();
            this._discoveryPort = in.readInt();
            this._embeddedLus = in.readBoolean();
        }
    }
}

