/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.gateway;

import com.gigaspaces.cluster.replication.gateway.sync.AbortOnConsolidationFailureInterceptor;
import com.gigaspaces.cluster.replication.gateway.sync.CommitOnConsolidationFailureInterceptor;
import com.gigaspaces.internal.cluster.node.impl.gateway.lus.ReplicationLookupParameters;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.BootstrapConfig;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterReplicationSink;
import com.gigaspaces.internal.cluster.node.impl.gateway.sink.LocalClusterReplicationSinkConfig;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.lrmi.nio.info.NIOInfoHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openspaces.core.gateway.AbstractGatewayComponentFactoryBean;
import org.openspaces.core.gateway.GatewaySinkDistributedTransactionProcessingConfigurationFactoryBean;
import org.openspaces.core.gateway.GatewaySinkServiceDetails;
import org.openspaces.core.gateway.GatewaySinkSyncEndpointInterceptorFactoryBean;
import org.openspaces.core.gateway.GatewaySource;
import org.openspaces.core.gateway.SinkErrorHandlingFactoryBean;
import org.openspaces.core.space.SecurityConfig;
import org.openspaces.pu.service.InvocableService;
import org.openspaces.pu.service.ServiceDetails;
import org.openspaces.pu.service.ServiceDetailsProvider;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class GatewaySinkFactoryBean
extends AbstractGatewayComponentFactoryBean
implements DisposableBean,
InitializingBean,
InvocableService,
ServiceDetailsProvider {
    private String localSpaceUrl;
    private List<GatewaySource> gatewaySources;
    private LocalClusterReplicationSink localClusterReplicationSink;
    private boolean requiresBootstrap;
    private SinkErrorHandlingFactoryBean errorHandlingConfiguration;
    private Long transactionTimeout;
    private Long localSpaceLookupTimeout;
    private GatewaySinkDistributedTransactionProcessingConfigurationFactoryBean transactionProcessingConfiguration;
    private GatewaySinkSyncEndpointInterceptorFactoryBean syncEndpointInterceptorConfiguration;

    public String getLocalSpaceUrl() {
        return this.localSpaceUrl;
    }

    public void setLocalSpaceUrl(String localSpaceUrl) {
        this.localSpaceUrl = localSpaceUrl;
    }

    public List<GatewaySource> getGatewaySources() {
        return this.gatewaySources;
    }

    public void setGatewaySources(List<GatewaySource> gatewaySources) {
        this.gatewaySources = gatewaySources;
    }

    public void setRequiresBootstrap(boolean requiresBootstrap) {
        this.requiresBootstrap = requiresBootstrap;
    }

    public boolean getRequiresBootstrap() {
        return this.requiresBootstrap;
    }

    public void setErrorHandlingConfiguration(SinkErrorHandlingFactoryBean errorHandlingConfiguration) {
        this.errorHandlingConfiguration = errorHandlingConfiguration;
    }

    public SinkErrorHandlingFactoryBean getErrorHandlingConfiguration() {
        return this.errorHandlingConfiguration;
    }

    public Long getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(Long transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public void setLocalSpaceLookupTimeout(Long lookupTimeout) {
        this.localSpaceLookupTimeout = lookupTimeout;
    }

    public Long getLocalSpaceLookupTimeout() {
        return this.localSpaceLookupTimeout;
    }

    public GatewaySinkDistributedTransactionProcessingConfigurationFactoryBean getDistributedTransactionProcessingConfiguration() {
        return this.transactionProcessingConfiguration;
    }

    public void setDistributedTransactionProcessingConfiguration(GatewaySinkDistributedTransactionProcessingConfigurationFactoryBean transactionProcessingConfiguration) {
        this.transactionProcessingConfiguration = transactionProcessingConfiguration;
    }

    public GatewaySinkSyncEndpointInterceptorFactoryBean getSyncEndpointInterceptorConfiguration() {
        return this.syncEndpointInterceptorConfiguration;
    }

    public void setSyncEndpointInterceptorConfiguration(GatewaySinkSyncEndpointInterceptorFactoryBean syncEndpointInterceptorConfiguration) {
        this.syncEndpointInterceptorConfiguration = syncEndpointInterceptorConfiguration;
    }

    @Override
    protected void afterPropertiesSetImpl(SecurityConfig securityConfig) {
        LocalClusterReplicationSinkConfig config = new LocalClusterReplicationSinkConfig(this.getLocalGatewayName());
        config.setLocalClusterSpaceUrl(this.localSpaceUrl);
        config.setStartLookupService(this.isStartEmbeddedLus());
        config.setRequiresBootstrap(this.requiresBootstrap);
        if (this.transactionTimeout != null) {
            config.setTransactionTimeout(this.transactionTimeout.longValue());
        }
        if (this.localSpaceLookupTimeout != null) {
            config.setFindTimeout(this.localSpaceLookupTimeout.longValue());
        }
        if (this.errorHandlingConfiguration != null) {
            this.errorHandlingConfiguration.copyToSinkConfiguration(config);
        }
        if (this.getGatewaySources() != null) {
            Iterator<GatewaySource> iterator = this.getGatewaySources().iterator();
            while (iterator.hasNext()) {
                GatewaySource source = iterator.next();
                if (!source.getName().equals(this.getLocalGatewayName())) continue;
                iterator.remove();
            }
            String[] gatewaySourcesNames = new String[this.getGatewaySources().size()];
            for (int i = 0; i < this.getGatewaySources().size(); ++i) {
                gatewaySourcesNames[i] = this.getGatewaySources().get(i).getName();
            }
            config.setSiteNames(gatewaySourcesNames);
            if (this.getGatewayLookups() != null) {
                ReplicationLookupParameters lookupParameters = this.getGatewayLookups().asReplicationLookupParameters();
                config.setGatewayLookupParameters(lookupParameters);
            }
        }
        Object interceptor = null;
        if (this.syncEndpointInterceptorConfiguration != null) {
            interceptor = this.syncEndpointInterceptorConfiguration.getInterceptor();
        }
        if (this.transactionProcessingConfiguration != null) {
            this.transactionProcessingConfiguration.copyParameters(config.getTransactionProcessingParameters());
            String distributedTransactionConsolidationFailureAction = this.transactionProcessingConfiguration.getDistributedTransactionConsolidationFailureAction();
            if (StringUtils.hasText((String)distributedTransactionConsolidationFailureAction)) {
                if (interceptor != null) {
                    throw new IllegalArgumentException("Cannot specify transaction consolidation failure behavior and provide a custom sync endpoint interceptor");
                }
                interceptor = "commit".equals(distributedTransactionConsolidationFailureAction) ? CommitOnConsolidationFailureInterceptor.INSTANCE : AbortOnConsolidationFailureInterceptor.INSTANCE;
            }
        }
        if (interceptor != null) {
            config.setSyncEndpointInterceptor(interceptor);
        }
        if (securityConfig != null) {
            config.setCredentialsProvider(securityConfig.getCredentialsProvider());
        }
        this.localClusterReplicationSink = new LocalClusterReplicationSink(config);
    }

    @Override
    protected void destroyImpl() {
        if (this.localClusterReplicationSink != null) {
            this.localClusterReplicationSink.close();
            this.localClusterReplicationSink = null;
        }
    }

    public Object invoke(Map<String, Object> namedArgs) {
        if (namedArgs.containsKey("enableIncomingReplication")) {
            this.localClusterReplicationSink.enableIncomingReplication();
            return null;
        }
        if (namedArgs.containsKey("bootstrapFromGateway")) {
            String bootstrapRemoteGatewayName = (String)namedArgs.get("bootstrapFromGateway");
            Long bootstrapTimeoutInSeconds = (Long)namedArgs.get("bootstrapTimeout");
            try {
                BootstrapConfig config = new BootstrapConfig(bootstrapRemoteGatewayName);
                if (bootstrapTimeoutInSeconds != null) {
                    config.setTimeout(bootstrapTimeoutInSeconds.longValue());
                }
                this.localClusterReplicationSink.bootstrapFromRemoteSink(config);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return null;
        }
        throw new UnsupportedOperationException("Only enableIncomingReplication and bootstrapFromGateway invocations are supported");
    }

    public ServiceDetails[] getServicesDetails() {
        String[] gatewaySourcesNames = null;
        if (this.gatewaySources != null) {
            gatewaySourcesNames = new String[this.gatewaySources.size()];
            int index = 0;
            for (GatewaySource gatewaySource : this.gatewaySources) {
                gatewaySourcesNames[index++] = gatewaySource.getName();
            }
        } else {
            gatewaySourcesNames = new String[]{};
        }
        return new ServiceDetails[]{new GatewaySinkServiceDetails(this.getLocalGatewayName(), gatewaySourcesNames, this.requiresBootstrap, this.getLocalSpaceUrl(), NIOInfoHelper.getDetails().getPort(), this.getDiscoveryPort(), this.isStartEmbeddedLus())};
    }

    @Override
    protected String getGatewayComponentTypeName() {
        return "Sink";
    }

    @Override
    protected String dumpState() {
        return this.localClusterReplicationSink != null ? this.localClusterReplicationSink.dumpState() : "";
    }
}

