/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.gateway;

import java.io.IOException;
import java.net.ServerSocket;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.core.gateway.GatewayServiceDetails;
import org.openspaces.pu.service.ServiceDetails;

public class GatewayUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkPortAvailable(int port) {
        if (port == 0) {
            return true;
        }
        ServerSocket sock = null;
        try {
            sock = new ServerSocket(port);
            sock.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean isPuInstanceOfGateway(String gatewayName, ProcessingUnitInstance processingUnitInstance) {
        ServiceDetails[] serviceDetails = processingUnitInstance.getServicesDetailsByServiceType("gateway");
        return serviceDetails != null && serviceDetails.length > 0 && ((GatewayServiceDetails)serviceDetails[0]).getLocalGatewayName().equals(gatewayName);
    }

    public static ProcessingUnitInstance extractInstanceIfPuOfGateway(String gatewayName, ProcessingUnit processingUnit) {
        ProcessingUnitInstance[] instances = processingUnit.getInstances();
        if (instances == null || instances.length == 0) {
            return null;
        }
        ServiceDetails[] serviceDetails = instances[0].getServicesDetailsByServiceType("gateway");
        if (serviceDetails != null && serviceDetails.length > 0 && ((GatewayServiceDetails)serviceDetails[0]).getLocalGatewayName().equals(gatewayName)) {
            return instances[0];
        }
        return null;
    }

    public static String extractGatewayNameIfExists(ProcessingUnit processingUnit) {
        ProcessingUnitInstance[] instances = processingUnit.getInstances();
        if (instances == null || instances.length == 0) {
            return null;
        }
        return GatewayUtils.extractGatewayName(instances[0]);
    }

    public static String extractGatewayName(ProcessingUnitInstance instance) {
        ServiceDetails[] serviceDetails = instance.getServicesDetailsByServiceType("gateway");
        if (serviceDetails == null || serviceDetails.length == 0) {
            return null;
        }
        return ((GatewayServiceDetails)serviceDetails[0]).getLocalGatewayName();
    }

    public static GatewayServiceDetails extractGatewayDetails(ProcessingUnitInstance instance) {
        ServiceDetails[] serviceDetails = instance.getServicesDetailsByServiceType("gateway");
        if (serviceDetails == null || serviceDetails.length == 0) {
            return null;
        }
        return (GatewayServiceDetails)serviceDetails[0];
    }
}

