/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.gateway.config;

import java.util.List;
import org.openspaces.core.config.xmlparser.SecurityDefinitionsParser;
import org.openspaces.core.gateway.GatewayDelegatorFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class GatewayDelegatorBeanDefinitionParser
extends AbstractSimpleBeanDefinitionParser {
    public static final String LOCAL_GATEWAY_NAME = "local-gateway-name";
    public static final String GATEWAY_LOOKUPS = "gateway-lookups";
    public static final String START_EMBEDDED_LUS = "start-embedded-lus";
    public static final String RELOCATE_IF_WRONG_PORTS = "relocate-if-wrong-ports";
    public static final String DELEGATION_TARGET = "target";
    public static final String DELEGATION_DELEGATE_THROUGH = "delegate-through";
    public static final String CUSTOM_JVM_PROPERTIES = "custom-jvm-properties";
    private static final String COMMUNICATION_PORT = "communication-port";
    private static final String DELEGATIONS = "delegations";
    private static final String SECURITY = "security";
    private static final String DELEGATION = "delegation";

    protected Class<GatewayDelegatorFactoryBean> getBeanClass(Element element) {
        return GatewayDelegatorFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element delegationsElement;
        Element deprecatedDelegationElement;
        Element securityElement;
        String communicationPort;
        String customJvmProperties;
        String relocateIfWrongPorts;
        String startEmbeddedLus;
        String gatewayLookupsRef;
        String localGateywayName = element.getAttribute(LOCAL_GATEWAY_NAME);
        if (StringUtils.hasLength((String)localGateywayName)) {
            builder.addPropertyValue("localGatewayName", (Object)localGateywayName);
        }
        if (StringUtils.hasLength((String)(gatewayLookupsRef = element.getAttribute(GATEWAY_LOOKUPS)))) {
            builder.addPropertyReference("gatewayLookups", gatewayLookupsRef);
        }
        if (StringUtils.hasLength((String)(startEmbeddedLus = element.getAttribute(START_EMBEDDED_LUS)))) {
            builder.addPropertyValue("startEmbeddedLus", (Object)Boolean.parseBoolean(startEmbeddedLus));
        }
        if (StringUtils.hasLength((String)(relocateIfWrongPorts = element.getAttribute(RELOCATE_IF_WRONG_PORTS)))) {
            builder.addPropertyValue("relocateIfWrongPorts", (Object)Boolean.parseBoolean(relocateIfWrongPorts));
        }
        if (StringUtils.hasLength((String)(customJvmProperties = element.getAttribute(CUSTOM_JVM_PROPERTIES)))) {
            builder.addPropertyValue("customJvmProperties", (Object)customJvmProperties);
        }
        if (StringUtils.hasLength((String)(communicationPort = element.getAttribute(COMMUNICATION_PORT)))) {
            builder.addPropertyValue("communicationPort", (Object)communicationPort);
        }
        if ((securityElement = DomUtils.getChildElementByTagName((Element)element, (String)SECURITY)) != null) {
            SecurityDefinitionsParser.parseXml((Element)securityElement, (BeanDefinitionBuilder)builder);
        }
        if ((deprecatedDelegationElement = DomUtils.getChildElementByTagName((Element)element, (String)DELEGATION)) != null) {
            if (securityElement != null) {
                throw new IllegalArgumentException("delegation element should be set within a delegations element");
            }
            List delegations = parserContext.getDelegate().parseListElement(element, (BeanDefinition)builder.getRawBeanDefinition());
            builder.addPropertyValue("gatewayDelegations", (Object)delegations);
        }
        if ((delegationsElement = DomUtils.getChildElementByTagName((Element)element, (String)DELEGATIONS)) != null) {
            if (deprecatedDelegationElement != null) {
                throw new IllegalArgumentException("delegation should be set within a delegations element");
            }
            List gatewayDelegations = parserContext.getDelegate().parseListElement(delegationsElement, (BeanDefinition)builder.getRawBeanDefinition());
            builder.addPropertyValue("gatewayDelegations", (Object)gatewayDelegations);
        }
    }
}

