/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.gateway.config;

import java.util.List;
import org.openspaces.core.config.xmlparser.SecurityDefinitionsParser;
import org.openspaces.core.gateway.GatewaySinkFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class GatewaySinkBeanDefinitionParser
extends AbstractSimpleBeanDefinitionParser {
    public static final String LOCAL_GATEWAY_NAME = "local-gateway-name";
    public static final String GATEWAY_LOOKUPS = "gateway-lookups";
    public static final String LOCAL_SPACE_URL = "local-space-url";
    public static final String START_EMBEDDED_LUS = "start-embedded-lus";
    public static final String RELOCATE_IF_WRONG_PORTS = "relocate-if-wrong-ports";
    public static final String GATEWAY_SOURCE_NAME = "name";
    public static final String REQUIRES_BOOTSTRAP = "requires-bootstrap";
    public static final String CUSTOM_JVM_PROPERTIES = "custom-jvm-properties";
    public static final String ERROR_HANDLING = "error-handling";
    public static final String GATEWAY_SOURCES = "sources";
    private static final String TRANSACTION_TIMEOUT = "tx-timeout";
    private static final String LOOKUP_TIMEOUT = "local-space-lookup-timeout";
    private static final String COMMUNICATION_PORT = "communication-port";
    private static final String TRANSACTION_SUPPORT = "tx-support";
    private static final String SYNC_ENDPOINT_INTERCEPTOR = "sync-endpoint-interceptor";
    private static final String SECURITY = "security";

    protected Class<GatewaySinkFactoryBean> getBeanClass(Element element) {
        return GatewaySinkFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element syncEndpointInterceptorConfigurationElement;
        Element securityElement;
        Element transactionProcessingConfigurationElement;
        String communicationPort;
        String localSpaceLookupTimeout;
        String transactionTimeout;
        String customJvmProperties;
        String requiresBootstrap;
        String relocateIfWrongPorts;
        String startEmbeddedLus;
        String localSpaceUrl;
        String gatewayLookupsRef;
        String localGateywayName = element.getAttribute(LOCAL_GATEWAY_NAME);
        if (StringUtils.hasLength((String)localGateywayName)) {
            builder.addPropertyValue("localGatewayName", (Object)localGateywayName);
        }
        if (StringUtils.hasLength((String)(gatewayLookupsRef = element.getAttribute(GATEWAY_LOOKUPS)))) {
            builder.addPropertyReference("gatewayLookups", gatewayLookupsRef);
        }
        if (StringUtils.hasLength((String)(localSpaceUrl = element.getAttribute(LOCAL_SPACE_URL)))) {
            builder.addPropertyValue("localSpaceUrl", (Object)localSpaceUrl);
        }
        if (StringUtils.hasLength((String)(startEmbeddedLus = element.getAttribute(START_EMBEDDED_LUS)))) {
            builder.addPropertyValue("startEmbeddedLus", (Object)Boolean.parseBoolean(startEmbeddedLus));
        }
        if (StringUtils.hasLength((String)(relocateIfWrongPorts = element.getAttribute(RELOCATE_IF_WRONG_PORTS)))) {
            builder.addPropertyValue("relocateIfWrongPorts", (Object)Boolean.parseBoolean(relocateIfWrongPorts));
        }
        if (StringUtils.hasLength((String)(requiresBootstrap = element.getAttribute(REQUIRES_BOOTSTRAP)))) {
            builder.addPropertyValue("requiresBootstrap", (Object)requiresBootstrap);
        }
        if (StringUtils.hasLength((String)(customJvmProperties = element.getAttribute(CUSTOM_JVM_PROPERTIES)))) {
            builder.addPropertyValue("customJvmProperties", (Object)customJvmProperties);
        }
        if (StringUtils.hasLength((String)(transactionTimeout = element.getAttribute(TRANSACTION_TIMEOUT)))) {
            builder.addPropertyValue("transactionTimeout", (Object)transactionTimeout);
        }
        if (StringUtils.hasLength((String)(localSpaceLookupTimeout = element.getAttribute(LOOKUP_TIMEOUT)))) {
            builder.addPropertyValue("localSpaceLookupTimeout", (Object)localSpaceLookupTimeout);
        }
        if (StringUtils.hasLength((String)(communicationPort = element.getAttribute(COMMUNICATION_PORT)))) {
            builder.addPropertyValue("communicationPort", (Object)communicationPort);
        }
        Element gatewaySourcesElement = DomUtils.getChildElementByTagName((Element)element, (String)GATEWAY_SOURCES);
        List sources = parserContext.getDelegate().parseListElement(gatewaySourcesElement, (BeanDefinition)builder.getRawBeanDefinition());
        builder.addPropertyValue("gatewaySources", (Object)sources);
        Element errorHandlingElement = DomUtils.getChildElementByTagName((Element)element, (String)ERROR_HANDLING);
        if (errorHandlingElement != null) {
            Object errorHandlingConfiguration = parserContext.getDelegate().parsePropertySubElement(errorHandlingElement, (BeanDefinition)builder.getRawBeanDefinition());
            builder.addPropertyValue("errorHandlingConfiguration", errorHandlingConfiguration);
        }
        if ((transactionProcessingConfigurationElement = DomUtils.getChildElementByTagName((Element)element, (String)TRANSACTION_SUPPORT)) != null) {
            Object transactionProcessingConfiguration = parserContext.getDelegate().parsePropertySubElement(transactionProcessingConfigurationElement, (BeanDefinition)builder.getRawBeanDefinition());
            builder.addPropertyValue("distributedTransactionProcessingConfiguration", transactionProcessingConfiguration);
        }
        if ((securityElement = DomUtils.getChildElementByTagName((Element)element, (String)SECURITY)) != null) {
            SecurityDefinitionsParser.parseXml((Element)securityElement, (BeanDefinitionBuilder)builder);
        }
        if ((syncEndpointInterceptorConfigurationElement = DomUtils.getChildElementByTagName((Element)element, (String)SYNC_ENDPOINT_INTERCEPTOR)) != null) {
            Object syncEndpointInterceptorConfiguration = parserContext.getDelegate().parsePropertySubElement(syncEndpointInterceptorConfigurationElement, (BeanDefinition)builder.getRawBeanDefinition());
            builder.addPropertyValue("syncEndpointInterceptorConfiguration", syncEndpointInterceptorConfiguration);
        }
    }
}

