/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.gateway.config;

import com.j_spaces.core.cluster.RedoLogCapacityExceededPolicy;
import org.openspaces.core.gateway.GatewayTarget;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class GatewayTargetBeanDefinitionParser
extends AbstractSimpleBeanDefinitionParser {
    private static final String TARGET_NAME = "name";
    private static final String BULK_SIZE = "bulk-size";
    private static final String IDLE_TIME_THRESHOLD = "idle-time-threshold";
    private static final String MAX_REDOLOG_CAPACITY = "max-redo-log-capacity";
    private static final String PENDING_OPERATION_THRESHOLD = "pending-operation-threshold";
    private static final String ON_REDOLOG_CAPACITY_EXCEEDED = "on-redo-log-capacity-exceeded";
    private static final String REPLICATE_CHANGE_AS_UPDATE = "replicate-change-as-update";

    protected Class<GatewayTarget> getBeanClass(Element element) {
        return GatewayTarget.class;
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        String targetName = element.getAttribute(TARGET_NAME);
        if (StringUtils.hasLength((String)targetName)) {
            builder.addPropertyValue(TARGET_NAME, (Object)targetName);
        }
        GatewayTargetBeanDefinitionParser.parseGatewayTargetAttributes(element, builder);
    }

    static void parseGatewayTargetAttributes(Element element, BeanDefinitionBuilder builder) {
        String replicateChangeAsUpdate;
        String onRedoLogCapacityExceeded;
        String pendingOperationThreshold;
        String maxRedoLogCapacity;
        String idleTimeThreshold;
        String bulkSize = element.getAttribute(BULK_SIZE);
        if (StringUtils.hasLength((String)bulkSize)) {
            builder.addPropertyValue("bulkSize", (Object)bulkSize);
        }
        if (StringUtils.hasText((String)(idleTimeThreshold = element.getAttribute(IDLE_TIME_THRESHOLD)))) {
            builder.addPropertyValue("idleTimeThreshold", (Object)idleTimeThreshold);
        }
        if (StringUtils.hasText((String)(maxRedoLogCapacity = element.getAttribute(MAX_REDOLOG_CAPACITY)))) {
            builder.addPropertyValue("maxRedoLogCapacity", (Object)maxRedoLogCapacity);
        }
        if (StringUtils.hasText((String)(pendingOperationThreshold = element.getAttribute(PENDING_OPERATION_THRESHOLD)))) {
            builder.addPropertyValue("pendingOperationThreshold", (Object)pendingOperationThreshold);
        }
        if (StringUtils.hasText((String)(onRedoLogCapacityExceeded = element.getAttribute(ON_REDOLOG_CAPACITY_EXCEEDED)))) {
            builder.addPropertyValue("onRedoLogCapacityExceeded", (Object)GatewayTargetBeanDefinitionParser.parseOnRedoLogCapacityExceededString(onRedoLogCapacityExceeded));
        }
        if (StringUtils.hasText((String)(replicateChangeAsUpdate = element.getAttribute(REPLICATE_CHANGE_AS_UPDATE)))) {
            builder.addPropertyValue("replicateChangeAsUpdate", (Object)replicateChangeAsUpdate);
        }
    }

    private static RedoLogCapacityExceededPolicy parseOnRedoLogCapacityExceededString(String onRedoLogCapacityExceededString) {
        String DROP_OLDEST = "drop-oldest";
        if ("drop-oldest".equals(onRedoLogCapacityExceededString)) {
            return RedoLogCapacityExceededPolicy.DROP_OLDEST;
        }
        String BLOCK_OPERATIONS = "block-operations";
        if ("block-operations".equals(onRedoLogCapacityExceededString)) {
            return RedoLogCapacityExceededPolicy.BLOCK_OPERATIONS;
        }
        throw new IllegalArgumentException("onRedoLogCapacityExceeded only accepts the following values: [drop-oldest, block-operations]");
    }
}

