/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.esm;

import com.gigaspaces.grid.gsa.AgentHelper;
import com.gigaspaces.grid.zone.ZoneHelper;
import com.gigaspaces.internal.dump.InternalDumpException;
import com.gigaspaces.internal.dump.InternalDumpHelper;
import com.gigaspaces.internal.dump.InternalDumpResult;
import com.gigaspaces.internal.dump.thread.ThreadDumpProcessor;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMHelper;
import com.gigaspaces.internal.jvm.JVMStatistics;
import com.gigaspaces.internal.log.InternalLogHelper;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.os.OSHelper;
import com.gigaspaces.internal.os.OSStatistics;
import com.gigaspaces.internal.utils.concurrent.GSThreadFactory;
import com.gigaspaces.log.LogEntries;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.log.LogProcessType;
import com.gigaspaces.lrmi.GenericExporter;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.lrmi.LRMIMonitoringDetails;
import com.gigaspaces.lrmi.nio.info.NIODetails;
import com.gigaspaces.lrmi.nio.info.NIOInfoHelper;
import com.gigaspaces.lrmi.nio.info.NIOStatistics;
import com.gigaspaces.management.entry.JMXConnection;
import com.gigaspaces.metrics.MetricManager;
import com.gigaspaces.security.SecurityException;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.service.RemoteSecuredService;
import com.gigaspaces.security.service.SecurityContext;
import com.gigaspaces.security.service.SecurityInterceptor;
import com.gigaspaces.security.service.SecurityResolver;
import com.gigaspaces.start.SystemBoot;
import com.gigaspaces.start.SystemInfo;
import com.gigaspaces.time.SystemTime;
import com.sun.jini.start.LifeCycle;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;
import net.jini.export.Exporter;
import org.jini.rio.core.ClassBundle;
import org.jini.rio.core.jsb.ServiceBeanContext;
import org.jini.rio.jsb.ServiceBeanActivation;
import org.jini.rio.jsb.ServiceBeanAdapter;
import org.jini.rio.monitor.event.Event;
import org.jini.rio.monitor.event.Events;
import org.jini.rio.monitor.event.EventsStore;
import org.openspaces.admin.Admin;
import org.openspaces.admin.bean.BeanConfigException;
import org.openspaces.admin.bean.BeanConfigurationException;
import org.openspaces.admin.esm.ElasticServiceManager;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.gsm.InternalGridServiceManager;
import org.openspaces.admin.internal.pu.InternalProcessingUnit;
import org.openspaces.admin.internal.pu.elastic.ElasticMachineIsolationConfig;
import org.openspaces.admin.internal.pu.elastic.GridServiceAgentFailureDetectionConfig;
import org.openspaces.admin.internal.pu.elastic.ProcessingUnitSchemaConfig;
import org.openspaces.admin.internal.pu.elastic.ScaleStrategyBeanPropertiesManager;
import org.openspaces.admin.machine.Machine;
import org.openspaces.admin.machine.events.MachineLifecycleEventListener;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.elastic.config.DiscoveredMachineProvisioningConfig;
import org.openspaces.admin.pu.elastic.config.ScaleStrategyConfig;
import org.openspaces.admin.pu.events.ProcessingUnitAddedEventListener;
import org.openspaces.admin.pu.events.ProcessingUnitRemovedEventListener;
import org.openspaces.core.GigaSpace;
import org.openspaces.grid.esm.ESM;
import org.openspaces.grid.esm.ESMImplInitializer;
import org.openspaces.grid.esm.ESMInitializationTimeoutException;
import org.openspaces.grid.esm.ESMProxy;
import org.openspaces.grid.esm.EsmNotInitializedException;
import org.openspaces.grid.esm.InternalKeepAliveEventDelayed;
import org.openspaces.grid.esm.SecuredESMProxy;
import org.openspaces.grid.gsm.ScaleBeanServer;
import org.openspaces.grid.gsm.autoscaling.AutoScalingSlaEnforcement;
import org.openspaces.grid.gsm.containers.ContainersSlaEnforcement;
import org.openspaces.grid.gsm.machines.MachinesSlaEnforcement;
import org.openspaces.grid.gsm.machines.MachinesSlaEnforcementState;
import org.openspaces.grid.gsm.machines.backup.MachinesStateBackup;
import org.openspaces.grid.gsm.machines.backup.MachinesStateBackupStub;
import org.openspaces.grid.gsm.machines.backup.MachinesStateBackupToSpace;
import org.openspaces.grid.gsm.machines.plugins.NonBlockingElasticMachineProvisioningAdapterFactory;
import org.openspaces.grid.gsm.rebalancing.RebalancingSlaEnforcement;
import org.openspaces.grid.gsm.strategy.AbstractCapacityScaleStrategyBean;
import org.openspaces.grid.gsm.strategy.ScaleStrategyBean;
import org.openspaces.grid.gsm.strategy.UndeployScaleStrategyBean;

public class ESMImpl
extends ServiceBeanAdapter
implements ESM,
RemoteSecuredService,
ProcessingUnitRemovedEventListener,
ProcessingUnitAddedEventListener,
MachineLifecycleEventListener {
    private static final long DISCOVERY_TIMEOUT_SECONDS = Long.getLong("org.openspaces.grid.initialization-timeout-seconds", 180L);
    private static final long CHECK_SINGLE_THREAD_EVENT_PUMP_EVERY_SECONDS = Long.getLong("org.openspaces.grid.internal-eventloop-keepalive-error-seconds", 60L);
    private static final String CONFIG_COMPONENT = "org.openspaces.grid.esm";
    private static final Logger logger = Logger.getLogger("org.openspaces.grid.esm");
    private final MetricManager metricManager;
    private Admin admin;
    private MachinesSlaEnforcement machinesSlaEnforcement;
    private ContainersSlaEnforcement containersSlaEnforcement;
    private RebalancingSlaEnforcement rebalancingSlaEnforcement;
    private AutoScalingSlaEnforcement autoScalingSlaEnforcement;
    private final Map<ProcessingUnit, ScaleBeanServer> scaleBeanServerPerProcessingUnit;
    private final Map<String, Map<String, String>> elasticPropertiesPerProcessingUnit;
    private final Map<String, PendingElasticPropertiesUpdate> pendingElasticPropertiesUpdatePerProcessingUnit;
    private LifeCycle lifeCycle;
    private String[] configArgs;
    private final NonBlockingElasticMachineProvisioningAdapterFactory nonBlockingAdapterFactory;
    private final EventsStore eventsStore;
    private final AtomicBoolean adminInitialized = new AtomicBoolean(false);
    private final AtomicBoolean destroyStarted = new AtomicBoolean(false);
    private SecurityInterceptor securityInterceptor;
    private AtomicLong keepAlive = new AtomicLong(0L);
    private final long adminInitializationTimeout;
    private final Map<String, Set<Remote>> exportedApis = new HashMap<String, Set<Remote>>();
    protected GigaSpace managementSpace;
    private MachinesStateBackup machinesStateBackup;

    public ESMImpl() throws Exception {
        this.metricManager = MetricManager.acquire();
        this.nonBlockingAdapterFactory = new NonBlockingElasticMachineProvisioningAdapterFactory();
        this.scaleBeanServerPerProcessingUnit = new HashMap<ProcessingUnit, ScaleBeanServer>();
        this.elasticPropertiesPerProcessingUnit = new ConcurrentHashMap<String, Map<String, String>>();
        this.pendingElasticPropertiesUpdatePerProcessingUnit = new ConcurrentHashMap<String, PendingElasticPropertiesUpdate>();
        this.eventsStore = new EventsStore();
        new ESMImplInitializer(new ESMImplInitializer.AdminCreatedEventListener(){

            @Override
            public void adminCreated(Admin admin, GigaSpace managementSpace) {
                ESMImpl.this.admin = admin;
                ESMImpl.this.startKeepAlive(admin);
                ESMImpl.this.startKeepAliveMonitor();
                ESMImpl.this.managementSpace = managementSpace;
                MachinesSlaEnforcementState machinesSlaEnforcementState = new MachinesSlaEnforcementState();
                ESMImpl.this.machinesSlaEnforcement = new MachinesSlaEnforcement(machinesSlaEnforcementState);
                ESMImpl.this.containersSlaEnforcement = new ContainersSlaEnforcement(admin);
                ESMImpl.this.rebalancingSlaEnforcement = new RebalancingSlaEnforcement();
                ESMImpl.this.autoScalingSlaEnforcement = new AutoScalingSlaEnforcement(admin);
                if (managementSpace == null) {
                    ESMImpl.this.machinesStateBackup = new MachinesStateBackupStub();
                } else {
                    ESMImpl.this.machinesStateBackup = new MachinesStateBackupToSpace(admin, managementSpace, machinesSlaEnforcementState);
                }
                ESMImpl.this.adminInitialized.set(true);
                while (!this.isEsmDiscovered(admin)) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                admin.getProcessingUnits().getProcessingUnitAdded().add(ESMImpl.this);
                admin.getProcessingUnits().getProcessingUnitRemoved().add(ESMImpl.this);
                logger.info("ESM is now listening for Processing Unit events");
            }

            private boolean isEsmDiscovered(Admin admin) {
                ElasticServiceManager[] esms = admin.getElasticServiceManagers().getManagers();
                if (esms.length == 0) {
                    logger.log(Level.INFO, "Waiting to discover one ESM");
                    return false;
                }
                if (esms.length > 1) {
                    logger.log(Level.INFO, "Waiting for one of the ESMs to stop. Currently running " + esms.length + " ESMs");
                    return false;
                }
                for (ElasticServiceManager esm : admin.getElasticServiceManagers()) {
                    if (!esm.isDiscovered() || esm.getAgentId() == -1 || esm.getGridServiceAgent() != null) continue;
                    logger.log(Level.INFO, "Waiting to discover GSA that started ESM " + esm.getUid());
                    return false;
                }
                return true;
            }
        });
        this.adminInitializationTimeout = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(DISCOVERY_TIMEOUT_SECONDS);
        logger.fine("Starting ESM initialization, timeout in " + DISCOVERY_TIMEOUT_SECONDS + " seconds.");
    }

    public ESMImpl(String[] configArgs, LifeCycle lifeCycle) throws Exception {
        this();
        this.lifeCycle = lifeCycle;
        this.configArgs = configArgs;
        this.bootstrap(configArgs);
    }

    protected void bootstrap(String[] configArgs) throws Exception {
        try {
            String fdh = "org.openspaces.grid.esm.ESMFaultDetectionHandler";
            Object[] fdhConfigArgs = new Object[]{new String[]{"-", "org.openspaces.grid.esm.ESMFaultDetectionHandler.invocationDelay=" + System.getProperty("org.openspaces.grid.esm.ESMFaultDetectionHandler.invocationDelay", "1000"), "org.openspaces.grid.esm.ESMFaultDetectionHandler.retryCount=" + System.getProperty("org.openspaces.grid.esm.ESMFaultDetectionHandler.retryCount", "1"), "org.openspaces.grid.esm.ESMFaultDetectionHandler.retryTimeout=" + System.getProperty("org.openspaces.grid.esm.ESMFaultDetectionHandler.retryTimeout", "500")}};
            ClassBundle faultDetectionHandler = new ClassBundle(fdh, null, new String[]{"setConfiguration"}, new Object[]{fdhConfigArgs});
            this.context = ServiceBeanActivation.getServiceBeanContext((String)CONFIG_COMPONENT, (String)"ESM", (String)"Service Grid Infrastructure", (String)"com.gigaspaces.grid:type=ESM", (ClassBundle)faultDetectionHandler, (String[])configArgs, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Getting ServiceElement", e);
            throw e;
        }
        try {
            this.start(this.context);
            ServiceBeanActivation.LifeCycleManager lMgr = (ServiceBeanActivation.LifeCycleManager)this.context.getServiceBeanManager().getDiscardManager();
            lMgr.register(this.getServiceProxy(), this.context);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Register to LifeCycleManager", e);
            throw e;
        }
    }

    private boolean isAdminInitializationTimedOut() {
        return System.currentTimeMillis() > this.adminInitializationTimeout;
    }

    public synchronized void initialize(ServiceBeanContext context) throws Exception {
        if (SecurityResolver.isSecurityEnabled()) {
            this.securityInterceptor = new SecurityInterceptor("grid");
        }
        while (!this.adminInitialized.get()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Waiting for ESM initializer to complete");
            }
            SystemBoot.exitIfHasAgentAndAgentIsNotRunning();
            if (this.isAdminInitializationTimedOut()) {
                throw new ESMInitializationTimeoutException(DISCOVERY_TIMEOUT_SECONDS, TimeUnit.SECONDS);
            }
            Thread.sleep(1000L);
        }
        logger.info("Starting ESM ...");
        super.initialize(context);
        String jmxServiceURL = SystemBoot.getJMXServiceURL();
        if (jmxServiceURL != null) {
            String hostName = SystemInfo.singleton().network().getHostId();
            int port = SystemBoot.getRegistryPort();
            String name = context.getServiceElement().getName() + "_" + hostName + "_" + port;
            this.addAttribute((Entry)new JMXConnection(jmxServiceURL, name));
        }
    }

    public void advertise() throws IOException {
        super.advertise();
        logger.info("ESM started successfully with groups " + Arrays.toString(((ServiceBeanAdapter)this).admin.getLookupGroups()) + " and locators " + Arrays.toString(((ServiceBeanAdapter)this).admin.getLookupLocators()) + "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy(boolean force) {
        logger.info("Stopping ESM ...");
        this.destroyStarted.set(true);
        this.machinesStateBackup.close();
        this.admin.getProcessingUnits().getProcessingUnitRemoved().remove(this);
        this.admin.getProcessingUnits().getProcessingUnitAdded().remove(this);
        Map<ProcessingUnit, ScaleBeanServer> map = this.scaleBeanServerPerProcessingUnit;
        synchronized (map) {
            for (ScaleBeanServer beanServer : this.scaleBeanServerPerProcessingUnit.values()) {
                beanServer.destroy();
            }
            this.scaleBeanServerPerProcessingUnit.clear();
        }
        this.admin.close();
        if (this.lifeCycle != null) {
            this.lifeCycle.unregister((Object)this);
        }
        this.metricManager.close();
        super.destroy(force);
        logger.info("ESM stopped successfully");
    }

    protected Object createProxy() {
        ESMProxy proxy = this.securityInterceptor != null ? SecuredESMProxy.getInstance((ESM)((Object)this.getExportedProxy()), this.getUuid()) : ESMProxy.getInstance((ESM)((Object)this.getExportedProxy()), this.getUuid());
        return proxy;
    }

    public int getAgentId() throws RemoteException {
        return AgentHelper.getAgentId();
    }

    public String getGSAServiceID() throws RemoteException {
        return AgentHelper.getGSAServiceID();
    }

    public NIODetails getNIODetails() throws RemoteException {
        return NIOInfoHelper.getDetails();
    }

    public NIOStatistics getNIOStatistics() throws RemoteException {
        return NIOInfoHelper.getNIOStatistics();
    }

    public void enableLRMIMonitoring() throws RemoteException {
        NIOInfoHelper.enableMonitoring();
    }

    public void disableLRMIMonitoring() throws RemoteException {
        NIOInfoHelper.disableMonitoring();
    }

    public LRMIMonitoringDetails fetchLRMIMonitoringDetails() throws RemoteException {
        return NIOInfoHelper.fetchMonitoringDetails();
    }

    public long getCurrentTimestamp() throws RemoteException {
        return System.currentTimeMillis();
    }

    public OSDetails getOSDetails() throws RemoteException {
        return OSHelper.getDetails();
    }

    public OSStatistics getOSStatistics() throws RemoteException {
        return OSHelper.getStatistics();
    }

    public JVMDetails getJVMDetails() throws RemoteException {
        return JVMHelper.getDetails();
    }

    public JVMStatistics getJVMStatistics() throws RemoteException {
        return JVMHelper.getStatistics();
    }

    public void runGc() throws RemoteException {
        System.gc();
    }

    public String[] getZones() throws RemoteException {
        return ZoneHelper.getSystemZones();
    }

    public LogEntries logEntriesDirect(LogEntryMatcher matcher) throws RemoteException, IOException {
        return InternalLogHelper.logEntriesDirect((LogProcessType)LogProcessType.ESM, (LogEntryMatcher)matcher);
    }

    public void reloadMetricConfiguration() throws RemoteException {
        MetricManager.reloadIfStarted();
    }

    public byte[] dumpBytes(String file, long from, int length) throws RemoteException, IOException {
        return InternalDumpHelper.dumpBytes((String)file, (long)from, (int)length);
    }

    public InternalDumpResult generateDump(String cause, Map<String, Object> context) throws RemoteException, InternalDumpException {
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        context.put("esm", this);
        return InternalDumpHelper.generateDump((String)cause, context);
    }

    public InternalDumpResult generateDump(String cause, Map<String, Object> context, String ... contributors) throws RemoteException, InternalDumpException {
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        context.put("esm", this);
        return InternalDumpHelper.generateDump((String)cause, context, (String[])contributors);
    }

    public String[] getManagedProcessingUnits() {
        Set<ProcessingUnit> puSet = this.scaleBeanServerPerProcessingUnit.keySet();
        String[] puNames = new String[puSet.size()];
        int i = 0;
        for (ProcessingUnit pu : puSet) {
            puNames[i] = pu.getName();
            ++i;
        }
        return puNames;
    }

    public boolean isServiceSecured() throws RemoteException {
        return this.securityInterceptor != null;
    }

    public SecurityContext login(CredentialsProvider credentialsProvider) throws SecurityException, RemoteException {
        throw new SecurityException("Invalid method call.");
    }

    public SecurityContext login(SecurityContext securityContext) throws RemoteException {
        if (this.isServiceSecured()) {
            return this.securityInterceptor.authenticate(securityContext);
        }
        return null;
    }

    @Override
    public void setProcessingUnitScaleStrategy(final String puName, final ScaleStrategyConfig scaleStrategyConfig) {
        logger.fine("setting scale strategy for " + puName);
        this.submitAndWait(new Callable<Void>(){

            @Override
            public Void call() {
                Map<String, String> properties = (Map<String, String>)ESMImpl.this.elasticPropertiesPerProcessingUnit.get(puName);
                if (properties == null) {
                    properties = scaleStrategyConfig.getProperties();
                    ESMImpl.this.pendingElasticPropertiesUpdatePerProcessingUnit.put(puName, new PendingElasticPropertiesUpdate(scaleStrategyConfig.getBeanClassName(), properties));
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("Stored elastic properties for " + puName + " (elasticProperties.size()=" + properties.size() + ")");
                    }
                } else {
                    ESMImpl.this.mergeScaleProperties(scaleStrategyConfig.getBeanClassName(), scaleStrategyConfig.getProperties(), properties);
                    ESMImpl.this.processingUnitElasticPropertiesChanged(puName, properties);
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("Merged elastic properties for " + puName + " (elasticProperties.size()=" + properties.size() + ")");
                    }
                }
                return null;
            }
        });
    }

    @Override
    public Events getScaleStrategyEvents(final long cursor, final int maxNumberOfEvents) {
        logger.fine("get scale strategy events cursor=" + cursor + " maxNumberOfEvents=" + maxNumberOfEvents);
        try {
            return this.submitAndWait(new Callable<Events>(){

                @Override
                public Events call() throws Exception {
                    return ESMImpl.this.eventsStore.getEventsFromCursor(cursor, maxNumberOfEvents);
                }
            });
        }
        catch (IllegalStateException e) {
            if (this.destroyStarted.get() || e instanceof EsmNotInitializedException) {
                return new Events(cursor, new Event[0]);
            }
            throw e;
        }
    }

    private ScaleStrategyBean getScaleStrategyBean(String puName) {
        if (!this.pendingElasticPropertiesUpdatePerProcessingUnit.containsKey(puName)) {
            for (Map.Entry<ProcessingUnit, ScaleBeanServer> pair : this.scaleBeanServerPerProcessingUnit.entrySet()) {
                ScaleBeanServer beanServer;
                if (!pair.getKey().getName().equals(puName) || (beanServer = pair.getValue()).getEnabledBean() == null) continue;
                return beanServer.getEnabledBean();
            }
        }
        return null;
    }

    <T> T submitAndWait(final Callable<T> task) {
        if (!this.adminInitialized.get()) {
            throw new EsmNotInitializedException();
        }
        final AtomicReference future = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        ((InternalAdmin)this.admin).scheduleNonBlockingStateChange(new Runnable(){

            @Override
            public void run() {
                try {
                    future.set(task.call());
                }
                catch (Throwable e) {
                    future.set(e);
                }
                finally {
                    latch.countDown();
                }
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Object result = future.get();
        if (result instanceof RuntimeException) {
            throw (RuntimeException)result;
        }
        if (result instanceof Error) {
            throw (Error)result;
        }
        if (result instanceof Exception) {
            throw new IllegalStateException("Unexpected exception", (Exception)result);
        }
        return (T)result;
    }

    private void mergeScaleProperties(String strategyClassName, Map<String, String> strategyProperties, Map<String, String> properties) {
        ScaleStrategyBeanPropertiesManager propertiesManager = new ScaleStrategyBeanPropertiesManager(properties);
        propertiesManager.disableAllBeans();
        propertiesManager.setBeanConfig(strategyClassName, strategyProperties);
        propertiesManager.enableBean(strategyClassName);
    }

    @Override
    public void setProcessingUnitElasticProperties(final String puName, Map<String, String> properties) throws RemoteException {
        logger.fine("Queuing elastic properties for " + puName);
        this.submitAndWait(new Callable<Void>(){

            @Override
            public Void call() {
                Map properties = (Map)ESMImpl.this.elasticPropertiesPerProcessingUnit.get(puName);
                if (properties == null) {
                    ESMImpl.this.pendingElasticPropertiesUpdatePerProcessingUnit.put(puName, new PendingElasticPropertiesUpdate(new HashMap<String, String>(0)));
                } else {
                    ESMImpl.this.processingUnitElasticPropertiesChanged(puName, properties);
                }
                return null;
            }
        });
    }

    @Override
    public void processingUnitRemoved(ProcessingUnit pu) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Processing Unit Removed " + pu.getName());
        }
        this.pendingElasticPropertiesUpdatePerProcessingUnit.remove(pu.getName());
        ScaleBeanServer beanServer = this.scaleBeanServerPerProcessingUnit.get(pu);
        if (beanServer != null) {
            logger.info("Processing Unit " + pu.getName() + " was removed. Cleaning up machines.");
            beanServer.undeploy();
            this.elasticPropertiesPerProcessingUnit.remove(pu.getName());
        }
    }

    @Override
    public void processingUnitAdded(ProcessingUnit pu) {
        InternalProcessingUnit internalPu;
        Map<String, String> elasticProperties;
        ScaleBeanServer undeployedBeanServer;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Processing Unit Added " + pu.getName());
        }
        if ((undeployedBeanServer = this.scaleBeanServerPerProcessingUnit.remove(pu)) != null) {
            ScaleStrategyBean scaleStrategyBean = this.getScaleStrategyBean(pu.getName());
            if (scaleStrategyBean != null && scaleStrategyBean instanceof AbstractCapacityScaleStrategyBean) {
                this.unexportExistingApis(pu.getName());
            }
            undeployedBeanServer.destroy();
        }
        if (!(elasticProperties = (internalPu = (InternalProcessingUnit)pu).getElasticProperties()).isEmpty()) {
            if (this.pendingElasticPropertiesUpdatePerProcessingUnit.containsKey(pu.getName())) {
                PendingElasticPropertiesUpdate pendingPropsUpdate = this.pendingElasticPropertiesUpdatePerProcessingUnit.remove(pu.getName());
                if (pendingPropsUpdate.isScaleCommand()) {
                    this.mergeScaleProperties(pendingPropsUpdate.getStrategyClassName(), pendingPropsUpdate.getElasticProperties(), elasticProperties);
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("Added " + pu.getName() + " and merged elastic properties (elasticProperties.size()=" + elasticProperties.size() + ")");
                    }
                } else {
                    elasticProperties = pendingPropsUpdate.getElasticProperties();
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("Added " + pu.getName() + " and overridden elastic properties (elasticProperties.size()=" + elasticProperties.size() + ")");
                    }
                }
            }
            this.elasticPropertiesPerProcessingUnit.put(pu.getName(), elasticProperties);
            this.refreshProcessingUnitElasticConfig(pu, elasticProperties);
        }
    }

    private void unexportExistingApis(String processingUnitName) {
        Exporter exporter = this.getExporter();
        Set<Remote> apis = this.exportedApis.get(processingUnitName);
        if (apis != null) {
            for (Remote api : apis) {
                try {
                    if (exporter instanceof GenericExporter) {
                        ((GenericExporter)exporter).unexport(api);
                        continue;
                    }
                    throw new IllegalStateException("exporter must be an instance of GenericExporter");
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed unexporting api " + api.getClass().getName() + " instance with hashCode=" + api.hashCode() + " : " + e.getMessage(), e);
                }
            }
        }
    }

    private void refreshProcessingUnitElasticConfig(ProcessingUnit pu, Map<String, String> elasticProperties) {
        try {
            if (pu.getRequiredZones().length != 1) {
                throw new BeanConfigurationException("Processing Unit must have exactly one container zone defined.");
            }
            if (elasticProperties.size() == 0) {
                throw new BeanConfigurationException("elasticProperties for " + pu.getName() + " cannot be empty. Could all GSMs have been restarted?");
            }
            ScaleBeanServer beanServer = this.scaleBeanServerPerProcessingUnit.get(pu);
            if (beanServer == null) {
                ProcessingUnitSchemaConfig schemaConfig = new ProcessingUnitSchemaConfig(elasticProperties);
                ElasticMachineIsolationConfig isolationConfig = new ElasticMachineIsolationConfig(elasticProperties);
                beanServer = new ScaleBeanServer(pu, schemaConfig, this.rebalancingSlaEnforcement, this.containersSlaEnforcement, this.machinesSlaEnforcement, this.autoScalingSlaEnforcement, this.nonBlockingAdapterFactory, isolationConfig, this.eventsStore, this.machinesStateBackup);
                this.scaleBeanServerPerProcessingUnit.put(pu, beanServer);
            }
            beanServer.setElasticProperties(elasticProperties);
            logger.info("Elastic properties for pu " + pu.getName() + " are being enforced.");
            DiscoveredMachineProvisioningConfig discoveredMachineProvisioningConfig = new DiscoveredMachineProvisioningConfig(elasticProperties);
            logger.info("Discovered Machine Provisioning Config: { ReservedMemoryCapacityPerMachineInMB = " + discoveredMachineProvisioningConfig.getReservedMemoryCapacityPerMachineInMB() + ", ReservedMemoryCapacityPerManagementMachineInMB = " + discoveredMachineProvisioningConfig.getReservedMemoryCapacityPerManagementMachineInMB() + " }");
        }
        catch (BeanConfigException e) {
            this.machinesSlaEnforcement.failedRecoveredStateOnEsmStart(pu);
            logger.log(Level.SEVERE, "Error configuring elastic scale bean for pu " + pu.getName(), e);
        }
    }

    private void processingUnitElasticPropertiesChanged(String puName, Map<String, String> elasticProperties) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Processing Unit Elastic Properties Changed for " + puName);
        }
        this.elasticPropertiesPerProcessingUnit.put(puName, elasticProperties);
        ProcessingUnit pu = this.admin.getProcessingUnits().getProcessingUnit(puName);
        if (pu != null) {
            InternalGridServiceManager managinGsm = (InternalGridServiceManager)pu.getManagingGridServiceManager();
            managinGsm.updateProcessingUnitElasticPropertiesOnGsm(pu, elasticProperties);
            this.refreshProcessingUnitElasticConfig(pu, elasticProperties);
        } else {
            logger.info("Elastic properties for pu " + puName + " has been set, but the processing unit itself was not detected yet.");
        }
    }

    @Override
    public void machineAdded(Machine machine) {
        machine.getOperatingSystem().startStatisticsMonitor();
    }

    @Override
    public void machineRemoved(Machine machine) {
        machine.getOperatingSystem().stopStatisticsMonitor();
    }

    @Override
    public ScaleStrategyConfig getProcessingUnitScaleStrategyConfig(final String processingUnitName) throws RemoteException {
        return this.submitAndWait(new Callable<ScaleStrategyConfig>(){

            @Override
            public ScaleStrategyConfig call() {
                ScaleStrategyConfig config = null;
                ScaleStrategyBean scaleStrategyBean = ESMImpl.this.getScaleStrategyBean(processingUnitName);
                if (scaleStrategyBean != null) {
                    config = scaleStrategyBean.getConfig();
                }
                return config;
            }
        });
    }

    public boolean isManagingProcessingUnit(final String processingUnitName) throws RemoteException {
        return this.submitAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                boolean isManaging = false;
                ScaleStrategyBean scaleStrategyBean = ESMImpl.this.getScaleStrategyBean(processingUnitName);
                if (scaleStrategyBean != null) {
                    if (scaleStrategyBean instanceof UndeployScaleStrategyBean) {
                        if (scaleStrategyBean.isScaleInProgress()) {
                            isManaging = true;
                        }
                    } else {
                        isManaging = true;
                    }
                }
                return isManaging;
            }
        });
    }

    public boolean isManagingProcessingUnitAndScaleNotInProgress(final String processingUnitName) throws RemoteException {
        return this.submitAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                ScaleStrategyBean scaleStrategyBean = ESMImpl.this.getScaleStrategyBean(processingUnitName);
                return scaleStrategyBean != null && !scaleStrategyBean.isScaleInProgress();
            }
        });
    }

    @Override
    public Remote getRemoteApi(final String processingUnitName, final String apiName) throws RemoteException {
        return this.submitAndWait(new Callable<Remote>(){

            @Override
            public Remote call() throws Exception {
                block7: {
                    ScaleStrategyBean scaleStrategyBean = ESMImpl.this.getScaleStrategyBean(processingUnitName);
                    Remote api = null;
                    if (scaleStrategyBean != null && scaleStrategyBean instanceof AbstractCapacityScaleStrategyBean) {
                        try {
                            api = ((AbstractCapacityScaleStrategyBean)scaleStrategyBean).getRemoteApi(apiName);
                            if (api != null) {
                                LinkedHashSet<Remote> existingSet;
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.fine("Exporting " + apiName + " api of processing unit " + processingUnitName + ". hasCode=" + api.hashCode());
                                }
                                if ((existingSet = (LinkedHashSet<Remote>)ESMImpl.this.exportedApis.get(processingUnitName)) != null) {
                                    existingSet.add(api);
                                } else {
                                    existingSet = new LinkedHashSet<Remote>();
                                    existingSet.add(api);
                                    ESMImpl.this.exportedApis.put(processingUnitName, existingSet);
                                }
                                return ESMImpl.this.getExporter().export(api);
                            }
                        }
                        catch (Exception e) {
                            if (api == null) break block7;
                            logger.log(Level.WARNING, "Failed exporting cloud " + apiName + " api instance with hashCode=" + api.hashCode() + " : " + e.getMessage(), e);
                        }
                    }
                }
                return null;
            }
        });
    }

    @Override
    public void disableAgentFailureDetection(String processingUnitName, long timeout, TimeUnit timeunit) throws RemoteException {
        long expireTimestamp = System.currentTimeMillis() + timeunit.toMillis(timeout);
        this.changeAgentFailureDetection(processingUnitName, expireTimestamp, false);
    }

    @Override
    public void enableAgentFailureDetection(String processingUnitName) throws RemoteException {
        this.changeAgentFailureDetection(processingUnitName, null, true);
    }

    private void changeAgentFailureDetection(final String processingUnitName, final Long expireTimestamp, final boolean enable) {
        InetSocketAddress clientEndPointAddress = LRMIInvocationContext.getCurrentContext().getClientEndPointAddress();
        final String ipAddress = clientEndPointAddress.getAddress().getHostAddress();
        this.submitAndWait(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ScaleStrategyBean scaleStrategyBean = ESMImpl.this.getScaleStrategyBean(processingUnitName);
                if (scaleStrategyBean == null) {
                    throw new IllegalArgumentException("Not managing " + processingUnitName);
                }
                if (!(scaleStrategyBean instanceof AbstractCapacityScaleStrategyBean)) {
                    throw new IllegalArgumentException(processingUnitName + " does not support disabling of agent failover");
                }
                Map elasticProperties = (Map)ESMImpl.this.elasticPropertiesPerProcessingUnit.get(processingUnitName);
                if (elasticProperties == null) {
                    throw new IllegalArgumentException("Could not find configuration for " + processingUnitName);
                }
                HashMap<String, String> newProperties = new HashMap<String, String>(elasticProperties);
                GridServiceAgentFailureDetectionConfig agentFailureDetectionConfig = new GridServiceAgentFailureDetectionConfig(newProperties);
                if (enable) {
                    agentFailureDetectionConfig.enableFailureDetection(ipAddress);
                    logger.info("Enabling agent failure detection for " + processingUnitName + " on machine " + ipAddress);
                } else {
                    agentFailureDetectionConfig.disableFailureDetection(ipAddress, expireTimestamp);
                    logger.info("Disabling agent failure detection for " + processingUnitName + " on machine " + ipAddress);
                }
                ESMImpl.this.processingUnitElasticPropertiesChanged(processingUnitName, newProperties);
                return null;
            }
        });
    }

    private void startKeepAlive(Admin admin) {
        ((InternalAdmin)admin).scheduleWithFixedDelayNonBlockingStateChange(new Runnable(){

            @Override
            public void run() {
                try {
                    ESMImpl.this.checkKeepAlive();
                }
                catch (InternalKeepAliveEventDelayed e) {
                    logger.log(Level.SEVERE, "Event loop error", e);
                }
                finally {
                    ESMImpl.this.keepAlive.set(System.currentTimeMillis());
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Event Loop Keepalive " + ESMImpl.this.keepAlive.get());
                    }
                }
            }
        }, 0L, CHECK_SINGLE_THREAD_EVENT_PUMP_EVERY_SECONDS / 2L, TimeUnit.SECONDS);
    }

    private void startKeepAliveMonitor() {
        this.createKeepAliveMonitorExecutor().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    ESMImpl.this.checkKeepAlive();
                }
                catch (InternalKeepAliveEventDelayed e) {
                    ESMImpl.this.logThreads();
                    logger.log(Level.SEVERE, "Event loop error. Investigate GS-admin-event-executor-thread in the logged thread dump.", e);
                }
            }
        }, 0L, CHECK_SINGLE_THREAD_EVENT_PUMP_EVERY_SECONDS / 10L, TimeUnit.SECONDS);
    }

    private void checkKeepAlive() {
        long now = SystemTime.timeMillis();
        long lastKeepalive = this.keepAlive.get();
        if (lastKeepalive != 0L) {
            long delaySeconds = (now - lastKeepalive) / 1000L;
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Event Loop Keepalive delaySeconds=" + delaySeconds + " threshold=" + CHECK_SINGLE_THREAD_EVENT_PUMP_EVERY_SECONDS);
            }
            if (delaySeconds > CHECK_SINGLE_THREAD_EVENT_PUMP_EVERY_SECONDS) {
                logger.log(Level.INFO, "Event Loop was delayed " + delaySeconds + "seconds.");
                throw new InternalKeepAliveEventDelayed(delaySeconds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logThreads() {
        ThreadDumpProcessor tdp = new ThreadDumpProcessor();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            tdp.processDeadlocks(pw);
            tdp.processAllThreads(pw);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to dump threads", e);
        }
        finally {
            try {
                pw.close();
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Failed to dump threads", e);
            }
            logger.info(sw.toString());
        }
    }

    private ScheduledThreadPoolExecutor createKeepAliveMonitorExecutor() {
        return this.createScheduledThreadPoolExecutor("esm-keep-alive-monitor", 1, true);
    }

    private ScheduledThreadPoolExecutor createScheduledThreadPoolExecutor(String threadName, int numberOfThreads, boolean useDaemonThreads) {
        final ClassLoader correctClassLoader = Thread.currentThread().getContextClassLoader();
        ScheduledThreadPoolExecutor executorService = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(numberOfThreads, (ThreadFactory)new GSThreadFactory(threadName, useDaemonThreads){

            public Thread newThread(Runnable r) {
                Thread thread = super.newThread(r);
                thread.setContextClassLoader(correctClassLoader);
                return thread;
            }
        });
        return executorService;
    }

    public static class PendingElasticPropertiesUpdate {
        private final String _strategyClassName;
        private final Map<String, String> _elasticProperties;
        private final boolean _scaleCommand;

        public PendingElasticPropertiesUpdate(String strategyClassName, Map<String, String> strategyProperties) {
            this._strategyClassName = strategyClassName;
            this._elasticProperties = strategyProperties;
            this._scaleCommand = true;
        }

        public PendingElasticPropertiesUpdate(Map<String, String> properties) {
            this._strategyClassName = null;
            this._elasticProperties = properties;
            this._scaleCommand = false;
        }

        public String getStrategyClassName() {
            return this._strategyClassName;
        }

        public Map<String, String> getElasticProperties() {
            return this._elasticProperties;
        }

        public boolean isScaleCommand() {
            return this._scaleCommand;
        }
    }
}

