/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.esm;

import com.gigaspaces.grid.gsm.PUDetails;
import com.gigaspaces.grid.gsm.PUsDetails;
import com.gigaspaces.internal.utils.concurrent.GSThreadFactory;
import com.gigaspaces.security.SecurityFactory;
import com.gigaspaces.security.service.SecurityResolver;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openspaces.admin.Admin;
import org.openspaces.admin.AdminFactory;
import org.openspaces.admin.GridComponent;
import org.openspaces.admin.esm.ElasticServiceManager;
import org.openspaces.admin.gsm.GridServiceManager;
import org.openspaces.admin.internal.InternalAdminFactory;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.gsm.InternalGridServiceManager;
import org.openspaces.admin.internal.vm.InternalVirtualMachineInfoProvider;
import org.openspaces.admin.lus.LookupService;
import org.openspaces.admin.metrics.MetricProvider;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.space.Space;
import org.openspaces.core.GigaSpace;

public class ESMImplInitializer {
    private static final long DISCOVERY_POLLING_PERIOD_SECONDS = Long.getLong("com.gs.esm.discovery_polling_interval_seconds", 20L);
    private static final Logger logger = Logger.getLogger(ESMImplInitializer.class.getName());
    private static final long WAITFOR_GSM_UPTIME_SECONDS = Long.getLong("com.gs.esm.wait_for_gsm_uptime_seconds", 60L);
    private static final long WAITFOR_LUS_UPTIME_SECONDS = Long.getLong("com.gs.esm.wait_for_lus_uptime_seconds", 60L);
    private static final boolean USE_CLOUDIFY_MANAGEMENT_SPACE = Boolean.getBoolean("org.openspaces.grid.backup-machines-state-to-cloudify-management-space");
    protected static final String CLOUDIFY_MANAGEMENT_SPACE_NAME = "cloudifyManagementSpace";
    private InternalAdmin admin;
    private final AdminCreatedEventListener esmInitializer;
    private ExecutorService executor;

    public ESMImplInitializer(AdminCreatedEventListener adminCreatedEventListener) {
        this.esmInitializer = adminCreatedEventListener;
        final ClassLoader correctClassLoader = Thread.currentThread().getContextClassLoader();
        boolean useDaemonThreads = true;
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new GSThreadFactory("GS-EsmImplInitializer", true){

            public Thread newThread(Runnable r) {
                Thread thread = super.newThread(r);
                thread.setContextClassLoader(correctClassLoader);
                return thread;
            }
        });
        boolean restartAdmin = false;
        this.scheduleAdminInitialization(restartAdmin, 0L, TimeUnit.SECONDS);
    }

    private void scheduleAdminInitialization(boolean restartAdmin, long delay, TimeUnit timeunit) {
        if (restartAdmin) {
            this.closeAdminIfNotNull();
        }
        this.createAdminIfNull();
        if (delay > 0L) {
            logger.info("Waiting " + timeunit.toSeconds(delay) + " seconds for all grid components to register with lookup service");
        }
        this.admin.scheduleOneTimeWithDelayNonBlockingStateChange(new Runnable(){

            @Override
            public void run() {
                if (!ESMImplInitializer.isManagementDiscovered(ESMImplInitializer.this.admin)) {
                    boolean restartAdmin = false;
                    ESMImplInitializer.this.scheduleAdminInitialization(restartAdmin, DISCOVERY_POLLING_PERIOD_SECONDS, TimeUnit.SECONDS);
                    return;
                }
                if (ESMImplInitializer.isOtherESMRunning(ESMImplInitializer.this.admin)) {
                    boolean restartAdmin = true;
                    ESMImplInitializer.this.scheduleAdminInitialization(restartAdmin, DISCOVERY_POLLING_PERIOD_SECONDS, TimeUnit.SECONDS);
                    return;
                }
                final HashMap<String, Integer> numberOfInstancesPerProcessingUnit = new HashMap<String, Integer>();
                for (ProcessingUnit pu : ESMImplInitializer.this.admin.getProcessingUnits()) {
                    numberOfInstancesPerProcessingUnit.put(pu.getName(), pu.getInstances().length);
                }
                final LookupService[] lookupServices = ESMImplInitializer.this.admin.getLookupServices().getLookupServices();
                final GridServiceManager[] gridServiceManagers = ESMImplInitializer.this.admin.getGridServiceManagers().getManagers();
                final Space space = ESMImplInitializer.this.admin.getSpaces().getSpaceByName(ESMImplInitializer.CLOUDIFY_MANAGEMENT_SPACE_NAME);
                if (USE_CLOUDIFY_MANAGEMENT_SPACE && space == null) {
                    logger.log(Level.INFO, "Waiting to discover cloudifyManagementSpace");
                    boolean restartAdmin = false;
                    ESMImplInitializer.this.scheduleAdminInitialization(restartAdmin, DISCOVERY_POLLING_PERIOD_SECONDS, TimeUnit.SECONDS);
                    return;
                }
                ESMImplInitializer.this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (ESMImplInitializer.isManagementAgentsDiscovered(lookupServices, gridServiceManagers) && ESMImplInitializer.isLookupDiscoverySyncedWithGsm(lookupServices, gridServiceManagers, numberOfInstancesPerProcessingUnit)) {
                                GigaSpace gigaSpace = space == null ? null : space.getGigaSpace();
                                ESMImplInitializer.this.esmInitializer.adminCreated(ESMImplInitializer.this.admin, gigaSpace);
                                return;
                            }
                        }
                        catch (Throwable t) {
                            logger.log(Level.SEVERE, "Unexpected error while initializing ESM", t);
                        }
                        boolean restartAdmin = true;
                        ESMImplInitializer.this.scheduleAdminInitialization(restartAdmin, DISCOVERY_POLLING_PERIOD_SECONDS, TimeUnit.SECONDS);
                    }
                });
            }
        }, delay, timeunit);
    }

    private void closeAdminIfNotNull() {
        if (this.admin != null) {
            this.admin.close();
            this.admin = null;
        }
    }

    private void createAdminIfNull() {
        if (this.admin == null) {
            AdminFactory factory = new InternalAdminFactory().singleThreadedEventListeners().useDaemonThreads(true);
            if (SecurityResolver.isSecurityEnabled()) {
                String username = System.getProperty("com.gs.esm.username");
                String password = System.getProperty("com.gs.esm.password");
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("esm-username:" + username + ", esm-password:" + password);
                }
                if (username == null || username.trim().length() == 0) {
                    String securityPropertyFile = System.getProperty("com.gs.security.properties-file", "security.properties");
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("securityPropertyFile:" + securityPropertyFile);
                    }
                    if (securityPropertyFile != null) {
                        InputStream resourceStream = SecurityFactory.findSecurityProperties((String)securityPropertyFile);
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("resourceStream:" + resourceStream);
                        }
                        Properties securityProperties = new Properties();
                        if (resourceStream != null) {
                            try {
                                securityProperties.load(resourceStream);
                                username = securityProperties.getProperty("esm-username");
                                password = securityProperties.getProperty("esm-password");
                                if (logger.isLoggable(Level.FINEST)) {
                                    logger.finest("esm-username from properties:" + username + ", esm-password from properties:" + password);
                                }
                            }
                            catch (IOException e) {
                                logger.log(Level.SEVERE, e.toString(), e);
                            }
                        }
                    }
                }
                factory.credentials(username, password);
            }
            this.admin = (InternalAdmin)factory.createAdmin();
        }
    }

    private static boolean isLookupDiscoverySyncedWithGsm(LookupService[] lookupServices, GridServiceManager[] gridServiceManagers, Map<String, Integer> numberOfInstancesPerProcessingUnit) {
        HashSet<String> managedPus = new HashSet<String>();
        for (GridServiceManager gsm : gridServiceManagers) {
            PUsDetails pUsDetails;
            try {
                pUsDetails = ((InternalGridServiceManager)gsm).getGSM().getPUsDetails();
            }
            catch (RemoteException e) {
                logger.log(Level.WARNING, "Failed to get PU details from GSM", e);
                return false;
            }
            for (PUDetails details : pUsDetails.getDetails()) {
                String puName = details.getName();
                if (!details.isManaging()) continue;
                boolean added = managedPus.add(puName);
                if (!added) {
                    logger.log(Level.WARNING, puName + " seems to have more than one managing GSMs. Waiting for a single managing GSM.");
                    return false;
                }
                int numberOfInstancesAccordingToGsm = details.getActualNumberOfInstances();
                Integer discoveredNumberOfInstances = numberOfInstancesPerProcessingUnit.get(puName);
                if (discoveredNumberOfInstances == null) {
                    logger.log(Level.INFO, "Waiting for PU " + puName + " to be discovered.");
                    return false;
                }
                if (discoveredNumberOfInstances != numberOfInstancesAccordingToGsm) {
                    logger.log(Level.INFO, "Waiting for PU " + puName + " instances to be discovered. Discovered " + discoveredNumberOfInstances + " expected " + numberOfInstancesAccordingToGsm);
                    return false;
                }
                logger.log(Level.INFO, "Discovered " + discoveredNumberOfInstances + " " + puName + " instances.");
            }
        }
        HashSet<String> unmanagedPus = new HashSet<String>(numberOfInstancesPerProcessingUnit.keySet());
        unmanagedPus.removeAll(managedPus);
        if (!unmanagedPus.isEmpty()) {
            logger.log(Level.INFO, "Waiting for a managing GSM for PUs:" + unmanagedPus);
            return false;
        }
        if (!numberOfInstancesPerProcessingUnit.isEmpty()) {
            for (GridServiceManager gridServiceManager : gridServiceManagers) {
                if (ESMImplInitializer.isUptimeEnough("GSM", WAITFOR_GSM_UPTIME_SECONDS, gridServiceManager)) continue;
                return false;
            }
            for (MetricProvider metricProvider : lookupServices) {
                if (ESMImplInitializer.isUptimeEnough("LUS", WAITFOR_LUS_UPTIME_SECONDS, (GridComponent)((Object)metricProvider))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isUptimeEnough(String type, long timeoutSeconds, GridComponent component) {
        try {
            long uptimeSeconds = TimeUnit.MILLISECONDS.toSeconds(((InternalVirtualMachineInfoProvider)((Object)component)).getJVMStatistics().getUptime());
            if (uptimeSeconds < timeoutSeconds) {
                logger.log(Level.INFO, "Waiting for " + type + " " + component.getUid() + " to run for at least " + timeoutSeconds + " but it is running for only " + uptimeSeconds + "seconds.");
                return false;
            }
            logger.log(Level.INFO, type + " " + component.getUid() + " uptime is " + uptimeSeconds + " seconds.");
        }
        catch (RemoteException e) {
            logger.log(Level.WARNING, "Failed to get " + type + " " + component.getUid() + " uptime.", e);
            return false;
        }
        return true;
    }

    private static boolean isOtherESMRunning(InternalAdmin admin) {
        ElasticServiceManager[] elasticServiceManagers = admin.getElasticServiceManagers().getManagers();
        if (elasticServiceManagers.length > 0) {
            logger.log(Level.INFO, "Waiting for other ESM to terminate: " + elasticServiceManagers[0].getUid());
            return true;
        }
        return false;
    }

    private static boolean isManagementDiscovered(InternalAdmin admin) {
        LookupService[] lookupServices = admin.getLookupServices().getLookupServices();
        if (lookupServices.length == 0) {
            logger.log(Level.INFO, "Waiting to discover at least one lookup service.");
            return false;
        }
        GridServiceManager[] gsms = admin.getGridServiceManagers().getManagers();
        if (gsms.length == 0) {
            logger.log(Level.INFO, "Waiting to discover at least one GSM");
            return false;
        }
        return true;
    }

    private static boolean isManagementAgentsDiscovered(LookupService[] lookupServices, GridServiceManager[] gridServiceManagers) {
        for (LookupService lookupService : lookupServices) {
            if (!lookupService.isDiscovered() || lookupService.getAgentId() == -1 || lookupService.getGridServiceAgent() != null) continue;
            logger.log(Level.INFO, "Waiting to discover GSA that started lookup service " + lookupService.getUid());
            return false;
        }
        for (MetricProvider metricProvider : gridServiceManagers) {
            if (!metricProvider.isDiscovered() || metricProvider.getAgentId() == -1 || metricProvider.getGridServiceAgent() != null) continue;
            logger.log(Level.INFO, "Waiting to discover GSA that started GSM " + metricProvider.getUid());
            return false;
        }
        return true;
    }

    public static interface AdminCreatedEventListener {
        public void adminCreated(Admin var1, GigaSpace var2);
    }
}

