/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.esm;

import com.gigaspaces.security.SecurityException;
import com.gigaspaces.security.authorities.GridAuthority;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.service.RemoteSecuredService;
import com.gigaspaces.security.service.SecurityContext;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.jini.id.Uuid;
import org.jini.rio.monitor.event.Events;
import org.jini.rio.resources.servicecore.AbstractProxy;
import org.openspaces.admin.pu.elastic.config.ScaleStrategyConfig;
import org.openspaces.grid.esm.ESM;

public class ESMProxy
extends AbstractProxy
implements ESM,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ESM esmServer;
    private transient Integer cachedAgentId = null;
    private transient String cachedGSAServiceID = null;

    static ESMProxy getInstance(ESM esm, Uuid id) {
        return new ESMProxy(esm, id);
    }

    ESMProxy(ESM esm, Uuid id) {
        super((Remote)((Object)esm), id);
        this.esmServer = esm;
    }

    public int getAgentId() throws RemoteException {
        if (this.cachedAgentId == null) {
            this.cachedAgentId = this.esmServer.getAgentId();
        }
        return this.cachedAgentId;
    }

    public String getGSAServiceID() throws RemoteException {
        if (this.cachedGSAServiceID == null) {
            this.cachedGSAServiceID = this.esmServer.getGSAServiceID();
        }
        return this.cachedGSAServiceID;
    }

    public String[] getManagedProcessingUnits() {
        return this.esmServer.getManagedProcessingUnits();
    }

    public boolean isServiceSecured() throws RemoteException {
        return this.esmServer.isServiceSecured();
    }

    public SecurityContext login(CredentialsProvider credentialsProvider) throws SecurityException, RemoteException {
        return this.login((RemoteSecuredService)this.server, credentialsProvider);
    }

    @Override
    public void setProcessingUnitElasticProperties(String processingUnitName, Map<String, String> properties) throws RemoteException {
        this.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_PU);
        this.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_GRID);
        this.esmServer.setProcessingUnitElasticProperties(processingUnitName, properties);
    }

    @Override
    public void setProcessingUnitScaleStrategy(String puName, ScaleStrategyConfig scaleStrategyConfig) throws RemoteException {
        this.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_PU);
        this.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_GRID);
        this.esmServer.setProcessingUnitScaleStrategy(puName, scaleStrategyConfig);
    }

    @Override
    public ScaleStrategyConfig getProcessingUnitScaleStrategyConfig(String processingUnitName) throws RemoteException {
        this.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_PU);
        return this.esmServer.getProcessingUnitScaleStrategyConfig(processingUnitName);
    }

    public boolean isManagingProcessingUnit(String processingUnitName) throws RemoteException {
        return this.esmServer.isManagingProcessingUnit(processingUnitName);
    }

    public boolean isManagingProcessingUnitAndScaleNotInProgress(String processingUnitName) throws RemoteException {
        return this.esmServer.isManagingProcessingUnitAndScaleNotInProgress(processingUnitName);
    }

    @Override
    public Events getScaleStrategyEvents(long cursor, int maxNumberOfEvents) throws RemoteException {
        this.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_PU);
        return this.esmServer.getScaleStrategyEvents(cursor, maxNumberOfEvents);
    }

    @Override
    public Remote getRemoteApi(String processingUnitName, String apiName) throws RemoteException {
        this.intercept((Privilege)GridAuthority.GridPrivilege.MANAGE_GRID);
        return this.esmServer.getRemoteApi(processingUnitName, apiName);
    }

    @Override
    public void disableAgentFailureDetection(String processingUnitName, long timeout, TimeUnit timeunit) throws RemoteException {
        this.esmServer.disableAgentFailureDetection(processingUnitName, timeout, timeunit);
    }

    @Override
    public void enableAgentFailureDetection(String processingUnitName) throws RemoteException {
        this.esmServer.enableAgentFailureDetection(processingUnitName);
    }
}

