/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jini.rio.monitor.event.EventsStore;
import org.openspaces.admin.bean.BeanConfigurationException;
import org.openspaces.admin.bean.BeanInitializationException;
import org.openspaces.admin.internal.pu.elastic.ElasticMachineIsolationConfig;
import org.openspaces.admin.internal.pu.elastic.ProcessingUnitSchemaConfig;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.core.bean.Bean;
import org.openspaces.core.bean.BeanServer;
import org.openspaces.core.bean.DefaultBeanFactory;
import org.openspaces.grid.gsm.ElasticConfigBean;
import org.openspaces.grid.gsm.ElasticMachineProvisioningAware;
import org.openspaces.grid.gsm.GridServiceAgentFailureDetectionConfigAware;
import org.openspaces.grid.gsm.GridServiceContainerConfigAware;
import org.openspaces.grid.gsm.ProcessingUnitAware;
import org.openspaces.grid.gsm.autoscaling.AutoScalingSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.autoscaling.AutoScalingSlaEnforcementEndpointAware;
import org.openspaces.grid.gsm.containers.ContainersSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.containers.ContainersSlaEnforcementEndpointAware;
import org.openspaces.grid.gsm.machines.MachinesSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.machines.MachinesSlaEnforcementEndpointAware;
import org.openspaces.grid.gsm.machines.backup.MachinesStateBackup;
import org.openspaces.grid.gsm.machines.backup.MachinesStateBackupAware;
import org.openspaces.grid.gsm.machines.isolation.ElasticProcessingUnitMachineIsolation;
import org.openspaces.grid.gsm.machines.isolation.ElasticProcessingUnitMachineIsolationAware;
import org.openspaces.grid.gsm.machines.isolation.ElasticProcessingUnitMachineIsolationFactory;
import org.openspaces.grid.gsm.machines.plugins.ElasticMachineProvisioning;
import org.openspaces.grid.gsm.machines.plugins.NonBlockingElasticMachineProvisioning;
import org.openspaces.grid.gsm.machines.plugins.NonBlockingElasticMachineProvisioningAdapterFactory;
import org.openspaces.grid.gsm.rebalancing.RebalancingSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.rebalancing.RebalancingSlaEnforcementEndpointAware;
import org.openspaces.grid.gsm.strategy.ElasticScaleStrategyEventStorageAware;

public class ScaleBeanFactory
extends DefaultBeanFactory<Bean> {
    private static final Log logger = LogFactory.getLog(ScaleBeanFactory.class);
    private final RebalancingSlaEnforcementEndpoint rebalancingSlaEnforcementEndpoint;
    private final ContainersSlaEnforcementEndpoint containersSlaEnforcementEndpoint;
    private final MachinesSlaEnforcementEndpoint machinesSlaEnforcementEndpoint;
    private final AutoScalingSlaEnforcementEndpoint autoScalingSlaEnforcementEndpoint;
    private final ProcessingUnit pu;
    private final ProcessingUnitSchemaConfig schemaConfig;
    private final NonBlockingElasticMachineProvisioningAdapterFactory nonBlockingAdapterFactory;
    private final ElasticMachineIsolationConfig isolationConfig;
    private final EventsStore eventStore;
    private final MachinesStateBackup machinesStateBackup;

    ScaleBeanFactory(ProcessingUnit pu, ProcessingUnitSchemaConfig schemaConfig, RebalancingSlaEnforcementEndpoint rebalancingSlaEnforcementEndpoint, ContainersSlaEnforcementEndpoint containersSlaEnforcementEndpoint, MachinesSlaEnforcementEndpoint machinesSlaEnforcementEndpoint, AutoScalingSlaEnforcementEndpoint autoScalingSlaEnforcementEndpoint, NonBlockingElasticMachineProvisioningAdapterFactory nonBlockingAdapterFactory, ElasticMachineIsolationConfig isolationConfig, EventsStore eventStore, MachinesStateBackup machinesStateBackup) {
        super(pu.getAdmin());
        this.schemaConfig = schemaConfig;
        this.rebalancingSlaEnforcementEndpoint = rebalancingSlaEnforcementEndpoint;
        this.containersSlaEnforcementEndpoint = containersSlaEnforcementEndpoint;
        this.machinesSlaEnforcementEndpoint = machinesSlaEnforcementEndpoint;
        this.autoScalingSlaEnforcementEndpoint = autoScalingSlaEnforcementEndpoint;
        this.nonBlockingAdapterFactory = nonBlockingAdapterFactory;
        this.pu = pu;
        this.isolationConfig = isolationConfig;
        this.eventStore = eventStore;
        this.machinesStateBackup = machinesStateBackup;
    }

    @Override
    protected Bean createInstance(String className, Map<String, String> properties, BeanServer<Bean> beanServer) throws BeanConfigurationException, BeanInitializationException {
        ElasticConfigBean elasticConfigBean;
        logger.debug((Object)("Creating instance of class " + className));
        Bean instance = super.createInstance(className, properties, beanServer);
        if (instance instanceof MachinesSlaEnforcementEndpointAware) {
            MachinesSlaEnforcementEndpointAware minstance = (MachinesSlaEnforcementEndpointAware)((Object)instance);
            minstance.setMachinesSlaEnforcementEndpoint(this.machinesSlaEnforcementEndpoint);
        }
        if (instance instanceof ContainersSlaEnforcementEndpointAware) {
            ContainersSlaEnforcementEndpointAware cinstance = (ContainersSlaEnforcementEndpointAware)((Object)instance);
            cinstance.setContainersSlaEnforcementEndpoint(this.containersSlaEnforcementEndpoint);
        }
        if (instance instanceof RebalancingSlaEnforcementEndpointAware) {
            RebalancingSlaEnforcementEndpointAware rinstance = (RebalancingSlaEnforcementEndpointAware)((Object)instance);
            rinstance.setRebalancingSlaEnforcementEndpoint(this.rebalancingSlaEnforcementEndpoint);
        }
        if (instance instanceof AutoScalingSlaEnforcementEndpointAware) {
            AutoScalingSlaEnforcementEndpointAware ainstance = (AutoScalingSlaEnforcementEndpointAware)((Object)instance);
            ainstance.setAutoScalingSlaEnforcementEndpoint(this.autoScalingSlaEnforcementEndpoint);
        }
        if (instance instanceof ProcessingUnitAware) {
            ((ProcessingUnitAware)((Object)instance)).setProcessingUnit(this.pu);
            ((ProcessingUnitAware)((Object)instance)).setProcessingUnitSchema(this.schemaConfig);
        }
        if (instance instanceof ElasticMachineProvisioningAware) {
            NonBlockingElasticMachineProvisioning machineProvisioning = this.getNonBlockingElasticMachineProvisioningBean(beanServer);
            ((ElasticMachineProvisioningAware)((Object)instance)).setElasticMachineProvisioning(machineProvisioning);
        }
        if (instance instanceof ElasticScaleStrategyEventStorageAware) {
            ((ElasticScaleStrategyEventStorageAware)((Object)instance)).setElasticScaleStrategyEventStorage(this.eventStore);
        }
        if (instance instanceof ElasticProcessingUnitMachineIsolationAware) {
            ElasticProcessingUnitMachineIsolation isolation = new ElasticProcessingUnitMachineIsolationFactory().create(this.pu.getName(), this.isolationConfig);
            ((ElasticProcessingUnitMachineIsolationAware)((Object)instance)).setElasticProcessingUnitMachineIsolation(isolation);
        }
        if (instance instanceof MachinesStateBackupAware) {
            ((MachinesStateBackupAware)((Object)instance)).setMachinesStateBackup(this.machinesStateBackup);
        }
        if ((elasticConfigBean = this.findElasticConfigBean(beanServer)) != null) {
            if (instance instanceof GridServiceContainerConfigAware) {
                ((GridServiceContainerConfigAware)((Object)instance)).setGridServiceContainerConfig(elasticConfigBean.getGridServiceContainerConfig());
            }
            if (instance instanceof GridServiceAgentFailureDetectionConfigAware) {
                ((GridServiceAgentFailureDetectionConfigAware)((Object)instance)).setAgentFailureDetectionConfig(elasticConfigBean.getAgentFailureDetectionConfig());
            }
        }
        return instance;
    }

    private NonBlockingElasticMachineProvisioning getNonBlockingElasticMachineProvisioningBean(BeanServer<Bean> beanServer) {
        List<Bean> injectedInstances = beanServer.getEnabledBeansAssignableTo(new Class[]{ElasticMachineProvisioning.class, NonBlockingElasticMachineProvisioning.class});
        NonBlockingElasticMachineProvisioning machineProvisioning = null;
        for (Bean injectedInstance : injectedInstances) {
            if (injectedInstance instanceof ElasticMachineProvisioning) {
                machineProvisioning = this.nonBlockingAdapterFactory.create((ElasticMachineProvisioning)((Object)injectedInstance));
                break;
            }
            if (!(injectedInstance instanceof NonBlockingElasticMachineProvisioning)) continue;
            machineProvisioning = (NonBlockingElasticMachineProvisioning)((Object)injectedInstance);
            break;
        }
        if (machineProvisioning == null) {
            throw new IllegalStateException("machineProvisioning bean cannot be found");
        }
        return machineProvisioning;
    }

    ElasticConfigBean findElasticConfigBean(BeanServer<Bean> beanServer) {
        List<Bean> injectedInstances = beanServer.getEnabledBeansAssignableTo(new Class[]{ElasticConfigBean.class});
        if (!injectedInstances.isEmpty()) {
            return (ElasticConfigBean)injectedInstances.get(0);
        }
        return null;
    }
}

