/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jini.rio.monitor.event.EventsStore;
import org.openspaces.admin.bean.BeanConfigException;
import org.openspaces.admin.bean.BeanConfigPropertiesManager;
import org.openspaces.admin.bean.BeanConfigurationException;
import org.openspaces.admin.internal.pu.elastic.ElasticMachineIsolationConfig;
import org.openspaces.admin.internal.pu.elastic.MachineProvisioningBeanPropertiesManager;
import org.openspaces.admin.internal.pu.elastic.ProcessingUnitSchemaConfig;
import org.openspaces.admin.internal.pu.elastic.ScaleStrategyBeanPropertiesManager;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.core.bean.Bean;
import org.openspaces.core.bean.BeanServer;
import org.openspaces.core.bean.DefaultBeanServer;
import org.openspaces.grid.gsm.ElasticConfigBean;
import org.openspaces.grid.gsm.ScaleBeanFactory;
import org.openspaces.grid.gsm.autoscaling.AutoScalingSlaEnforcement;
import org.openspaces.grid.gsm.autoscaling.AutoScalingSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.containers.ContainersSlaEnforcement;
import org.openspaces.grid.gsm.containers.ContainersSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.machines.MachinesSlaEnforcement;
import org.openspaces.grid.gsm.machines.MachinesSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.machines.backup.MachinesStateBackup;
import org.openspaces.grid.gsm.machines.plugins.ElasticMachineProvisioning;
import org.openspaces.grid.gsm.machines.plugins.NonBlockingElasticMachineProvisioning;
import org.openspaces.grid.gsm.machines.plugins.NonBlockingElasticMachineProvisioningAdapterFactory;
import org.openspaces.grid.gsm.rebalancing.RebalancingSlaEnforcement;
import org.openspaces.grid.gsm.rebalancing.RebalancingSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.strategy.ScaleStrategyBean;
import org.openspaces.grid.gsm.strategy.UndeployScaleStrategyBean;

public class ScaleBeanServer {
    private final BeanServer<Bean> beanServer;
    private final ProcessingUnit pu;
    private final RebalancingSlaEnforcement rebalancingSlaEnforcement;
    private final MachinesSlaEnforcement machinesSlaEnforcement;
    private final ContainersSlaEnforcement containersSlaEnforcement;
    private final AutoScalingSlaEnforcement autoScalingSlaEnforcement;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScaleBeanServer(ProcessingUnit pu, ProcessingUnitSchemaConfig schemaConfig, RebalancingSlaEnforcement rebalancingSlaEnforcement, ContainersSlaEnforcement containersSlaEnforcement, MachinesSlaEnforcement machinesSlaEnforcement, AutoScalingSlaEnforcement autoScalingSlaEnforcement, NonBlockingElasticMachineProvisioningAdapterFactory nonBlockingAdapterFactory, ElasticMachineIsolationConfig isolationConfig, EventsStore eventStore, MachinesStateBackup machinesStateBackup) {
        if (pu == null) {
            throw new IllegalArgumentException("pu cannot be null");
        }
        if (rebalancingSlaEnforcement == null) {
            throw new IllegalArgumentException("rebalancingSlaEnforcement cannot be null");
        }
        if (containersSlaEnforcement == null) {
            throw new IllegalArgumentException("containersSlaEnforcement cannot be null");
        }
        if (machinesSlaEnforcement == null) {
            throw new IllegalArgumentException("machinesSlaEnforcement cannot be null");
        }
        if (autoScalingSlaEnforcement == null) {
            throw new IllegalArgumentException("autoScalingEnforcement cannot be null");
        }
        if (eventStore == null) {
            throw new IllegalArgumentException("eventStorage cannot be null");
        }
        this.pu = pu;
        this.rebalancingSlaEnforcement = rebalancingSlaEnforcement;
        this.containersSlaEnforcement = containersSlaEnforcement;
        this.machinesSlaEnforcement = machinesSlaEnforcement;
        this.autoScalingSlaEnforcement = autoScalingSlaEnforcement;
        MachinesSlaEnforcementEndpoint machinesSlaEnforcementEndpoint = null;
        ContainersSlaEnforcementEndpoint containersSlaEnforcementEndpoint = null;
        RebalancingSlaEnforcementEndpoint rebalancingSlaEnforcementEndpoint = null;
        AutoScalingSlaEnforcementEndpoint autoScalingSlaEnforcementEndpoint = null;
        try {
            containersSlaEnforcementEndpoint = containersSlaEnforcement.createEndpoint(pu);
            machinesSlaEnforcementEndpoint = machinesSlaEnforcement.createEndpoint(pu);
            rebalancingSlaEnforcementEndpoint = rebalancingSlaEnforcement.createEndpoint(pu);
            autoScalingSlaEnforcementEndpoint = autoScalingSlaEnforcement.createEndpoint(pu);
        }
        finally {
            if (containersSlaEnforcementEndpoint == null || machinesSlaEnforcementEndpoint == null || rebalancingSlaEnforcementEndpoint == null || autoScalingSlaEnforcementEndpoint == null) {
                this.destroyAllEndpointsForPu(pu);
            }
        }
        this.beanServer = new DefaultBeanServer<Bean>(new ScaleBeanFactory(pu, schemaConfig, rebalancingSlaEnforcementEndpoint, containersSlaEnforcementEndpoint, machinesSlaEnforcementEndpoint, autoScalingSlaEnforcementEndpoint, nonBlockingAdapterFactory, isolationConfig, eventStore, machinesStateBackup));
    }

    private void destroyAllEndpointsForPu(ProcessingUnit pu) {
        this.rebalancingSlaEnforcement.destroyEndpoint(pu);
        this.containersSlaEnforcement.destroyEndpoint(pu);
        this.machinesSlaEnforcement.destroyEndpoint(pu);
        this.autoScalingSlaEnforcement.destroyEndpoint(pu);
    }

    public void undeploy() {
        List<String> enabledBeanClassNames;
        try {
            enabledBeanClassNames = this.beanServer.getEnabledBeansClassNamesAssignableTo(new Class[]{ScaleStrategyBean.class});
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        if (enabledBeanClassNames.size() > 0) {
            Map<String, String> properties = this.beanServer.getBeanConfig(enabledBeanClassNames.get(0));
            this.beanServer.replaceBeanAssignableTo(new Class[]{ScaleStrategyBean.class}, UndeployScaleStrategyBean.class.getName(), properties);
        }
    }

    public void destroy() {
        this.beanServer.destroy();
        this.destroyAllEndpointsForPu(this.pu);
    }

    public void setElasticProperties(Map<String, String> elasticProperties) throws BeanConfigException {
        boolean changedElasticConfig = this.setElasticConfig(elasticProperties);
        boolean changedElasticMachineProvisioning = this.setElasticMachineProvisioning(elasticProperties);
        boolean forceScaleStrategy = changedElasticConfig || changedElasticMachineProvisioning;
        this.setElasticScaleStrategy(elasticProperties, forceScaleStrategy);
    }

    private boolean setElasticConfig(Map<String, String> elasticProperties) {
        return this.beanServer.replaceBeanAssignableTo(new Class[]{ElasticConfigBean.class}, ElasticConfigBean.class.getName(), elasticProperties);
    }

    private boolean setElasticScaleStrategy(Map<String, String> elasticProperties, boolean force) {
        ScaleStrategyBeanPropertiesManager scaleStrategyBeanPropertiesManager = new ScaleStrategyBeanPropertiesManager(elasticProperties);
        String enabledBeanClassName = this.getEnabledBeanClassName(scaleStrategyBeanPropertiesManager);
        if (enabledBeanClassName == null) {
            throw new BeanConfigurationException("scale strategy is not defined");
        }
        if (force) {
            this.beanServer.disableAllBeansAssignableTo(ScaleStrategyBean.class);
        }
        HashMap<String, String> beanProperties = new HashMap<String, String>(scaleStrategyBeanPropertiesManager.getBeanConfig(enabledBeanClassName));
        return this.beanServer.replaceBeanAssignableTo(new Class[]{ScaleStrategyBean.class}, enabledBeanClassName, beanProperties);
    }

    private boolean setElasticMachineProvisioning(Map<String, String> elasticProperties) {
        MachineProvisioningBeanPropertiesManager propertiesManager = new MachineProvisioningBeanPropertiesManager(elasticProperties);
        String enabledBeanClassName = this.getEnabledBeanClassName(propertiesManager);
        if (enabledBeanClassName == null) {
            throw new BeanConfigurationException("machine provisioning is not defined");
        }
        HashMap<String, String> beanProperties = new HashMap<String, String>(propertiesManager.getBeanConfig(enabledBeanClassName));
        return this.beanServer.replaceBeanAssignableTo(new Class[]{ElasticMachineProvisioning.class, NonBlockingElasticMachineProvisioning.class}, enabledBeanClassName, beanProperties);
    }

    public ScaleStrategyBean getEnabledBean() {
        ScaleStrategyBean bean = null;
        List<Bean> enabledBeanAssignableTo = this.beanServer.getEnabledBeansAssignableTo(new Class[]{ScaleStrategyBean.class});
        if (!enabledBeanAssignableTo.isEmpty()) {
            bean = (ScaleStrategyBean)enabledBeanAssignableTo.get(0);
        }
        return bean;
    }

    private String getEnabledBeanClassName(BeanConfigPropertiesManager propertiesManager) {
        Object[] enabledBeansClassNames = propertiesManager.getEnabledBeansClassNames();
        if (enabledBeansClassNames.length > 1) {
            throw new BeanConfigurationException("At most one of the following beans can be enabled: " + Arrays.toString(enabledBeansClassNames));
        }
        Object enabledBeanClassName = null;
        if (enabledBeansClassNames.length == 1) {
            enabledBeanClassName = enabledBeansClassNames[0];
        }
        return enabledBeanClassName;
    }
}

