/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm;

import com.gigaspaces.time.SystemTime;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;

public class SingleThreadedPollingLog
implements Log {
    private static final long DEFAULT_DISCARD_MILLISECONDS = 60000L;
    long lastFlushMilliseconds;
    Set<String> traceHistory = new HashSet<String>();
    Set<String> debugHistory = new HashSet<String>();
    Set<String> infoHistory = new HashSet<String>();
    Set<String> warnHistory = new HashSet<String>();
    Set<String> errorHistory = new HashSet<String>();
    Set<String> fatalHistory = new HashSet<String>();
    private final long discardPeriodMilliseconds;
    private final Log logger;

    public SingleThreadedPollingLog(Log logger) {
        this(logger, 60000L, TimeUnit.MILLISECONDS);
    }

    public SingleThreadedPollingLog(Log logger, long discardSameLogEntriesPeriod, TimeUnit unit) {
        this.discardPeriodMilliseconds = TimeUnit.MILLISECONDS.convert(discardSameLogEntriesPeriod, unit);
        this.logger = logger;
    }

    public void debug(Object message) {
        this.flushHistory();
        String string = message.toString();
        if (string == null || string.length() == 0 || !this.debugHistory.contains(string)) {
            this.debugHistory.add(string);
            this.logger.debug(message);
        }
    }

    public void debug(Object message, Throwable t) {
        this.flushHistory();
        String string = message.toString();
        if (string == null || string.length() == 0 || !this.debugHistory.contains(string)) {
            this.debugHistory.add(string);
            this.logger.debug(message, t);
        }
    }

    public void error(Object message) {
        this.flushHistory();
        String string = message.toString();
        if (string == null || string.length() == 0 || !this.errorHistory.contains(string)) {
            this.errorHistory.add(string);
            this.logger.error(message);
        }
    }

    public void error(Object message, Throwable t) {
        this.flushHistory();
        String string = message.toString();
        if (string == null || string.length() == 0 || !this.errorHistory.contains(string)) {
            this.errorHistory.add(string);
            this.logger.error(message, t);
        }
    }

    public void fatal(Object message) {
        this.flushHistory();
        String string = message.toString();
        if (string == null || string.length() == 0 || !this.fatalHistory.contains(string)) {
            this.fatalHistory.add(string);
            this.logger.fatal(message);
        }
    }

    public void fatal(Object message, Throwable t) {
        this.flushHistory();
        String string = message.toString();
        if (string == null || string.length() == 0 || !this.fatalHistory.contains(string)) {
            this.fatalHistory.add(string);
            this.logger.fatal(message, t);
        }
    }

    public void info(Object message) {
        this.flushHistory();
        String string = message.toString();
        if (string == null || string.length() == 0 || !this.infoHistory.contains(string)) {
            this.infoHistory.add(string);
            this.logger.info(message);
        }
    }

    public void info(Object message, Throwable t) {
        this.flushHistory();
        String string = message.toString();
        if (string == null || string.length() == 0 || !this.infoHistory.contains(string)) {
            this.infoHistory.add(string);
            this.logger.info(message, t);
        }
    }

    public void trace(Object message) {
        this.flushHistory();
        String string = message.toString();
        if (string == null || string.length() == 0 || !this.traceHistory.contains(string)) {
            this.traceHistory.add(string);
            this.logger.trace(message);
        }
    }

    public void trace(Object message, Throwable t) {
        this.flushHistory();
        String string = message.toString();
        if (string == null || string.length() == 0 || !this.traceHistory.contains(string)) {
            this.traceHistory.add(string);
            this.logger.trace(message, t);
        }
    }

    public void warn(Object message) {
        this.flushHistory();
        String string = message.toString();
        if (string == null || string.length() == 0 || !this.warnHistory.contains(string)) {
            this.warnHistory.add(string);
            this.logger.warn(message);
        }
    }

    public void warn(Object message, Throwable t) {
        this.flushHistory();
        String string = message.toString();
        if (string == null || string.length() == 0 || !this.warnHistory.contains(string)) {
            this.warnHistory.add(string);
            this.logger.warn(message, t);
        }
    }

    private void flushHistory() {
        long now = SystemTime.timeMillis();
        if (this.lastFlushMilliseconds + this.discardPeriodMilliseconds <= now) {
            this.lastFlushMilliseconds = now;
            this.traceHistory.clear();
            this.debugHistory.clear();
            this.infoHistory.clear();
            this.warnHistory.clear();
            this.errorHistory.clear();
            this.fatalHistory.clear();
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.logger.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }
}

