/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.autoscaling;

import java.util.HashMap;
import java.util.Map;
import org.openspaces.admin.Admin;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.grid.gsm.autoscaling.AutoScalingSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.autoscaling.DefaultAutoScalingSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.sla.ServiceLevelAgreementEnforcement;
import org.openspaces.grid.gsm.sla.exceptions.ServiceLevelAgreementEnforcementEndpointAlreadyExistsException;

public class AutoScalingSlaEnforcement
implements ServiceLevelAgreementEnforcement<AutoScalingSlaEnforcementEndpoint> {
    private final Map<ProcessingUnit, AutoScalingSlaEnforcementEndpoint> endpoints = new HashMap<ProcessingUnit, AutoScalingSlaEnforcementEndpoint>();
    private final Admin admin;

    public AutoScalingSlaEnforcement(Admin admin) {
        this.admin = admin;
    }

    @Override
    public AutoScalingSlaEnforcementEndpoint createEndpoint(ProcessingUnit pu) throws ServiceLevelAgreementEnforcementEndpointAlreadyExistsException {
        if (!this.isEndpointDestroyed(pu)) {
            throw new ServiceLevelAgreementEnforcementEndpointAlreadyExistsException();
        }
        DefaultAutoScalingSlaEnforcementEndpoint endpoint = new DefaultAutoScalingSlaEnforcementEndpoint(pu);
        this.endpoints.put(pu, endpoint);
        return endpoint;
    }

    @Override
    public void destroyEndpoint(ProcessingUnit pu) {
        this.endpoints.remove(pu);
    }

    public void destroy() throws Exception {
        for (ProcessingUnit pu : this.endpoints.keySet()) {
            this.destroyEndpoint(pu);
        }
    }

    private boolean isEndpointDestroyed(ProcessingUnit pu) {
        return this.endpoints.get(pu) == null;
    }
}

