/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.autoscaling;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.internal.pu.InternalProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.pu.statistics.LastSampleTimeWindowStatisticsConfig;
import org.openspaces.admin.pu.statistics.ProcessingUnitStatisticsId;
import org.openspaces.admin.pu.statistics.SingleInstanceStatisticsConfig;
import org.openspaces.admin.pu.statistics.SingleInstanceStatisticsConfigurer;
import org.openspaces.admin.zone.config.ExactZonesConfig;
import org.openspaces.admin.zone.config.ZonesConfig;
import org.openspaces.grid.gsm.autoscaling.exceptions.AutoScalingInstanceStatisticsException;
import org.openspaces.grid.gsm.autoscaling.exceptions.AutoScalingSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.autoscaling.exceptions.AutoScalingStatisticsException;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;
import org.openspaces.grid.gsm.capacity.CapacityRequirementsPerZones;

public class AutoScalingSlaUtils {
    private static Log logger = LogFactory.getLog((String)AutoScalingSlaUtils.class.getName());
    private static final DecimalFormat decimalFormat = AutoScalingSlaUtils.initDecimalFormat();

    public static int compare(Comparable<?> threshold, Object value) throws NumberFormatException {
        if (threshold.getClass().equals(value.getClass())) {
            return threshold.compareTo(value);
        }
        return AutoScalingSlaUtils.toDouble(threshold).compareTo(AutoScalingSlaUtils.toDouble(value));
    }

    private static Double toDouble(Object x) throws NumberFormatException {
        if (x instanceof Number) {
            return ((Number)x).doubleValue();
        }
        return Double.valueOf(x.toString());
    }

    public static CapacityRequirements getMaximumCapacity(CapacityRequirements totalMax, CapacityRequirements maxPerZone, CapacityRequirementsPerZones enforced, CapacityRequirementsPerZones newPlanned, ZonesConfig zones) {
        HashSet<ZonesConfig> zoness = new HashSet<ZonesConfig>();
        zoness.addAll(enforced.getZones());
        zoness.addAll(newPlanned.getZones());
        zoness.add(zones);
        CapacityRequirements maximumCapacity = totalMax;
        for (ZonesConfig otherZone : zoness) {
            if (zones.equals(otherZone)) continue;
            CapacityRequirements otherLastEnforced = enforced.getZonesCapacityOrZero(otherZone);
            CapacityRequirements otherNewPlanned = newPlanned.getZonesCapacityOrZero(otherZone);
            CapacityRequirements otherMaximumCapacity = otherLastEnforced.max(otherNewPlanned).min(maxPerZone);
            maximumCapacity = maximumCapacity.subtractOrZero(otherMaximumCapacity);
        }
        maximumCapacity = maximumCapacity.min(maxPerZone);
        return maximumCapacity;
    }

    public static CapacityRequirements getMinimumCapacity(CapacityRequirements totalMin, CapacityRequirements minPerZone, CapacityRequirementsPerZones enforced, CapacityRequirementsPerZones newPlanned, ZonesConfig zones) {
        HashSet<ZonesConfig> zoness = new HashSet<ZonesConfig>();
        zoness.addAll(enforced.getZones());
        zoness.addAll(newPlanned.getZones());
        zoness.add(zones);
        CapacityRequirements minimumRequierements = totalMin;
        for (ZonesConfig otherZone : zoness) {
            if (zones.equals(otherZone)) continue;
            CapacityRequirements otherLastEnforced = enforced.getZonesCapacityOrZero(otherZone);
            CapacityRequirements otherNewPlanned = newPlanned.getZonesCapacityOrZero(otherZone);
            CapacityRequirements otherMinimumCapacity = null;
            otherMinimumCapacity = otherNewPlanned.equalsZero() ? otherLastEnforced.max(minPerZone) : otherLastEnforced.min(otherNewPlanned).max(minPerZone);
            minimumRequierements = minimumRequierements.subtractOrZero(otherMinimumCapacity);
        }
        minimumRequierements = minimumRequierements.max(minPerZone);
        return minimumRequierements;
    }

    public static Object getStatisticsValue(ProcessingUnit pu, Map<ProcessingUnitStatisticsId, Object> statistics, ProcessingUnitStatisticsId ruleStatisticsId) throws AutoScalingSlaEnforcementInProgressException {
        ruleStatisticsId.validate();
        for (ProcessingUnitInstance instance : pu) {
            ExactZonesConfig puInstanceExactZones = ((InternalProcessingUnit)pu).getHostingGridServiceAgentZones(instance);
            if (!puInstanceExactZones.isStasfies(ruleStatisticsId.getAgentZones())) continue;
            SingleInstanceStatisticsConfig singleInstanceStatistics = new SingleInstanceStatisticsConfigurer().instance(instance).create();
            ProcessingUnitStatisticsId singleInstanceLastSampleStatisticsId = ruleStatisticsId.shallowClone();
            singleInstanceLastSampleStatisticsId.setInstancesStatistics(singleInstanceStatistics);
            singleInstanceLastSampleStatisticsId.setAgentZones(puInstanceExactZones);
            singleInstanceLastSampleStatisticsId.setTimeWindowStatistics(new LastSampleTimeWindowStatisticsConfig());
            singleInstanceLastSampleStatisticsId.validate();
            if (!statistics.containsKey(singleInstanceLastSampleStatisticsId)) {
                AutoScalingInstanceStatisticsException exception = new AutoScalingInstanceStatisticsException(instance, singleInstanceLastSampleStatisticsId.getMetric());
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Failed to find statistics id = " + singleInstanceLastSampleStatisticsId + " in pu statistics. current statistics key set = " + statistics.keySet()), (Throwable)exception);
                }
                throw exception;
            }
            ProcessingUnitStatisticsId singleInstanceStatisticsId = ruleStatisticsId.shallowClone();
            singleInstanceStatisticsId.setInstancesStatistics(singleInstanceStatistics);
            singleInstanceLastSampleStatisticsId.setAgentZones(puInstanceExactZones);
            singleInstanceStatisticsId.validate();
            if (!statistics.containsKey(singleInstanceStatisticsId)) {
                AutoScalingInstanceStatisticsException exception = new AutoScalingInstanceStatisticsException(instance, singleInstanceStatisticsId.getMetric());
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Failed to find statistics id = " + singleInstanceStatisticsId + " in pu statistics. current statistics key set = " + statistics.keySet()), (Throwable)exception);
                }
                throw exception;
            }
            ProcessingUnitStatisticsId singleInstanceTimeWindowZoneStatisticsId = ruleStatisticsId.shallowClone();
            singleInstanceTimeWindowZoneStatisticsId.setInstancesStatistics(singleInstanceStatistics);
            singleInstanceTimeWindowZoneStatisticsId.validate();
            if (statistics.containsKey(singleInstanceTimeWindowZoneStatisticsId)) continue;
            AutoScalingInstanceStatisticsException exception = new AutoScalingInstanceStatisticsException(instance, singleInstanceTimeWindowZoneStatisticsId.getMetric());
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Failed to find statistics id = " + singleInstanceTimeWindowZoneStatisticsId + " in pu statistics. current statistics key set = " + statistics.keySet()), (Throwable)exception);
            }
            throw exception;
        }
        Object value = statistics.get(ruleStatisticsId);
        if (value == null) {
            logger.debug((Object)("statistics value for " + ruleStatisticsId + " was null."));
            throw new AutoScalingStatisticsException(pu, ruleStatisticsId);
        }
        return value;
    }

    private static DecimalFormat initDecimalFormat() {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormatSymbols.setGroupingSeparator(',');
        return new DecimalFormat("#,##0.##", decimalFormatSymbols);
    }

    public static String formatMetricValue(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Double) {
            return AutoScalingSlaUtils.formatDouble(value);
        }
        return value.toString();
    }

    private static String formatDouble(Object value) {
        return decimalFormat.format((Double)value);
    }
}

