/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.autoscaling;

import com.gigaspaces.time.SystemTime;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.openspaces.admin.internal.pu.InternalProcessingUnit;
import org.openspaces.admin.pu.DeploymentStatus;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.grid.gsm.autoscaling.exceptions.AutoScalingTemporarilyDisabledCooldownException;

public class AutomaticCapacityCooldownValidator {
    private long cooldownAfterInstanceRemovedMillis;
    private long cooldownAfterInstanceAddedMillis;
    private Set<String> previousInstancesUids;
    private DeploymentStatus previousDeploymentStatus;
    private Long cooldownExpiredTimestamp = 0L;
    private InternalProcessingUnit processingUnit;

    public void setCooldownAfterInstanceRemoved(long period, TimeUnit timeUnit) {
        this.cooldownAfterInstanceRemovedMillis = timeUnit.toMillis(period);
    }

    public void setCooldownAfterInstanceAdded(long period, TimeUnit timeUnit) {
        this.cooldownAfterInstanceAddedMillis = timeUnit.toMillis(period);
    }

    public void setProcessingUnit(InternalProcessingUnit processingUnit) {
        this.processingUnit = processingUnit;
    }

    public void validate() throws AutoScalingTemporarilyDisabledCooldownException {
        this.validate(this.processingUnit.getStatus(), this.getInstancesUids(), SystemTime.timeMillis());
    }

    public void validate(DeploymentStatus deploymentStatus, Set<String> existingInstancesUids, long currentTimeMillis) throws AutoScalingTemporarilyDisabledCooldownException {
        this.updateCooldownTimestamp(deploymentStatus, existingInstancesUids, currentTimeMillis);
        if (this.cooldownExpiredTimestamp >= currentTimeMillis) {
            throw new AutoScalingTemporarilyDisabledCooldownException((ProcessingUnit)this.processingUnit, this.cooldownExpiredTimestamp - currentTimeMillis);
        }
    }

    private void updateCooldownTimestamp(DeploymentStatus existingDeploymentStatus, Set<String> existingInstancesUids, long currentTimeMillis) {
        boolean isInstanceJustStarted;
        HashSet<String> addedInstancesUids = new HashSet<String>();
        addedInstancesUids.addAll(existingInstancesUids);
        if (this.previousInstancesUids != null) {
            addedInstancesUids.removeAll(this.previousInstancesUids);
        }
        HashSet<String> removedInstancesUids = new HashSet<String>();
        if (this.previousInstancesUids != null) {
            removedInstancesUids.addAll(this.previousInstancesUids);
            removedInstancesUids.removeAll(existingInstancesUids);
        }
        boolean bl = isInstanceJustStarted = addedInstancesUids.isEmpty() && removedInstancesUids.isEmpty() && this.previousDeploymentStatus != DeploymentStatus.INTACT && existingDeploymentStatus == DeploymentStatus.INTACT;
        if (!addedInstancesUids.isEmpty() || isInstanceJustStarted) {
            this.cooldownExpiredTimestamp = Math.max(this.cooldownExpiredTimestamp, currentTimeMillis + this.cooldownAfterInstanceAddedMillis);
            this.previousInstancesUids = existingInstancesUids;
            this.previousDeploymentStatus = existingDeploymentStatus;
        }
        if (!removedInstancesUids.isEmpty()) {
            this.cooldownExpiredTimestamp = Math.max(this.cooldownExpiredTimestamp, currentTimeMillis + this.cooldownAfterInstanceRemovedMillis);
            this.previousInstancesUids = existingInstancesUids;
            this.previousDeploymentStatus = existingDeploymentStatus;
        }
    }

    private Set<String> getInstancesUids() {
        HashSet<String> instanceUids = new HashSet<String>();
        for (ProcessingUnitInstance instance : this.processingUnit) {
            instanceUids.add(instance.getUid());
        }
        return instanceUids;
    }
}

