/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.autoscaling;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.internal.pu.InternalProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.elastic.config.AutomaticCapacityScaleRuleConfig;
import org.openspaces.admin.pu.statistics.ProcessingUnitStatisticsId;
import org.openspaces.admin.zone.config.ZonesConfig;
import org.openspaces.grid.gsm.LogPerProcessingUnit;
import org.openspaces.grid.gsm.SingleThreadedPollingLog;
import org.openspaces.grid.gsm.autoscaling.AutoScalingSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.autoscaling.AutoScalingSlaPolicy;
import org.openspaces.grid.gsm.autoscaling.AutoScalingSlaUtils;
import org.openspaces.grid.gsm.autoscaling.exceptions.AutoScalingHighThresholdBreachedException;
import org.openspaces.grid.gsm.autoscaling.exceptions.AutoScalingLowThresholdBreachedException;
import org.openspaces.grid.gsm.autoscaling.exceptions.AutoScalingSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.autoscaling.exceptions.AutoScalingStatisticsFormatException;
import org.openspaces.grid.gsm.autoscaling.exceptions.ReachedMaximumCapacityAutoScalingException;
import org.openspaces.grid.gsm.autoscaling.exceptions.RulesConflictAutoScalingException;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;

public class DefaultAutoScalingSlaEnforcementEndpoint
implements AutoScalingSlaEnforcementEndpoint {
    private final Log logger;
    private InternalProcessingUnit pu;

    public DefaultAutoScalingSlaEnforcementEndpoint(ProcessingUnit pu) {
        this.pu = (InternalProcessingUnit)pu;
        this.logger = new LogPerProcessingUnit(new SingleThreadedPollingLog(LogFactory.getLog(this.getClass())), pu);
    }

    @Override
    public void enforceSla(AutoScalingSlaPolicy sla) throws AutoScalingSlaEnforcementInProgressException {
        if (sla == null) {
            throw new IllegalArgumentException("SLA cannot be null");
        }
        sla.validate();
        this.enforceSlaInternal(sla);
    }

    private void enforceSlaInternal(AutoScalingSlaPolicy sla) throws AutoScalingSlaEnforcementInProgressException {
        Map.Entry pair;
        Iterator correctedNewCapacity;
        Map<ProcessingUnitStatisticsId, Object> statistics = this.pu.getStatistics().getStatistics();
        HashMap<AutomaticCapacityScaleRuleConfig, Object> valuesBelowLowThresholdPerRule = new HashMap<AutomaticCapacityScaleRuleConfig, Object>();
        HashMap<AutomaticCapacityScaleRuleConfig, Object> valuesAboveHighThresholdPerRule = new HashMap<AutomaticCapacityScaleRuleConfig, Object>();
        if (this.logger.isTraceEnabled()) {
            int numberOfRules = sla.getRules().length;
            if (numberOfRules == 0) {
                this.logger.trace((Object)"No scaling rules defined");
            } else {
                this.logger.trace((Object)(numberOfRules + " scaling rules defined"));
            }
        }
        ZonesConfig zonesConfig = sla.getZonesConfig();
        for (AutomaticCapacityScaleRuleConfig rule : sla.getRules()) {
            ProcessingUnitStatisticsId statisticsId = rule.getStatistics();
            zonesConfig.validate();
            statisticsId.setAgentZones(zonesConfig);
            Object value = AutoScalingSlaUtils.getStatisticsValue(this.pu, statistics, statisticsId);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Checking value " + value + " against thresholds of scaling rule " + rule));
            }
            boolean belowLowThreshold = this.isBelowLowThreshold(rule, value);
            boolean aboveHighThreshold = this.isAboveHighThreshold(rule, value);
            if (belowLowThreshold) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Low threshold breached: " + value + " is less than " + rule.getLowThreshold() + ". Scaling rule: " + rule));
                }
                valuesBelowLowThresholdPerRule.put(rule, value);
            }
            if (aboveHighThreshold) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("High threshold breached: " + value + " is greater than " + rule.getHighThreshold() + ". Scaling rule: " + rule));
                }
                valuesAboveHighThresholdPerRule.put(rule, value);
            }
            if (!this.logger.isDebugEnabled() || belowLowThreshold || aboveHighThreshold) continue;
            this.logger.debug((Object)("Value is within thresholds for rule " + rule));
        }
        CapacityRequirements existingCapacity = sla.getCapacityRequirements();
        if (!valuesAboveHighThresholdPerRule.isEmpty() && !valuesBelowLowThresholdPerRule.isEmpty()) {
            throw new RulesConflictAutoScalingException(this.pu, valuesBelowLowThresholdPerRule, valuesAboveHighThresholdPerRule);
        }
        if (!valuesAboveHighThresholdPerRule.isEmpty()) {
            CapacityRequirements maxCapacity;
            CapacityRequirements minimunHighThresholdBreachedIncrease = this.getMinimumRuleChange(valuesAboveHighThresholdPerRule, true);
            CapacityRequirements newCapacity = existingCapacity.add(minimunHighThresholdBreachedIncrease);
            if (newCapacity.greaterThan(maxCapacity = sla.getMaxCapacity())) {
                correctedNewCapacity = newCapacity.min(maxCapacity);
                if (((CapacityRequirements)((Object)correctedNewCapacity)).equals(existingCapacity)) {
                    throw new ReachedMaximumCapacityAutoScalingException(this.pu, existingCapacity, newCapacity, maxCapacity, sla.getContainerMemoryCapacityInMB());
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Cannot increase capacity from " + existingCapacity + " to " + newCapacity + " since it breaches maximum of " + maxCapacity + "."));
                }
            }
            if (!newCapacity.greaterThan(existingCapacity)) {
                throw new IllegalStateException("Expected " + newCapacity + " to be bigger than " + existingCapacity + " due to the increase by " + minimunHighThresholdBreachedIncrease);
            }
            correctedNewCapacity = valuesAboveHighThresholdPerRule.entrySet().iterator();
            if (correctedNewCapacity.hasNext()) {
                pair = (Map.Entry)correctedNewCapacity.next();
                throw new AutoScalingHighThresholdBreachedException(this.pu, existingCapacity, newCapacity, sla.getContainerMemoryCapacityInMB(), (AutomaticCapacityScaleRuleConfig)pair.getKey(), AutoScalingSlaUtils.formatMetricValue(pair.getValue()));
            }
        } else if (!valuesBelowLowThresholdPerRule.isEmpty()) {
            Iterator iterator;
            CapacityRequirements minimunLowThresholdBreachedDecrease = this.getMinimumRuleChange(valuesBelowLowThresholdPerRule, false);
            Object newCapacity = existingCapacity.subtractOrZero(minimunLowThresholdBreachedDecrease);
            CapacityRequirements minCapacity = sla.getMinCapacity();
            if (minCapacity.greaterThan((CapacityRequirements)newCapacity)) {
                correctedNewCapacity = ((CapacityRequirements)newCapacity).max(minCapacity);
                if (existingCapacity.equals(newCapacity) && this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Cannot decrease capacity below minimum of " + minCapacity + ". Otherwise would have decreased capacity to " + newCapacity));
                }
                newCapacity = correctedNewCapacity;
            }
            if ((iterator = valuesBelowLowThresholdPerRule.entrySet().iterator()).hasNext()) {
                pair = iterator.next();
                throw new AutoScalingLowThresholdBreachedException(this.pu, existingCapacity, (CapacityRequirements)newCapacity, sla.getContainerMemoryCapacityInMB(), (AutomaticCapacityScaleRuleConfig)pair.getKey(), AutoScalingSlaUtils.formatMetricValue(pair.getValue()));
            }
        }
    }

    private CapacityRequirements getMinimumRuleChange(Map<AutomaticCapacityScaleRuleConfig, Object> valuesAboveHighThresholdPerRule, boolean increase) {
        Set<AutomaticCapacityScaleRuleConfig> automaticCapacityScaleRuleConfigs = valuesAboveHighThresholdPerRule.keySet();
        if (automaticCapacityScaleRuleConfigs.isEmpty()) {
            throw new IllegalStateException("automaticCapacityScaleRuleConfigs cannot be empty");
        }
        Iterator<AutomaticCapacityScaleRuleConfig> iterator = automaticCapacityScaleRuleConfigs.iterator();
        CapacityRequirements minimunChange = null;
        while (iterator.hasNext()) {
            CapacityRequirements change;
            AutomaticCapacityScaleRuleConfig ruleConfig = iterator.next();
            if (increase) {
                change = ruleConfig.getHighThresholdBreachedIncrease().toCapacityRequirements();
                if (change.equalsZero()) {
                    throw new IllegalStateException("highThresholdIncrease cannot be zero in scale rule " + ruleConfig);
                }
            } else {
                change = ruleConfig.getLowThresholdBreachedDecrease().toCapacityRequirements();
                if (change.equalsZero()) {
                    throw new IllegalStateException("lowThresholdIncrease cannot be zero in scale rule " + ruleConfig);
                }
            }
            if (minimunChange == null) {
                minimunChange = change;
                continue;
            }
            minimunChange = minimunChange.min(change);
        }
        if (minimunChange.equalsZero()) {
            throw new IllegalStateException("minimumCapacityHighThresholdIncreaseRequirements cannot be zero");
        }
        return minimunChange;
    }

    public boolean isBelowLowThreshold(AutomaticCapacityScaleRuleConfig rule, Object value) throws AutoScalingSlaEnforcementInProgressException {
        try {
            return !rule.getLowThresholdBreachedDecrease().toCapacityRequirements().equalsZero() && AutoScalingSlaUtils.compare(rule.getLowThreshold(), value) > 0;
        }
        catch (NumberFormatException e) {
            throw new AutoScalingStatisticsFormatException(this.pu, value, rule.getLowThreshold(), e);
        }
    }

    public boolean isAboveHighThreshold(AutomaticCapacityScaleRuleConfig rule, Object value) throws AutoScalingSlaEnforcementInProgressException {
        try {
            return !rule.getHighThresholdBreachedIncrease().toCapacityRequirements().equalsZero() && AutoScalingSlaUtils.compare(rule.getHighThreshold(), value) < 0;
        }
        catch (NumberFormatException e) {
            throw new AutoScalingStatisticsFormatException(this.pu, value, rule.getHighThreshold(), e);
        }
    }
}

