/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.autoscaling.exceptions;

import java.util.Set;
import org.openspaces.admin.internal.pu.elastic.events.DefaultElasticAutoScalingFailureEvent;
import org.openspaces.admin.internal.pu.elastic.events.InternalElasticProcessingUnitFailureEvent;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.grid.gsm.autoscaling.exceptions.AutoScalingSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;
import org.openspaces.grid.gsm.capacity.CapacityRequirementsPerZones;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementFailure;

public class AutoScalingConfigConflictException
extends AutoScalingSlaEnforcementInProgressException
implements SlaEnforcementFailure {
    private static final long serialVersionUID = 1L;
    private CapacityRequirements minimumCapacityRequirements;
    private CapacityRequirements maximumCapacityRequirements;
    private Set<String> zones;

    public AutoScalingConfigConflictException(ProcessingUnit pu, CapacityRequirements minimum, CapacityRequirements maximum, Set<String> zones, CapacityRequirementsPerZones lastEnforcedCapacityPerZones, CapacityRequirementsPerZones newCapacityRequirementsPerZones) {
        super(pu, AutoScalingConfigConflictException.message(minimum, maximum, zones, lastEnforcedCapacityPerZones, newCapacityRequirementsPerZones));
        this.minimumCapacityRequirements = minimum;
        this.maximumCapacityRequirements = maximum;
        this.zones = zones;
    }

    private static String message(CapacityRequirements minimum, CapacityRequirements maximum, Set<String> zones, CapacityRequirementsPerZones lastEnforcedCapacityPerZones, CapacityRequirementsPerZones newCapacityRequirementsPerZones) {
        return "Configuration Conflict. autoscaling will not continue. minimumCapacityRequirements= " + minimum + " is in conflict with maximumCapacityRequirements=" + maximum + " for zones " + zones + " : lastEnforcedCapacityPerZones=" + lastEnforcedCapacityPerZones + " , newCapacityRequirementsPerZones=" + newCapacityRequirementsPerZones;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.maximumCapacityRequirements == null ? 0 : this.maximumCapacityRequirements.hashCode());
        result = 31 * result + (this.minimumCapacityRequirements == null ? 0 : this.minimumCapacityRequirements.hashCode());
        result = 31 * result + (this.zones == null ? 0 : this.zones.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutoScalingConfigConflictException other = (AutoScalingConfigConflictException)obj;
        if (this.maximumCapacityRequirements == null ? other.maximumCapacityRequirements != null : !this.maximumCapacityRequirements.equals(other.maximumCapacityRequirements)) {
            return false;
        }
        if (this.minimumCapacityRequirements == null ? other.minimumCapacityRequirements != null : !this.minimumCapacityRequirements.equals(other.minimumCapacityRequirements)) {
            return false;
        }
        return !(this.zones == null ? other.zones != null : !this.zones.equals(other.zones));
    }

    @Override
    public InternalElasticProcessingUnitFailureEvent toEvent() {
        DefaultElasticAutoScalingFailureEvent event = new DefaultElasticAutoScalingFailureEvent();
        event.setFailureDescription(this.getMessage());
        event.setProcessingUnitName(this.getProcessingUnitName());
        return event;
    }
}

