/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.autoscaling.exceptions;

import org.openspaces.admin.internal.pu.elastic.events.DefaultElasticAutoScalingFailureEvent;
import org.openspaces.admin.internal.pu.elastic.events.InternalElasticProcessingUnitFailureEvent;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.grid.gsm.autoscaling.exceptions.AutoScalingStatisticsException;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementFailure;

public class AutoScalingInstanceStatisticsException
extends AutoScalingStatisticsException
implements SlaEnforcementFailure {
    private static final long serialVersionUID = 1L;

    public AutoScalingInstanceStatisticsException(ProcessingUnitInstance instance, String metric) {
        super(instance.getProcessingUnit(), AutoScalingInstanceStatisticsException.message(metric, instance));
    }

    private static String message(String metric, ProcessingUnitInstance instance) {
        return "Cannot monitor " + instance.getProcessingUnitInstanceName() + " for " + metric + ". If this alert has resolved quickly, consider increasing the scale-out cooldown period.";
    }

    @Override
    public InternalElasticProcessingUnitFailureEvent toEvent() {
        DefaultElasticAutoScalingFailureEvent event = new DefaultElasticAutoScalingFailureEvent();
        event.setFailureDescription(this.getMessage());
        event.setProcessingUnitName(this.getProcessingUnitName());
        return event;
    }
}

