/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.autoscaling.exceptions;

import org.openspaces.admin.internal.pu.elastic.events.InternalElasticProcessingUnitDecisionEvent;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitType;
import org.openspaces.admin.pu.elastic.config.AutomaticCapacityScaleRuleConfig;
import org.openspaces.admin.pu.elastic.config.CapacityRequirementsConfig;
import org.openspaces.admin.pu.elastic.events.ElasticStatefulProcessingUnitPlannedCapacityChangedEvent;
import org.openspaces.admin.pu.elastic.events.ElasticStatelessProcessingUnitPlannedNumberOfInstancesChangedEvent;
import org.openspaces.grid.gsm.autoscaling.exceptions.AutoScalingSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementDecision;

public abstract class AutoScalingThresholdBreachedException
extends AutoScalingSlaEnforcementInProgressException
implements SlaEnforcementDecision {
    private static final long serialVersionUID = 1L;
    private final CapacityRequirements newPlan;
    private final CapacityRequirements actual;
    private final ProcessingUnit pu;
    private final long containerCapacityInMB;
    private CapacityRequirements oldPlan;
    private AutomaticCapacityScaleRuleConfig rule;
    private boolean highThresholdBreached;
    private String metricValue;

    public AutoScalingThresholdBreachedException(String message, ProcessingUnit pu, CapacityRequirements actual, CapacityRequirements newPlan, long containerCapacityInMB, AutomaticCapacityScaleRuleConfig rule, boolean highThresholdBreached, String metricValue) {
        super(pu, message);
        this.actual = actual;
        this.newPlan = newPlan;
        this.pu = pu;
        this.containerCapacityInMB = containerCapacityInMB;
        this.rule = rule;
        this.highThresholdBreached = highThresholdBreached;
        this.metricValue = metricValue;
    }

    public CapacityRequirements getNewCapacity() {
        return this.newPlan;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.actual == null ? 0 : this.actual.hashCode());
        result = 31 * result + (int)(this.containerCapacityInMB ^ this.containerCapacityInMB >>> 32);
        result = 31 * result + (this.newPlan == null ? 0 : this.newPlan.hashCode());
        result = 31 * result + (this.oldPlan == null ? 0 : this.oldPlan.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutoScalingThresholdBreachedException other = (AutoScalingThresholdBreachedException)obj;
        if (this.actual == null ? other.actual != null : !this.actual.equals(other.actual)) {
            return false;
        }
        if (this.containerCapacityInMB != other.containerCapacityInMB) {
            return false;
        }
        if (this.newPlan == null ? other.newPlan != null : !this.newPlan.equals(other.newPlan)) {
            return false;
        }
        return !(this.oldPlan == null ? other.oldPlan != null : !this.oldPlan.equals(other.oldPlan));
    }

    public void setOldPlan(CapacityRequirements oldPlan) {
        this.oldPlan = oldPlan;
    }

    @Override
    public InternalElasticProcessingUnitDecisionEvent toEvent() {
        CapacityRequirementsConfig actualConfig = new CapacityRequirementsConfig(this.actual);
        CapacityRequirementsConfig newPlanConfig = new CapacityRequirementsConfig(this.newPlan);
        CapacityRequirementsConfig oldPlanConfig = new CapacityRequirementsConfig(this.oldPlan);
        if (this.pu.getType().equals((Object)ProcessingUnitType.STATEFUL)) {
            return new ElasticStatefulProcessingUnitPlannedCapacityChangedEvent(actualConfig, newPlanConfig);
        }
        int actualNumberOfInstances = (int)Math.ceil((double)actualConfig.getMemoryCapacityInMB() * 1.0 / (double)this.containerCapacityInMB);
        int newPlannedNumberOfInstances = (int)Math.ceil((double)newPlanConfig.getMemoryCapacityInMB() * 1.0 / (double)this.containerCapacityInMB);
        int oldPlanmedNumberOfInstances = (int)Math.ceil((double)oldPlanConfig.getMemoryCapacityInMB() * 1.0 / (double)this.containerCapacityInMB);
        return new ElasticStatelessProcessingUnitPlannedNumberOfInstancesChangedEvent(actualNumberOfInstances, oldPlanmedNumberOfInstances, newPlannedNumberOfInstances, this.rule, this.highThresholdBreached, this.metricValue);
    }
}

