/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.autoscaling.exceptions;

import org.openspaces.admin.internal.pu.elastic.events.DefaultElasticAutoScalingFailureEvent;
import org.openspaces.admin.internal.pu.elastic.events.InternalElasticProcessingUnitFailureEvent;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitType;
import org.openspaces.admin.pu.elastic.config.CapacityRequirementsConfig;
import org.openspaces.admin.pu.elastic.events.ElasticStatelessReachedMaximumNumberOfInstancesEvent;
import org.openspaces.grid.gsm.autoscaling.exceptions.AutoScalingSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementFailure;

public class ReachedMaximumCapacityAutoScalingException
extends AutoScalingSlaEnforcementInProgressException
implements SlaEnforcementFailure {
    private static final long serialVersionUID = 1L;
    private final CapacityRequirements existingCapacity;
    private final CapacityRequirements requestedCapacity;
    private final CapacityRequirements maxCapacity;
    private final ProcessingUnit pu;
    private final long containerCapacityInMB;

    public ReachedMaximumCapacityAutoScalingException(ProcessingUnit pu, CapacityRequirements existingCapacity, CapacityRequirements newCapacity, CapacityRequirements maxCapacity, long containerCapacityInMB) {
        super(pu, "Cannot increase capacity from " + existingCapacity + " to " + newCapacity + " since it breaches maximum capacity " + maxCapacity);
        this.existingCapacity = existingCapacity;
        this.requestedCapacity = newCapacity;
        this.maxCapacity = maxCapacity;
        this.pu = pu;
        this.containerCapacityInMB = containerCapacityInMB;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.existingCapacity == null ? 0 : this.existingCapacity.hashCode());
        result = 31 * result + (this.maxCapacity == null ? 0 : this.maxCapacity.hashCode());
        result = 31 * result + (this.requestedCapacity == null ? 0 : this.requestedCapacity.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReachedMaximumCapacityAutoScalingException other = (ReachedMaximumCapacityAutoScalingException)obj;
        if (this.existingCapacity == null ? other.existingCapacity != null : !this.existingCapacity.equals(other.existingCapacity)) {
            return false;
        }
        if (this.maxCapacity == null ? other.maxCapacity != null : !this.maxCapacity.equals(other.maxCapacity)) {
            return false;
        }
        return !(this.requestedCapacity == null ? other.requestedCapacity != null : !this.requestedCapacity.equals(other.requestedCapacity));
    }

    @Override
    public InternalElasticProcessingUnitFailureEvent toEvent() {
        if (this.pu.getType().equals((Object)ProcessingUnitType.STATEFUL)) {
            DefaultElasticAutoScalingFailureEvent event = new DefaultElasticAutoScalingFailureEvent();
            event.setFailureDescription(this.getMessage());
            event.setProcessingUnitName(this.getProcessingUnitName());
            return event;
        }
        int existingNumberOfInstances = (int)Math.ceil((double)new CapacityRequirementsConfig(this.existingCapacity).getMemoryCapacityInMB() * 1.0 / (double)this.containerCapacityInMB);
        int requestedNumberOfInstances = (int)Math.ceil((double)new CapacityRequirementsConfig(this.requestedCapacity).getMemoryCapacityInMB() * 1.0 / (double)this.containerCapacityInMB);
        int maximumNumberOfInstances = (int)Math.ceil((double)new CapacityRequirementsConfig(this.maxCapacity).getMemoryCapacityInMB() * 1.0 / (double)this.containerCapacityInMB);
        return new ElasticStatelessReachedMaximumNumberOfInstancesEvent(this.pu, existingNumberOfInstances, requestedNumberOfInstances, maximumNumberOfInstances);
    }
}

