/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.autoscaling.exceptions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.openspaces.admin.internal.pu.InternalProcessingUnit;
import org.openspaces.admin.internal.pu.elastic.events.DefaultElasticAutoScalingFailureEvent;
import org.openspaces.admin.internal.pu.elastic.events.InternalElasticProcessingUnitFailureEvent;
import org.openspaces.admin.pu.elastic.config.AutomaticCapacityScaleRuleConfig;
import org.openspaces.grid.gsm.autoscaling.exceptions.AutoScalingSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementFailure;

public class RulesConflictAutoScalingException
extends AutoScalingSlaEnforcementInProgressException
implements SlaEnforcementFailure {
    private static final long serialVersionUID = 1L;
    private final Set<AutomaticCapacityScaleRuleConfig> valuesBelowLowThresholdPerRule;
    private final Set<AutomaticCapacityScaleRuleConfig> valuesAboveHighThresholdPerRule;

    public RulesConflictAutoScalingException(InternalProcessingUnit pu, Map<AutomaticCapacityScaleRuleConfig, Object> valuesBelowLowThresholdPerRule, Map<AutomaticCapacityScaleRuleConfig, Object> valuesAboveHighThresholdPerRule) {
        super(pu, RulesConflictAutoScalingException.message(valuesBelowLowThresholdPerRule, valuesAboveHighThresholdPerRule));
        this.valuesBelowLowThresholdPerRule = valuesBelowLowThresholdPerRule.keySet();
        this.valuesAboveHighThresholdPerRule = valuesAboveHighThresholdPerRule.keySet();
    }

    private static String message(Map<AutomaticCapacityScaleRuleConfig, Object> valuesBelowLowThresholdPerRule, Map<AutomaticCapacityScaleRuleConfig, Object> valuesAboveHighThresholdPerRule) {
        Object value;
        AutomaticCapacityScaleRuleConfig rule;
        ArrayList<String> messages = new ArrayList<String>(valuesAboveHighThresholdPerRule.size() + valuesBelowLowThresholdPerRule.size());
        for (Map.Entry<AutomaticCapacityScaleRuleConfig, Object> pair : valuesAboveHighThresholdPerRule.entrySet()) {
            rule = pair.getKey();
            value = pair.getValue();
            messages.add(rule.getStatistics().getMetric() + " value (" + value + ") is above high threshold " + rule.getHighThreshold());
        }
        for (Map.Entry<AutomaticCapacityScaleRuleConfig, Object> pair : valuesBelowLowThresholdPerRule.entrySet()) {
            rule = pair.getKey();
            value = pair.getValue();
            messages.add(rule.getStatistics().getMetric() + " value (" + value + ") is below low threshold " + rule.getHighThreshold());
        }
        String message = Arrays.toString(messages.toArray(new String[messages.size()]));
        return "Rule conflict, taking no automatic action. " + message;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.valuesAboveHighThresholdPerRule == null ? 0 : this.valuesAboveHighThresholdPerRule.hashCode());
        result = 31 * result + (this.valuesBelowLowThresholdPerRule == null ? 0 : this.valuesBelowLowThresholdPerRule.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RulesConflictAutoScalingException other = (RulesConflictAutoScalingException)obj;
        if (this.valuesAboveHighThresholdPerRule == null ? other.valuesAboveHighThresholdPerRule != null : !this.valuesAboveHighThresholdPerRule.equals(other.valuesAboveHighThresholdPerRule)) {
            return false;
        }
        return !(this.valuesBelowLowThresholdPerRule == null ? other.valuesBelowLowThresholdPerRule != null : !this.valuesBelowLowThresholdPerRule.equals(other.valuesBelowLowThresholdPerRule));
    }

    @Override
    public InternalElasticProcessingUnitFailureEvent toEvent() {
        DefaultElasticAutoScalingFailureEvent event = new DefaultElasticAutoScalingFailureEvent();
        event.setFailureDescription(this.getMessage());
        event.setProcessingUnitName(this.getProcessingUnitName());
        return event;
    }
}

