/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.capacity;

import org.openspaces.grid.gsm.capacity.CapacityRequirement;
import org.openspaces.grid.gsm.capacity.CapacityRequirementType;

public abstract class AbstractCapacityRequirement
implements CapacityRequirement {
    protected final Long value;

    public AbstractCapacityRequirement() {
        this(0L);
    }

    public AbstractCapacityRequirement(long value) {
        this.value = value;
    }

    @Override
    public int compareTo(CapacityRequirement otherCapacityRequirement) {
        AbstractCapacityRequirement other = this.cast(otherCapacityRequirement);
        return this.value.compareTo(other.value);
    }

    @Override
    public boolean equalsZero() {
        return this.value == 0L;
    }

    @Override
    public CapacityRequirement multiply(int i) {
        return this.getType().newInstance(this.value * (long)i);
    }

    @Override
    public CapacityRequirement divide(int i) {
        return this.getType().newInstance(this.value / (long)i);
    }

    @Override
    public CapacityRequirement subtract(CapacityRequirement otherCapacityRequirement) {
        AbstractCapacityRequirement other = this.cast(otherCapacityRequirement);
        if (this.value < other.value) {
            throw new IllegalArgumentException("other size is " + other.value + " which is bigger than " + this.value);
        }
        return this.getType().newInstance(this.value - other.value);
    }

    @Override
    public CapacityRequirement subtractOrZero(CapacityRequirement otherCapacityRequirement) {
        AbstractCapacityRequirement other = this.cast(otherCapacityRequirement);
        if (this.value < other.value) {
            return this.getType().newInstance(0L);
        }
        return this.getType().newInstance(this.value - other.value);
    }

    @Override
    public CapacityRequirement add(CapacityRequirement otherCapacityRequirement) {
        AbstractCapacityRequirement other = this.cast(otherCapacityRequirement);
        return this.getType().newInstance(this.value + other.value);
    }

    @Override
    public CapacityRequirement min(CapacityRequirement otherCapacityRequirement) {
        if (otherCapacityRequirement.compareTo(this) < 0) {
            return otherCapacityRequirement;
        }
        return this;
    }

    @Override
    public CapacityRequirement max(CapacityRequirement otherCapacityRequirement) {
        if (otherCapacityRequirement.compareTo(this) > 0) {
            return otherCapacityRequirement;
        }
        return this;
    }

    @Override
    public double divide(CapacityRequirement otherCapacityRequirement) {
        AbstractCapacityRequirement other = this.cast(otherCapacityRequirement);
        return (double)this.value.longValue() / (double)other.value.longValue();
    }

    public CapacityRequirementType<? extends AbstractCapacityRequirement> getType() {
        return new CapacityRequirementType(this.getClass());
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof AbstractCapacityRequirement && ((AbstractCapacityRequirement)other).getType().equals(this.getType()) && ((AbstractCapacityRequirement)other).value.equals(this.value);
    }

    @Override
    public abstract String toString();

    private AbstractCapacityRequirement cast(Object o) {
        if (!this.getType().equals(((CapacityRequirement)o).getType())) {
            throw new IllegalArgumentException(((CapacityRequirement)o).getType() + " is not comparable with " + this.getType());
        }
        return (AbstractCapacityRequirement)o;
    }
}

