/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.capacity;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openspaces.grid.gsm.capacity.CapacityRequirement;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;

abstract class AbstractCapacityRequirementsPerKey {
    private final Map<String, CapacityRequirements> capacityPerKey = new LinkedHashMap<String, CapacityRequirements>();
    private CapacityRequirements totalCapacity = new CapacityRequirements(new CapacityRequirement[0]);

    protected AbstractCapacityRequirementsPerKey() {
    }

    public CapacityRequirements getTotalAllocatedCapacity() {
        return this.totalCapacity;
    }

    public boolean equalsZero() {
        return this.capacityPerKey.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.capacityPerKey == null ? 0 : this.capacityPerKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractCapacityRequirementsPerKey other = (AbstractCapacityRequirementsPerKey)obj;
        return !(this.capacityPerKey == null ? other.capacityPerKey != null : !this.capacityPerKey.equals(other.capacityPerKey));
    }

    protected Collection<String> getKeys() {
        return this.capacityPerKey.keySet();
    }

    public abstract String toString();

    public abstract String toDetailedString();

    protected AbstractCapacityRequirementsPerKey add(AbstractCapacityRequirementsPerKey other) {
        if (other.equalsZero()) {
            return this;
        }
        AbstractCapacityRequirementsPerKey sum = this.newZeroInstance();
        sum.addAllInternal(this);
        sum.addAllInternal(other);
        return sum;
    }

    protected AbstractCapacityRequirementsPerKey subtract(AbstractCapacityRequirementsPerKey other) {
        AbstractCapacityRequirementsPerKey diff = this.newZeroInstance();
        diff.addAllInternal(this);
        diff.subtractAllInternal(other);
        return diff;
    }

    protected abstract AbstractCapacityRequirementsPerKey newZeroInstance();

    protected AbstractCapacityRequirementsPerKey set(String key, CapacityRequirements capacity) {
        AbstractCapacityRequirementsPerKey sum = this.newZeroInstance();
        sum.addAllInternal(this);
        sum.setInternal(key, capacity);
        return sum;
    }

    protected AbstractCapacityRequirementsPerKey add(String key, CapacityRequirements capacity) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("key cannot be empty");
        }
        AbstractCapacityRequirementsPerKey sum = this.newZeroInstance();
        sum.addAllInternal(this);
        sum.addInternal(key, capacity);
        return sum;
    }

    protected AbstractCapacityRequirementsPerKey subtract(String key, CapacityRequirements capacity) {
        AbstractCapacityRequirementsPerKey remaining = this.newZeroInstance();
        remaining.addAllInternal(this);
        remaining.subtractInternal(key, capacity);
        return remaining;
    }

    protected AbstractCapacityRequirementsPerKey subtractKey(String key) {
        return this.subtract(key, this.getKeyCapacity(key));
    }

    protected AbstractCapacityRequirementsPerKey subtractOrZero(String key, CapacityRequirements capacity) {
        AbstractCapacityRequirementsPerKey remaining = this.newZeroInstance();
        remaining.addAllInternal(this);
        remaining.subtractOrZeroInternal(key, capacity);
        return remaining;
    }

    protected CapacityRequirements getKeyCapacity(String key) {
        if (!this.capacityPerKey.containsKey(key)) {
            throw new IllegalArgumentException(key);
        }
        return this.capacityPerKey.get(key);
    }

    protected CapacityRequirements getKeyCapacityOrZero(String key) {
        if (this.capacityPerKey.containsKey(key)) {
            return this.capacityPerKey.get(key);
        }
        return new CapacityRequirements(new CapacityRequirement[0]);
    }

    private void addAllInternal(AbstractCapacityRequirementsPerKey clusterCapacityRequirements) {
        for (String key : clusterCapacityRequirements.capacityPerKey.keySet()) {
            CapacityRequirements capacity = clusterCapacityRequirements.capacityPerKey.get(key);
            this.addInternal(key, capacity);
        }
    }

    private void subtractAllInternal(AbstractCapacityRequirementsPerKey aggregatedCapacity) {
        for (String key : aggregatedCapacity.capacityPerKey.keySet()) {
            CapacityRequirements capacity = aggregatedCapacity.capacityPerKey.get(key);
            this.subtractInternal(key, capacity);
        }
    }

    private void setInternal(String key, CapacityRequirements newCapacity) {
        CapacityRequirements oldCapacity = this.capacityPerKey.get(key);
        if (newCapacity.equalsZero()) {
            this.capacityPerKey.remove(key);
        } else {
            this.capacityPerKey.put(key, newCapacity);
        }
        if (oldCapacity != null) {
            this.totalCapacity = this.totalCapacity.subtract(oldCapacity);
        }
        this.totalCapacity = this.totalCapacity.add(newCapacity);
    }

    private void addInternal(String key, CapacityRequirements capacityToAdd) {
        this.validateAllocation(capacityToAdd);
        CapacityRequirements sumCapacity = capacityToAdd;
        if (this.capacityPerKey.containsKey(key)) {
            sumCapacity = sumCapacity.add(this.capacityPerKey.get(key));
        }
        this.capacityPerKey.put(key, sumCapacity);
        this.totalCapacity = this.totalCapacity.add(capacityToAdd);
    }

    private void subtractInternal(String key, CapacityRequirements capacity) {
        this.validateAllocation(capacity);
        if (!this.capacityPerKey.containsKey(key)) {
            throw new IllegalArgumentException("Agent UID " + key + " no found");
        }
        CapacityRequirements newAllocation = this.capacityPerKey.get(key).subtract(capacity);
        this.updateKeyCapacity(key, newAllocation);
        this.totalCapacity = this.totalCapacity.subtract(capacity);
    }

    private void subtractOrZeroInternal(String key, CapacityRequirements capacity) {
        this.validateAllocation(capacity);
        if (!this.capacityPerKey.containsKey(key)) {
            throw new IllegalArgumentException("Agent UID " + key + " no found");
        }
        CapacityRequirements newAllocation = this.capacityPerKey.get(key).subtractOrZero(capacity);
        this.updateKeyCapacity(key, newAllocation);
        this.totalCapacity = this.totalCapacity.subtract(capacity);
    }

    private void updateKeyCapacity(String key, CapacityRequirements newAllocation) {
        if (newAllocation.equalsZero()) {
            this.capacityPerKey.remove(key);
        } else {
            this.capacityPerKey.put(key, newAllocation);
        }
    }

    private void validateAllocation(CapacityRequirements allocation) {
        if (allocation.equalsZero()) {
            throw new IllegalArgumentException(allocation + " equals zero");
        }
    }
}

