/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.capacity;

import com.gigaspaces.internal.utils.CollectionUtils;
import com.gigaspaces.internal.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openspaces.grid.gsm.capacity.CapacityRequirement;
import org.openspaces.grid.gsm.capacity.CapacityRequirementType;
import org.openspaces.grid.gsm.capacity.MemoryCapacityRequirement;

public class CapacityRequirements {
    private final CapacityRequirement[] requirements;

    public CapacityRequirements(CapacityRequirement ... requirements) {
        ArrayList<CapacityRequirement> newRequirements = new ArrayList<CapacityRequirement>();
        for (CapacityRequirement capacityRequirement : requirements) {
            if (capacityRequirement.equalsZero()) continue;
            newRequirements.add(capacityRequirement);
        }
        this.requirements = newRequirements.toArray(new CapacityRequirement[newRequirements.size()]);
    }

    public CapacityRequirement[] getRequirements() {
        return this.requirements;
    }

    public <T extends CapacityRequirement> T getRequirement(CapacityRequirementType<T> type) {
        CapacityRequirement requirement = null;
        for (CapacityRequirement r : this.requirements) {
            if (!r.getType().equals(type)) continue;
            requirement = r;
            break;
        }
        if (requirement == null) {
            requirement = (CapacityRequirement)type.newInstance();
        }
        return (T)requirement;
    }

    public CapacityRequirements multiply(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("i must not be negative");
        }
        CapacityRequirement[] newRequirements = new CapacityRequirement[this.requirements.length];
        for (int j = 0; j < newRequirements.length; ++j) {
            newRequirements[j] = this.requirements[j].multiply(i);
        }
        return new CapacityRequirements(newRequirements);
    }

    public CapacityRequirements divide(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("i must not be negative");
        }
        CapacityRequirement[] newCapacity = new CapacityRequirement[this.requirements.length];
        for (int j = 0; j < newCapacity.length; ++j) {
            newCapacity[j] = this.requirements[j].divide(i);
        }
        return new CapacityRequirements(newCapacity);
    }

    public CapacityRequirements subtract(CapacityRequirements otherRequirements) {
        if (otherRequirements == null) {
            throw new IllegalArgumentException("otherRequirements cannot be null");
        }
        ArrayList<CapacityRequirement> newRequirements = new ArrayList<CapacityRequirement>();
        if (!this.greaterOrEquals(otherRequirements)) {
            throw new IllegalArgumentException("Cannot subtract " + otherRequirements + " from " + this + " since it would result in a negative capacity");
        }
        for (CapacityRequirement capacity : this.requirements) {
            CapacityRequirement otherCapacity = otherRequirements.getRequirement(capacity.getType());
            CapacityRequirement newCapacity = capacity.subtract(otherCapacity);
            if (newCapacity.equalsZero()) continue;
            newRequirements.add(newCapacity);
        }
        return new CapacityRequirements(newRequirements.toArray(new CapacityRequirement[newRequirements.size()]));
    }

    public CapacityRequirements subtract(CapacityRequirement otherRequirement) {
        return this.subtract(new CapacityRequirements(otherRequirement));
    }

    public CapacityRequirements subtractOrZero(CapacityRequirement otherRequirement) {
        return this.subtractOrZero(new CapacityRequirements(otherRequirement));
    }

    public CapacityRequirements subtractOrZero(CapacityRequirements otherRequirements) {
        ArrayList<CapacityRequirement> newRequirements = new ArrayList<CapacityRequirement>();
        for (CapacityRequirement capacity : this.requirements) {
            CapacityRequirement otherCapacity = otherRequirements.getRequirement(capacity.getType());
            CapacityRequirement newCapacity = capacity.subtractOrZero(otherCapacity);
            if (newCapacity.equalsZero()) continue;
            newRequirements.add(newCapacity);
        }
        return new CapacityRequirements(newRequirements.toArray(new CapacityRequirement[newRequirements.size()]));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.requirements);
        return result;
    }

    public boolean equals(Object otherRequirements) {
        boolean eq = true;
        if (!(otherRequirements instanceof CapacityRequirements)) {
            eq = false;
        } else {
            for (CapacityRequirement otherCapacity : ((CapacityRequirements)otherRequirements).requirements) {
                CapacityRequirement capacity = this.getRequirement(otherCapacity.getType());
                if (capacity.compareTo(otherCapacity) == 0) continue;
                eq = false;
                break;
            }
            for (CapacityRequirement capacity : this.requirements) {
                CapacityRequirement otherCapacity = ((CapacityRequirements)otherRequirements).getRequirement(capacity.getType());
                if (capacity.compareTo(otherCapacity) == 0) continue;
                eq = false;
                break;
            }
        }
        return eq;
    }

    public boolean equalsZero() {
        boolean eq = true;
        for (CapacityRequirement capacity : this.requirements) {
            if (capacity.equalsZero()) continue;
            eq = false;
            break;
        }
        return eq;
    }

    public CapacityRequirements add(CapacityRequirements otherRequirements) {
        ArrayList<CapacityRequirement> newRequirements = new ArrayList<CapacityRequirement>();
        for (CapacityRequirement otherCapacity : otherRequirements.requirements) {
            if (otherCapacity.equalsZero()) {
                throw new IllegalStateException(otherCapacity + " has a zero capacity requirement");
            }
            CapacityRequirement capacity = this.getRequirement(otherCapacity.getType());
            if (!capacity.equalsZero()) continue;
            newRequirements.add(otherCapacity);
        }
        for (CapacityRequirement capacity : this.requirements) {
            CapacityRequirement otherCapacity = otherRequirements.getRequirement(capacity.getType());
            CapacityRequirement newCapacity = capacity.add(otherCapacity);
            if (newCapacity.equalsZero()) continue;
            newRequirements.add(newCapacity);
        }
        return new CapacityRequirements(newRequirements.toArray(new CapacityRequirement[newRequirements.size()]));
    }

    public CapacityRequirements min(CapacityRequirements otherRequirements) {
        ArrayList<CapacityRequirement> newRequirements = new ArrayList<CapacityRequirement>();
        for (CapacityRequirement capacity : this.requirements) {
            CapacityRequirement otherCapacity = otherRequirements.getRequirement(capacity.getType());
            if (capacity.compareTo(otherCapacity) > 0) {
                newRequirements.add(otherCapacity);
                continue;
            }
            newRequirements.add(capacity);
        }
        return new CapacityRequirements(newRequirements.toArray(new CapacityRequirement[newRequirements.size()]));
    }

    public CapacityRequirements max(CapacityRequirements otherCapacityRequirements) {
        ArrayList<CapacityRequirement> newRequirements = new ArrayList<CapacityRequirement>();
        for (CapacityRequirement otherCapacityRequirement : otherCapacityRequirements.getRequirements()) {
            CapacityRequirement requirement = this.getRequirement(otherCapacityRequirement.getType());
            newRequirements.add(requirement.max(otherCapacityRequirement));
        }
        for (CapacityRequirement requirement : this.getRequirements()) {
            if (!otherCapacityRequirements.getRequirement(requirement.getType()).equalsZero()) continue;
            newRequirements.add(requirement);
        }
        return new CapacityRequirements(newRequirements.toArray(new CapacityRequirement[newRequirements.size()]));
    }

    public CapacityRequirements max(CapacityRequirement capacityRequirement) {
        if (this.getRequirement(capacityRequirement.getType()).compareTo(capacityRequirement) > 0) {
            return this.set(capacityRequirement);
        }
        return this;
    }

    public CapacityRequirements set(CapacityRequirement capacityRequirement) {
        ArrayList<CapacityRequirement> newRequirements = new ArrayList<CapacityRequirement>();
        newRequirements.add(capacityRequirement);
        for (CapacityRequirement capacity : this.requirements) {
            if (capacityRequirement.getType().equals(capacity.getType())) continue;
            newRequirements.add(capacity);
        }
        return new CapacityRequirements(newRequirements.toArray(new CapacityRequirement[newRequirements.size()]));
    }

    public int divideExactly(CapacityRequirements otherCapacityRequirements) {
        double factor;
        CapacityRequirement thisRequirement;
        CapacityRequirement otherRequirement;
        int exactFactor = -1;
        if (!this.equalsZero() && !otherCapacityRequirements.equalsZero() && !(otherRequirement = otherCapacityRequirements.getRequirement((thisRequirement = this.requirements[0]).getType())).equalsZero() && (double)Math.round(factor = thisRequirement.divide(otherRequirement)) == factor && otherCapacityRequirements.equals(this.divide((int)factor))) {
            exactFactor = (int)factor;
        }
        return exactFactor;
    }

    public boolean greaterOrEquals(CapacityRequirements otherRequirements) {
        boolean greaterOrEquals = true;
        for (CapacityRequirement otherCapacity : otherRequirements.requirements) {
            CapacityRequirement capacity = this.getRequirement(otherCapacity.getType());
            if (capacity.compareTo(otherCapacity) >= 0) continue;
            greaterOrEquals = false;
            break;
        }
        return greaterOrEquals;
    }

    public boolean greaterThan(CapacityRequirements otherRequirements) {
        return this.greaterOrEquals(otherRequirements) && !this.equals(otherRequirements);
    }

    public String toString() {
        List sortedRequirements = CollectionUtils.toList((Object[])this.requirements);
        Collections.sort(sortedRequirements, new Comparator<CapacityRequirement>(){

            @Override
            public int compare(CapacityRequirement o1, CapacityRequirement o2) {
                String s1 = o1.getType().toString();
                String s2 = o2.getType().toString();
                return s1.compareTo(s2);
            }
        });
        if (sortedRequirements.isEmpty()) {
            sortedRequirements.add(new MemoryCapacityRequirement());
        }
        return StringUtils.arrayToCommaDelimitedString((Object[])sortedRequirements.toArray(new CapacityRequirement[sortedRequirements.size()]));
    }

    public CapacityRequirements add(CapacityRequirement capacityToAllocateOnMachine) {
        return this.add(new CapacityRequirements(capacityToAllocateOnMachine));
    }
}

