/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.capacity;

import java.util.HashSet;
import java.util.Set;
import org.openspaces.admin.internal.zone.config.ZonesConfigUtils;
import org.openspaces.admin.zone.config.ZonesConfig;
import org.openspaces.grid.gsm.capacity.AbstractCapacityRequirementsPerKey;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;

public class CapacityRequirementsPerZones
extends AbstractCapacityRequirementsPerKey {
    public Set<ZonesConfig> getZones() {
        HashSet<ZonesConfig> zonesList = new HashSet<ZonesConfig>();
        for (String key : super.getKeys()) {
            zonesList.add(ZonesConfigUtils.zonesFromString(key));
        }
        return zonesList;
    }

    public CapacityRequirementsPerZones set(ZonesConfig zones, CapacityRequirements capacity) {
        return (CapacityRequirementsPerZones)super.set(ZonesConfigUtils.zonesToString(zones), capacity);
    }

    public CapacityRequirementsPerZones add(ZonesConfig zones, CapacityRequirements capacity) {
        return (CapacityRequirementsPerZones)super.add(ZonesConfigUtils.zonesToString(zones), capacity);
    }

    public CapacityRequirementsPerZones subtract(ZonesConfig zones, CapacityRequirements capacity) {
        return (CapacityRequirementsPerZones)super.subtract(ZonesConfigUtils.zonesToString(zones), capacity);
    }

    public CapacityRequirementsPerZones subtractZones(ZonesConfig zones) {
        return (CapacityRequirementsPerZones)super.subtractKey(ZonesConfigUtils.zonesToString(zones));
    }

    public CapacityRequirementsPerZones subtractOrZero(ZonesConfig zones, CapacityRequirements capacity) {
        return (CapacityRequirementsPerZones)super.subtractOrZero(ZonesConfigUtils.zonesToString(zones), capacity);
    }

    public CapacityRequirementsPerZones subtract(CapacityRequirementsPerZones other) {
        return (CapacityRequirementsPerZones)super.subtract(other);
    }

    public CapacityRequirementsPerZones add(CapacityRequirementsPerZones other) {
        return (CapacityRequirementsPerZones)super.add(other);
    }

    public CapacityRequirements getZonesCapacity(ZonesConfig zones) {
        return super.getKeyCapacity(ZonesConfigUtils.zonesToString(zones));
    }

    public CapacityRequirements getZonesCapacityOrZero(ZonesConfig zones) {
        return super.getKeyCapacityOrZero(ZonesConfigUtils.zonesToString(zones));
    }

    @Override
    protected CapacityRequirementsPerZones newZeroInstance() {
        return new CapacityRequirementsPerZones();
    }

    @Override
    public String toString() {
        return super.getKeys().size() + " zones with total capacity of " + this.getTotalAllocatedCapacity();
    }

    @Override
    public String toDetailedString() {
        StringBuilder builder = new StringBuilder();
        builder.append("totalNumberOfZones:" + super.getKeys().size() + " , totalCapacity:" + this.getTotalAllocatedCapacity() + ", details:{");
        for (String key : super.getKeys()) {
            builder.append(key + ":" + super.getKeyCapacity(key) + " , ");
        }
        builder.append("}");
        return builder.toString();
    }
}

