/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.capacity;

import org.openspaces.core.internal.commons.math.ConvergenceException;
import org.openspaces.core.internal.commons.math.fraction.Fraction;
import org.openspaces.grid.gsm.capacity.CapacityRequirement;
import org.openspaces.grid.gsm.capacity.CapacityRequirementType;

public class CpuCapacityRequirement
implements CapacityRequirement {
    private final Fraction cpu;

    public CpuCapacityRequirement() {
        this(Fraction.ZERO);
    }

    public CpuCapacityRequirement(Fraction cpu) {
        this.cpu = cpu;
    }

    public CpuCapacityRequirement(double numberOfCpuCores) {
        this(CpuCapacityRequirement.convertCpuCoresFromDoubleToFraction(numberOfCpuCores));
    }

    public static Fraction convertCpuCoresFromDoubleToFraction(double cpu) {
        Fraction targetCpuCores;
        try {
            targetCpuCores = new Fraction(cpu);
        }
        catch (ConvergenceException e) {
            targetCpuCores = new Fraction((int)Math.ceil(cpu * 2.0), 2);
        }
        return targetCpuCores;
    }

    public Fraction getCpu() {
        return this.cpu;
    }

    @Override
    public int compareTo(CapacityRequirement o) {
        return this.cpu.compareTo(this.cast((CapacityRequirement)o).cpu);
    }

    @Override
    public CpuCapacityRequirement multiply(int i) {
        return new CpuCapacityRequirement(this.cpu.multiply(i));
    }

    @Override
    public CpuCapacityRequirement subtract(CapacityRequirement o) {
        if (!(o instanceof CpuCapacityRequirement)) {
            throw new IllegalArgumentException("Cannot subtract " + o.getClass() + " from " + this.getClass());
        }
        Fraction otherCpu = this.cast((CapacityRequirement)o).cpu;
        if (this.cpu.compareTo(otherCpu) < 0) {
            throw new IllegalArgumentException("Cannot subtract " + otherCpu + " from " + this.cpu + " since it would result in a negative number");
        }
        return new CpuCapacityRequirement(this.cpu.subtract(otherCpu));
    }

    @Override
    public CpuCapacityRequirement subtractOrZero(CapacityRequirement o) {
        Fraction otherCpu = this.cast((CapacityRequirement)o).cpu;
        if (this.cpu.compareTo(otherCpu) < 0) {
            return new CpuCapacityRequirement();
        }
        return new CpuCapacityRequirement(this.cpu.subtract(otherCpu));
    }

    @Override
    public boolean equalsZero() {
        return this.cpu.equals((Object)Fraction.ZERO);
    }

    @Override
    public CpuCapacityRequirement add(CapacityRequirement o) {
        return new CpuCapacityRequirement(this.cpu.add(this.cast((CapacityRequirement)o).cpu));
    }

    @Override
    public String toString() {
        return this.cpu + " CPUs";
    }

    @Override
    public boolean equals(Object otherRequirement) {
        return otherRequirement instanceof CpuCapacityRequirement && this.cpu.equals((Object)((CpuCapacityRequirement)otherRequirement).cpu);
    }

    private CpuCapacityRequirement cast(CapacityRequirement o) {
        return (CpuCapacityRequirement)o;
    }

    @Override
    public CapacityRequirement divide(int i) {
        if (i <= 0) {
            throw new IllegalArgumentException("i must be positive");
        }
        return new CpuCapacityRequirement(this.cpu.divide(i));
    }

    @Override
    public CapacityRequirement min(CapacityRequirement otherCapacityRequirement) {
        Fraction otherCpu = ((CpuCapacityRequirement)otherCapacityRequirement).getCpu();
        return otherCpu.compareTo(this.cpu) < 0 ? otherCapacityRequirement : this;
    }

    @Override
    public CapacityRequirement max(CapacityRequirement otherCapacityRequirement) {
        Fraction otherCpu = ((CpuCapacityRequirement)otherCapacityRequirement).getCpu();
        return otherCpu.compareTo(this.cpu) > 0 ? otherCapacityRequirement : this;
    }

    @Override
    public double divide(CapacityRequirement otherCapacityRequirement) {
        Fraction otherCpu = ((CpuCapacityRequirement)otherCapacityRequirement).getCpu();
        return this.cpu.divide(otherCpu).doubleValue();
    }

    public CapacityRequirementType<CpuCapacityRequirement> getType() {
        return new CapacityRequirementType<CpuCapacityRequirement>(this.getClass());
    }
}

