/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.capacity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.machine.Machine;
import org.openspaces.admin.os.OperatingSystemDetails;
import org.openspaces.core.internal.commons.math.fraction.Fraction;
import org.openspaces.core.util.MemoryUnit;
import org.openspaces.grid.gsm.capacity.CapacityRequirement;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;
import org.openspaces.grid.gsm.capacity.CpuCapacityRequirement;
import org.openspaces.grid.gsm.capacity.DriveCapacityRequirement;
import org.openspaces.grid.gsm.capacity.MemoryCapacityRequirement;

public class MachineCapacityRequirements
extends CapacityRequirements {
    Machine machine;
    private static Log logger = LogFactory.getLog(MachineCapacityRequirements.class);

    public MachineCapacityRequirements(Machine machine) {
        super(MachineCapacityRequirements.getMachineRequirements(machine));
        this.machine = machine;
    }

    public static CapacityRequirement[] getMachineRequirements(Machine machine) {
        ArrayList<CapacityRequirement> requirements = new ArrayList<CapacityRequirement>();
        requirements.add(MachineCapacityRequirements.getCpu(machine));
        requirements.add(MachineCapacityRequirements.getMemory(machine));
        requirements.addAll(MachineCapacityRequirements.getDrives(machine));
        return requirements.toArray(new CapacityRequirement[requirements.size()]);
    }

    private static MemoryCapacityRequirement getMemory(Machine machine) {
        OperatingSystemDetails osDetails = machine.getOperatingSystem().getDetails();
        long memoryInMB = MemoryUnit.BYTES.toMegaBytes(osDetails.getTotalPhysicalMemorySizeInBytes());
        if (memoryInMB < 0L) {
            memoryInMB = 0L;
        }
        logger.trace((Object)("Retrieving total physical memory for machine " + machine.getHostAddress() + " : " + memoryInMB));
        return new MemoryCapacityRequirement((Long)memoryInMB);
    }

    private static List<DriveCapacityRequirement> getDrives(Machine machine) {
        ArrayList<DriveCapacityRequirement> drives = new ArrayList<DriveCapacityRequirement>();
        Map<String, OperatingSystemDetails.DriveDetails> osDetails = machine.getOperatingSystem().getDetails().getDriveDetails();
        for (Map.Entry<String, OperatingSystemDetails.DriveDetails> pair : osDetails.entrySet()) {
            String drive = pair.getKey();
            drives.add(new DriveCapacityRequirement(drive, pair.getValue().getCapacityInMB()));
        }
        return drives;
    }

    private static CpuCapacityRequirement getCpu(Machine machine) {
        int availableProcessors = machine.getOperatingSystem().getDetails().getAvailableProcessors();
        logger.trace((Object)("Retrieving number of available processors for machine " + machine.getHostAddress() + " : " + availableProcessors));
        return new CpuCapacityRequirement(new Fraction(availableProcessors, 1));
    }
}

