/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.containers;

import java.util.HashMap;
import java.util.Map;
import org.openspaces.admin.Admin;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.grid.gsm.containers.ContainersSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.containers.ContainersSlaEnforcementState;
import org.openspaces.grid.gsm.containers.ContainersSlaUtils;
import org.openspaces.grid.gsm.containers.DefaultContainersSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.sla.ServiceLevelAgreementEnforcement;
import org.openspaces.grid.gsm.sla.exceptions.ServiceLevelAgreementEnforcementEndpointAlreadyExistsException;

public class ContainersSlaEnforcement
implements ServiceLevelAgreementEnforcement<ContainersSlaEnforcementEndpoint> {
    private final ContainersSlaEnforcementState state;
    private final Map<ProcessingUnit, ContainersSlaEnforcementEndpoint> endpoints = new HashMap<ProcessingUnit, ContainersSlaEnforcementEndpoint>();

    public ContainersSlaEnforcement(Admin admin) {
        this.state = new ContainersSlaEnforcementState();
    }

    @Override
    public ContainersSlaEnforcementEndpoint createEndpoint(ProcessingUnit pu) throws ServiceLevelAgreementEnforcementEndpointAlreadyExistsException {
        if (!this.isEndpointDestroyed(pu)) {
            throw new IllegalStateException("Cannot initialize a new ContainersSlaEnforcementEndpoint for pu " + pu.getName() + " since an endpoint for the pu already exists.");
        }
        ProcessingUnit otherPu1 = ContainersSlaUtils.findProcessingUnitWithSameName(this.endpoints.keySet(), pu);
        if (otherPu1 != null) {
            throw new IllegalStateException("Cannot initialize a new ContainersSlaEnforcementEndpoint for pu " + pu.getName() + " since an endpoint for a pu with the same name already exists.");
        }
        ProcessingUnit otherPu2 = ContainersSlaUtils.findProcessingUnitWithSameZone(this.endpoints.keySet(), pu);
        if (otherPu2 != null) {
            throw new IllegalStateException("Cannot initialize a new ContainersSlaEnforcementEndpoint for pu " + pu.getName() + " since an endpoint for a pu with the same (containers) zone already exists: " + otherPu2.getName());
        }
        DefaultContainersSlaEnforcementEndpoint endpoint = new DefaultContainersSlaEnforcementEndpoint(pu, this.state);
        this.endpoints.put(pu, endpoint);
        this.state.initProcessingUnit(pu);
        return endpoint;
    }

    @Override
    public void destroyEndpoint(ProcessingUnit pu) {
        this.state.destroyProcessingUnit(pu);
        this.endpoints.remove(pu);
    }

    public void destroy() {
        for (ProcessingUnit pu : this.endpoints.keySet()) {
            this.destroyEndpoint(pu);
        }
    }

    private boolean isEndpointDestroyed(ProcessingUnit pu) {
        if (pu == null) {
            throw new IllegalArgumentException("pu cannot be null");
        }
        return !this.endpoints.containsKey(pu) || this.state.isProcessingUnitDestroyed(pu);
    }
}

