/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.containers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.machine.Machine;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.grid.gsm.containers.FutureGridServiceContainer;

class ContainersSlaEnforcementState {
    private final Map<ProcessingUnit, List<GridServiceContainer>> containersMarkedForShutdownPerProcessingUnit = new HashMap<ProcessingUnit, List<GridServiceContainer>>();
    private final Map<ProcessingUnit, List<FutureGridServiceContainer>> futureContainersPerProcessingUnit = new HashMap<ProcessingUnit, List<FutureGridServiceContainer>>();
    private final List<FutureGridServiceContainer> failedFutureContainers = new ArrayList<FutureGridServiceContainer>();

    public void initProcessingUnit(ProcessingUnit pu) {
        this.containersMarkedForShutdownPerProcessingUnit.put(pu, new ArrayList());
        this.futureContainersPerProcessingUnit.put(pu, new ArrayList());
    }

    public void destroyProcessingUnit(ProcessingUnit pu) {
        this.containersMarkedForShutdownPerProcessingUnit.remove(pu);
        this.futureContainersPerProcessingUnit.remove(pu);
    }

    public boolean isProcessingUnitDestroyed(ProcessingUnit pu) {
        return this.containersMarkedForShutdownPerProcessingUnit.get(pu) == null || this.futureContainersPerProcessingUnit.get(pu) == null;
    }

    public boolean isFutureGridServiceContainerOnMachine(Machine machine) {
        for (List<FutureGridServiceContainer> futures : this.futureContainersPerProcessingUnit.values()) {
            for (FutureGridServiceContainer future : futures) {
                if (!future.getGridServiceAgent().getMachine().equals(machine)) continue;
                return true;
            }
        }
        return false;
    }

    public FutureGridServiceContainer removeNextDoneFutureContainer(ProcessingUnit pu) {
        Iterator<FutureGridServiceContainer> iterator = this.futureContainersPerProcessingUnit.get(pu).iterator();
        while (iterator.hasNext()) {
            FutureGridServiceContainer future = iterator.next();
            if (!future.isDone()) continue;
            iterator.remove();
            return future;
        }
        return null;
    }

    public Collection<GridServiceContainer> getContainersMarkedForDeallocation(ProcessingUnit pu) {
        if (this.isProcessingUnitDestroyed(pu)) {
            throw new IllegalStateException("Already destroyed.");
        }
        return Collections.unmodifiableCollection(new ArrayList(this.containersMarkedForShutdownPerProcessingUnit.get(pu)));
    }

    public void failedFutureContainer(FutureGridServiceContainer future) {
        this.failedFutureContainers.add(future);
    }

    public Collection<FutureGridServiceContainer> getFailedFutureContainers() {
        return Collections.unmodifiableCollection(new ArrayList<FutureGridServiceContainer>(this.failedFutureContainers));
    }

    public void removeFailedFuture(FutureGridServiceContainer future) {
        this.failedFutureContainers.remove(future);
    }

    public int getNumberOfContainersMarkedForShutdown(ProcessingUnit pu) {
        return this.containersMarkedForShutdownPerProcessingUnit.get(pu).size();
    }

    public int getNumberOfFutureContainers(ProcessingUnit pu) {
        return this.futureContainersPerProcessingUnit.get(pu).size();
    }

    public void unmarkForShutdownContainer(ProcessingUnit pu, GridServiceContainer container) {
        this.containersMarkedForShutdownPerProcessingUnit.get(pu).remove(container);
    }

    public void markContainerForDeallocation(ProcessingUnit pu, GridServiceContainer container) {
        List<GridServiceContainer> containersMarkedForShutdown = this.containersMarkedForShutdownPerProcessingUnit.get(pu);
        if (!containersMarkedForShutdown.contains(container)) {
            containersMarkedForShutdown.add(container);
        }
    }

    public Collection<FutureGridServiceContainer> getFutureContainers(ProcessingUnit pu) {
        if (this.isProcessingUnitDestroyed(pu)) {
            throw new IllegalStateException("Already destroyed.");
        }
        return Collections.unmodifiableCollection(new ArrayList(this.futureContainersPerProcessingUnit.get(pu)));
    }

    public Collection<FutureGridServiceContainer> getFutureContainers() {
        ArrayList<FutureGridServiceContainer> futures = new ArrayList<FutureGridServiceContainer>();
        for (List<FutureGridServiceContainer> future : this.futureContainersPerProcessingUnit.values()) {
            futures.addAll(future);
        }
        return Collections.unmodifiableCollection(futures);
    }

    public void addFutureContainer(ProcessingUnit pu, FutureGridServiceContainer future) {
        this.futureContainersPerProcessingUnit.get(pu).add(future);
    }
}

