/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.containers;

import org.openspaces.admin.internal.pu.elastic.GridServiceContainerConfig;
import org.openspaces.grid.gsm.capacity.CapacityRequirementsPerAgent;
import org.openspaces.grid.gsm.sla.ServiceLevelAgreementPolicy;

public class ContainersSlaPolicy
extends ServiceLevelAgreementPolicy {
    private GridServiceContainerConfig newContainerConfig;
    private CapacityRequirementsPerAgent clusterCapacityRequirements;
    private boolean atMostOneContainerScalePerMachine;

    public void setNewContainerConfig(GridServiceContainerConfig config) {
        this.newContainerConfig = config;
    }

    public GridServiceContainerConfig getNewContainerConfig() {
        return this.newContainerConfig;
    }

    public CapacityRequirementsPerAgent getClusterCapacityRequirements() {
        return this.clusterCapacityRequirements;
    }

    public void setClusterCapacityRequirements(CapacityRequirementsPerAgent clusterCapacityRequirements) {
        this.clusterCapacityRequirements = clusterCapacityRequirements;
    }

    public void setAtMostOneContainerScalePerMachine(boolean atMostOneContainerScalePerMachine) {
        this.atMostOneContainerScalePerMachine = atMostOneContainerScalePerMachine;
    }

    public boolean isAtMostOneContainerScalePerMachine() {
        return this.atMostOneContainerScalePerMachine;
    }

    public boolean isUndeploying() {
        return false;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        if (this.newContainerConfig == null) {
            throw new IllegalArgumentException("newContainerConfig cannot be null");
        }
        if (this.newContainerConfig.getMaximumMemoryCapacityInMB() <= 0L) {
            throw new IllegalArgumentException("newContainerConfig memory capacity cannot be zero.");
        }
        if (this.newContainerConfig.getMaximumJavaHeapSizeInMB() <= 0L) {
            throw new IllegalArgumentException("newContainerConfig memory capacity cannot be zero.");
        }
        if (this.clusterCapacityRequirements == null) {
            throw new IllegalArgumentException("clusterCapacityRequirements cannot be null");
        }
    }
}

