/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.containers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.openspaces.admin.Admin;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.GridComponent;
import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.gsa.InternalGridServiceAgent;
import org.openspaces.admin.internal.gsc.InternalGridServiceContainer;
import org.openspaces.admin.internal.pu.elastic.GridServiceContainerConfig;
import org.openspaces.admin.machine.Machine;
import org.openspaces.admin.os.OperatingSystemStatistics;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.vm.VirtualMachineAware;
import org.openspaces.core.util.MemoryUnit;
import org.openspaces.grid.gsm.containers.FutureGridServiceContainer;
import org.openspaces.grid.gsm.machines.MachinesSlaUtils;
import org.openspaces.grid.gsm.rebalancing.RebalancingUtils;

public class ContainersSlaUtils {
    static FutureGridServiceContainer startGridServiceContainerAsync(final InternalAdmin admin, final InternalGridServiceAgent gsa, final GridServiceContainerConfig config, final Log logger, final long duration, final TimeUnit timeUnit) {
        final AtomicReference<Object> ref = new AtomicReference<Object>(null);
        final long startTimestamp = System.currentTimeMillis();
        final long end = startTimestamp + timeUnit.toMillis(duration);
        admin.scheduleAdminOperation(new Runnable(){

            @Override
            public void run() {
                try {
                    long freeInMB;
                    OperatingSystemStatistics operatingSystemStatistics = gsa.getMachine().getOperatingSystem().getStatistics();
                    long freeBytes = operatingSystemStatistics.getActualFreePhysicalMemorySizeInBytes();
                    if (freeBytes <= 0L && (freeBytes = operatingSystemStatistics.getFreePhysicalMemorySizeInBytes()) <= 0L) {
                        ref.set(new AdminException("Cannot determine machine " + ContainersSlaUtils.machineToString(gsa.getMachine()) + " free memory."));
                    }
                    if ((freeInMB = MemoryUnit.MEGABYTES.convert(freeBytes, MemoryUnit.BYTES)) < config.getMaximumJavaHeapSizeInMB()) {
                        ref.set(new AdminException("Machine " + ContainersSlaUtils.machineToString(gsa.getMachine()) + " free memory " + freeInMB + "MB is not enough to start a container with " + config.getMaximumJavaHeapSizeInMB() + "MB. Free machine memory or increase machine provisioning reservedMemoryPerMachine property."));
                    } else {
                        ref.set(gsa.internalStartGridService(config));
                    }
                }
                catch (AdminException e) {
                    ref.set(e);
                }
                catch (Throwable e) {
                    logger.error((Object)("Unexpected Exception " + e.getMessage()), e);
                    ref.set(e);
                }
            }
        });
        FutureGridServiceContainer future = new FutureGridServiceContainer(){

            public boolean isTimedOut() {
                return System.currentTimeMillis() > end;
            }

            public ExecutionException getException() {
                Object result = ref.get();
                if (result != null && result instanceof Throwable) {
                    Throwable throwable = (Throwable)result;
                    return new ExecutionException(throwable.getMessage(), throwable);
                }
                return null;
            }

            public GridServiceContainer get() throws ExecutionException, IllegalStateException, TimeoutException {
                Object result = ref.get();
                if (this.getException() != null) {
                    throw this.getException();
                }
                GridServiceContainer container = null;
                if (result != null) {
                    int agentId = (Integer)result;
                    container = this.getGridServiceContainerInternal(agentId);
                }
                if (container == null) {
                    if (this.isTimedOut()) {
                        throw new TimeoutException("Starting a new container took more than " + timeUnit.toSeconds(duration) + " seconds to complete.");
                    }
                    throw new IllegalStateException("Async operation is not done yet.");
                }
                return container;
            }

            public boolean isDone() {
                Object result = ref.get();
                if (System.currentTimeMillis() > end) {
                    return true;
                }
                if (result == null) {
                    return false;
                }
                if (result instanceof Throwable) {
                    return true;
                }
                GridServiceContainer container = this.getGridServiceContainerInternal((Integer)result);
                return container != null;
            }

            public GridServiceContainer getGridServiceContainerInternal(int agentId) {
                for (GridServiceContainer container : admin.getGridServiceContainers()) {
                    String agentUid = ((InternalGridServiceContainer)container).getAgentUid();
                    if (agentUid == null || !agentUid.equals(gsa.getUid()) || agentId != container.getAgentId()) continue;
                    return container;
                }
                return null;
            }

            @Override
            public GridServiceAgent getGridServiceAgent() {
                return gsa;
            }

            @Override
            public GridServiceContainerConfig getGridServiceContainerConfig() {
                return config;
            }

            public Date getTimestamp() {
                return new Date(startTimestamp);
            }

            @Override
            public int getAgentId() throws ExecutionException, TimeoutException {
                ExecutionException exception = this.getException();
                if (exception != null) {
                    throw exception;
                }
                if (this.isTimedOut() && ref.get() == null) {
                    throw new TimeoutException("Starting a new container on machine " + gsa.getMachine().getHostAddress() + " took more than " + timeUnit.toSeconds(duration) + " seconds to complete.");
                }
                if (ref.get() == null) {
                    throw new IllegalStateException("Async operation is not done yet.");
                }
                return (Integer)ref.get();
            }

            @Override
            public boolean isStarted() {
                return ref.get() != null;
            }
        };
        return future;
    }

    public static Collection<GridServiceContainer> getContainersByZone(Admin admin, String zone) {
        ArrayList<GridServiceContainer> containers = new ArrayList<GridServiceContainer>();
        for (GridServiceContainer container : admin.getGridServiceContainers()) {
            if (!ContainersSlaUtils.isContainerMatchesZone(container, zone) || container.getGridServiceAgent() == null) continue;
            containers.add(container);
        }
        return containers;
    }

    public static List<GridServiceContainer> getContainersByZoneOnAgentUid(Admin admin, String zone, String agentUid) {
        ArrayList<GridServiceContainer> containers = new ArrayList<GridServiceContainer>();
        for (GridServiceContainer container : admin.getGridServiceContainers()) {
            if (!ContainersSlaUtils.isContainerMatchesZone(container, zone) || container.getGridServiceAgent() == null || !container.getGridServiceAgent().getUid().equals(agentUid)) continue;
            containers.add(container);
        }
        return containers;
    }

    public static boolean isContainerMatchesZone(GridServiceContainer container, String zone) {
        return container.getZones().containsKey(zone);
    }

    public static long getMemoryInMB(GridServiceContainer container) {
        String prefix = "-Xmx";
        String xmxArgument = ContainersSlaUtils.getCommandLineArgumentRemovePrefix(container, prefix);
        if (xmxArgument == null) {
            throw new IllegalStateException("Container " + ContainersSlaUtils.gscToString(container) + " does not have an -Xmx commandline argument. If it was started manually please close it.");
        }
        return MemoryUnit.MEGABYTES.convert(xmxArgument);
    }

    public static String getCommandLineArgumentRemovePrefix(VirtualMachineAware container, String prefix) {
        String[] commandLineArguments = container.getVirtualMachine().getDetails().getInputArguments();
        String requiredArg = null;
        for (String arg : commandLineArguments) {
            if (!arg.startsWith(prefix)) continue;
            requiredArg = arg;
        }
        if (requiredArg != null) {
            return requiredArg.substring(prefix.length());
        }
        return null;
    }

    public static String getContainerZone(ProcessingUnit pu) {
        Object[] zones = pu.getRequiredZones();
        if (zones.length == 0) {
            throw new IllegalArgumentException("Elastic Processing Unit must have exactly one (container) zone. " + pu.getName() + " has been deployed with no zones defined.");
        }
        if (zones.length > 1) {
            throw new IllegalArgumentException("Elastic Processing Unit must have exactly one (container) zone. " + pu.getName() + " has been deployed with " + zones.length + " zones : " + Arrays.toString(zones));
        }
        return zones[0];
    }

    public static ProcessingUnit findProcessingUnitWithSameZone(Set<ProcessingUnit> processingUnits, ProcessingUnit pu) {
        for (ProcessingUnit endpointPu : processingUnits) {
            if (!ContainersSlaUtils.getContainerZone(endpointPu).equals(ContainersSlaUtils.getContainerZone(pu))) continue;
            return endpointPu;
        }
        return null;
    }

    public static ProcessingUnit findProcessingUnitWithSameName(Set<ProcessingUnit> processingUnits, ProcessingUnit pu) {
        for (ProcessingUnit endpointPu : processingUnits) {
            if (!endpointPu.getName().equals(pu.getName())) continue;
            return endpointPu;
        }
        return null;
    }

    public static String machineToString(Machine machine) {
        return MachinesSlaUtils.machineToString(machine);
    }

    public static String gscToString(GridComponent container) {
        Object[] zones = container.getZones().keySet().toArray(new String[container.getZones().keySet().size()]);
        return "pid[" + container.getVirtualMachine().getDetails().getPid() + "] host[" + ContainersSlaUtils.machineToString(container.getMachine()) + "] zones [" + Arrays.toString(zones) + "]";
    }

    public static String gscsToString(GridServiceContainer[] containers) {
        Object[] containersToString = new String[containers.length];
        for (int i = 0; i < containersToString.length; ++i) {
            containersToString[i] = ContainersSlaUtils.gscToString(containers[i]);
        }
        return Arrays.toString(containersToString);
    }

    public static String gscsToString(Collection<GridServiceContainer> containers) {
        return ContainersSlaUtils.gscsToString(containers.toArray(new GridServiceContainer[containers.size()]));
    }

    public static String gscToStringWithPuInstance(GridServiceContainer container, ProcessingUnit pu) {
        StringBuilder sb = new StringBuilder();
        sb.append(ContainersSlaUtils.gscToString(container));
        sb.append(" { ");
        for (ProcessingUnitInstance instance : container.getProcessingUnitInstances(pu.getName())) {
            sb.append(RebalancingUtils.puInstanceToString(instance));
            sb.append(" ");
        }
        sb.append(" } ");
        return sb.toString();
    }
}

