/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.containers;

import com.gigaspaces.grid.gsa.AgentProcessDetails;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.Admin;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.gsa.GridServiceAgents;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.gsa.InternalGridServiceAgent;
import org.openspaces.admin.internal.gsc.InternalGridServiceContainer;
import org.openspaces.admin.internal.support.InternalAgentGridComponent;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.grid.esm.EsmSystemProperties;
import org.openspaces.grid.gsm.LogPerProcessingUnit;
import org.openspaces.grid.gsm.SingleThreadedPollingLog;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;
import org.openspaces.grid.gsm.capacity.CapacityRequirementsPerAgent;
import org.openspaces.grid.gsm.capacity.MemoryCapacityRequirement;
import org.openspaces.grid.gsm.containers.ContainersSlaEnforcementEndpoint;
import org.openspaces.grid.gsm.containers.ContainersSlaEnforcementState;
import org.openspaces.grid.gsm.containers.ContainersSlaPolicy;
import org.openspaces.grid.gsm.containers.ContainersSlaUtils;
import org.openspaces.grid.gsm.containers.FutureGridServiceContainer;
import org.openspaces.grid.gsm.containers.exceptions.ContainerNotDiscoveredException;
import org.openspaces.grid.gsm.containers.exceptions.ContainersSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.containers.exceptions.ContainersSlaEnforcementPendingProcessingUnitDeallocationException;
import org.openspaces.grid.gsm.containers.exceptions.FailedToStartNewGridServiceContainersException;
import org.openspaces.grid.gsm.machines.MachinesSlaUtils;
import org.openspaces.grid.gsm.rebalancing.RebalancingUtils;

class DefaultContainersSlaEnforcementEndpoint
implements ContainersSlaEnforcementEndpoint {
    private static final long START_CONTAINER_TIMEOUT_FAILURE_SECONDS = Long.getLong("org.openspaces.grid.start-container-timeout-seconds", EsmSystemProperties.ESM_START_CONTAINER_TIMEOUT_FAILURE_SECONDS_DEFAULT);
    private static final long START_CONTAINER_TIMEOUT_FAILURE_FORGET_SECONDS = START_CONTAINER_TIMEOUT_FAILURE_SECONDS + Long.getLong("org.openspaces.grid.wait-before-start-container-again-seconds", EsmSystemProperties.ESM_WAIT_BEFORE_START_CONTAINER_AGAIN_SECONDS_DEFAULT);
    private final ProcessingUnit pu;
    private final Log logger;
    private ContainersSlaEnforcementState state;

    public DefaultContainersSlaEnforcementEndpoint(ProcessingUnit pu, ContainersSlaEnforcementState state) {
        this.pu = pu;
        this.logger = new LogPerProcessingUnit(new SingleThreadedPollingLog(LogFactory.getLog(DefaultContainersSlaEnforcementEndpoint.class)), pu);
        this.state = state;
    }

    @Override
    public GridServiceContainer[] getContainers() {
        this.validateEndpointNotDestroyed(this.pu);
        Collection<GridServiceContainer> approvedContainers = ContainersSlaUtils.getContainersByZone(this.pu.getAdmin(), ContainersSlaUtils.getContainerZone(this.pu));
        approvedContainers.removeAll(this.state.getContainersMarkedForDeallocation(this.pu));
        return approvedContainers.toArray(new GridServiceContainer[approvedContainers.size()]);
    }

    @Override
    public Collection<GridServiceContainer> getContainersMarkedForDeallocation() {
        return this.state.getContainersMarkedForDeallocation(this.pu);
    }

    public boolean isContainersPendingDeallocation() throws ContainersSlaEnforcementInProgressException {
        this.validateEndpointNotDestroyed(this.pu);
        return !this.state.getContainersMarkedForDeallocation(this.pu).isEmpty();
    }

    @Override
    public void enforceSla(ContainersSlaPolicy sla) throws ContainersSlaEnforcementInProgressException {
        this.validateEndpointNotDestroyed(this.pu);
        DefaultContainersSlaEnforcementEndpoint.validateSla(sla, this.pu);
        this.checkAllUndiscoveredContainersAreNotRunning(sla);
        this.logStatusIfDebugEnabled(sla);
        this.enforceSlaInternal(sla);
    }

    private static void validateSla(ContainersSlaPolicy sla, ProcessingUnit pu) {
        if (sla == null) {
            throw new IllegalArgumentException("sla cannot be null");
        }
        sla.validate();
        Object[] zoneInContainerOptions = sla.getNewContainerConfig().getZones();
        String zone = ContainersSlaUtils.getContainerZone(pu);
        if (zoneInContainerOptions.length != 1 || !zoneInContainerOptions[0].equals(zone)) {
            throw new IllegalArgumentException("sla zone is " + Arrays.toString(zoneInContainerOptions) + " and instead it should be " + zone);
        }
    }

    public ProcessingUnit getProcessingUnit() {
        return this.pu;
    }

    private void enforceSlaInternal(ContainersSlaPolicy sla) throws ContainersSlaEnforcementInProgressException {
        this.cleanContainersMarkedForShutdown(this.pu);
        this.cleanFutureContainers(sla);
        this.markForDeallocationContainersOnUnallocatedMachines(sla);
        this.markForDeallocationContainersOnMachineWithAllocatedCapacityShortage(sla);
        this.startContainersOnMachineWithAllocatedCapacitySurplus(sla);
        if (this.state.getNumberOfFutureContainers(this.pu) > 0) {
            throw new ContainersSlaEnforcementInProgressException(this.pu, "Containers still being started.");
        }
        if (!this.state.getContainersMarkedForDeallocation(this.pu).isEmpty()) {
            throw new ContainersSlaEnforcementPendingProcessingUnitDeallocationException(this.getProcessingUnit(), this.state.getContainersMarkedForDeallocation(this.pu));
        }
    }

    private void logStatusIfDebugEnabled(ContainersSlaPolicy sla) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        StringBuilder out = new StringBuilder("Container SLA Status:\n");
        Collection<String> allocatedAgentUids = sla.getClusterCapacityRequirements().getAgentUids();
        String zone = ContainersSlaUtils.getContainerZone(this.pu);
        Collection<GridServiceContainer> containersMarkedForDeallocation = this.state.getContainersMarkedForDeallocation(this.pu);
        out.append("Agents size=" + allocatedAgentUids.size()).append("\n");
        out.append("Containers marked for deallocation: [size=" + containersMarkedForDeallocation.size() + ", " + ContainersSlaUtils.gscsToString(containersMarkedForDeallocation) + "]").append("\n");
        for (String agentUid : allocatedAgentUids) {
            long allocatedMemory = this.getMemoryInMB(sla.getClusterCapacityRequirements().getAgentCapacity(agentUid));
            long containerMemoryInMB = sla.getNewContainerConfig().getMaximumMemoryCapacityInMB();
            List<GridServiceContainer> containersByZoneOnAgent = ContainersSlaUtils.getContainersByZoneOnAgentUid(this.pu.getAdmin(), zone, agentUid);
            out.append("Agent " + MachinesSlaUtils.agentToString(this.pu.getAdmin(), agentUid) + " totalContainers=" + containersByZoneOnAgent.size() + " allocatedMemory=" + allocatedMemory + " containerMemory=" + containerMemoryInMB + " target=" + (int)(1.0 * (double)allocatedMemory / (double)containerMemoryInMB) + " containers.").append("\n");
            int countRunning = 0;
            int countDeallocated = 0;
            for (GridServiceContainer container : containersByZoneOnAgent) {
                if (!containersMarkedForDeallocation.contains(container)) {
                    out.append("Grid Service Container " + ContainersSlaUtils.gscToStringWithPuInstance(container, this.pu)).append("\n");
                    ++countRunning;
                    continue;
                }
                if (container.isDiscovered()) {
                    ++countDeallocated;
                    out.append("Grid Service Container " + ContainersSlaUtils.gscToStringWithPuInstance(container, this.pu) + " is marked for deallocation.").append("\n");
                    continue;
                }
                out.append("Grid Service Container " + ContainersSlaUtils.gscToStringWithPuInstance(container, this.pu) + " is undiscovered.").append("\n");
            }
            out.append("Containers allocated=" + countRunning + ", deallocated=" + countDeallocated).append("\n");
            out.append("------------\n");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)out.toString());
        }
    }

    private void markForDeallocationContainersOnUnallocatedMachines(ContainersSlaPolicy sla) {
        Collection<String> allocatedAgentUids = sla.getClusterCapacityRequirements().getAgentUids();
        String zone = ContainersSlaUtils.getContainerZone(this.pu);
        for (GridServiceContainer container : ContainersSlaUtils.getContainersByZone(this.pu.getAdmin(), zone)) {
            if (allocatedAgentUids.contains(container.getGridServiceAgent().getUid())) continue;
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Grid Service Container " + ContainersSlaUtils.gscToString(container) + " is marked for shutdown since there is no allocation for pu " + this.pu.getName() + " on this machine. Machine is currently running " + ContainersSlaUtils.gscsToString(container.getMachine().getGridServiceContainers().getContainers())));
            }
            this.state.markContainerForDeallocation(this.pu, container);
        }
    }

    private void markForDeallocationContainersOnMachineWithAllocatedCapacityShortage(ContainersSlaPolicy sla) {
        if (!RebalancingUtils.isProcessingUnitIntact(this.pu)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Skipping mark containers for deallocation until all instances of " + this.pu.getName() + " are accounted for."));
            }
            return;
        }
        Collection<String> allocatedAgentUids = sla.getClusterCapacityRequirements().getAgentUids();
        String zone = ContainersSlaUtils.getContainerZone(this.pu);
        Collection<GridServiceContainer> containersMarkedForDeallocation = this.state.getContainersMarkedForDeallocation(this.pu);
        block0: for (String agentUid : allocatedAgentUids) {
            long allocatedMemory = this.getMemoryInMB(sla.getClusterCapacityRequirements().getAgentCapacity(agentUid));
            long containerMemoryInMB = sla.getNewContainerConfig().getMaximumMemoryCapacityInMB();
            long remainingAllocatedMemory = allocatedMemory;
            List<GridServiceContainer> containersByZoneOnAgent = ContainersSlaUtils.getContainersByZoneOnAgentUid(this.pu.getAdmin(), zone, agentUid);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Agent " + MachinesSlaUtils.agentToString(this.pu.getAdmin(), agentUid) + " totalContainers=" + containersByZoneOnAgent.size() + " allocatedMemory=" + allocatedMemory + " containerMemory=" + containerMemoryInMB + " target=" + (int)(1.0 * (double)allocatedMemory / (double)containerMemoryInMB) + " containers."));
            }
            for (GridServiceContainer container : containersByZoneOnAgent) {
                if (containersMarkedForDeallocation.contains(container)) continue;
                if (remainingAllocatedMemory >= containerMemoryInMB) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Grid Service Container " + ContainersSlaUtils.gscToStringWithPuInstance(container, this.pu) + " is running and allocated for pu " + this.pu.getName()));
                    }
                    remainingAllocatedMemory -= containerMemoryInMB;
                    continue;
                }
                this.logger.info((Object)("Grid Service Container " + ContainersSlaUtils.gscToStringWithPuInstance(container, this.pu) + " is marked for deallocation. Container memory in MB: " + containerMemoryInMB));
                this.state.markContainerForDeallocation(this.pu, container);
                if (!sla.isAtMostOneContainerScalePerMachine()) continue;
                continue block0;
            }
        }
    }

    private void checkAllUndiscoveredContainersAreNotRunning(ContainersSlaPolicy sla) throws ContainerNotDiscoveredException {
        CapacityRequirementsPerAgent requirements = sla.getClusterCapacityRequirements();
        Collection<String> allocatedAgentUids = requirements.getAgentUids();
        String zone = ContainersSlaUtils.getContainerZone(this.pu);
        Admin admin = this.pu.getAdmin();
        for (String agentUid : allocatedAgentUids) {
            InternalGridServiceAgent agent = (InternalGridServiceAgent)admin.getGridServiceAgents().getAgentByUID(agentUid);
            if (agent == null) {
                throw new IllegalStateException("agent " + agentUid + " is not discovered");
            }
            for (InternalAgentGridComponent component : agent.getUnconfirmedRemovedAgentGridComponents()) {
                GridServiceContainer container;
                if (!(component instanceof GridServiceContainer) || !ContainersSlaUtils.isContainerMatchesZone(container = (GridServiceContainer)((Object)component), zone)) continue;
                ContainerNotDiscoveredException exception = new ContainerNotDiscoveredException(this.getProcessingUnit(), container);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Admin API undiscovered container validation failed", (Throwable)exception);
                }
                throw exception;
            }
        }
    }

    private void startContainersOnMachineWithAllocatedCapacitySurplus(ContainersSlaPolicy sla) {
        String zone = ContainersSlaUtils.getContainerZone(this.pu);
        Collection<String> allocatedAgentUids = sla.getClusterCapacityRequirements().getAgentUids();
        Collection<GridServiceContainer> containersMarkedForDeallocation = this.state.getContainersMarkedForDeallocation(this.pu);
        Collection<FutureGridServiceContainer> futureContainers = this.state.getFutureContainers(this.pu);
        GridServiceAgents agents = this.pu.getAdmin().getGridServiceAgents();
        for (String agentUid : allocatedAgentUids) {
            long allocatedMemory = this.getMemoryInMB(sla.getClusterCapacityRequirements().getAgentCapacity(agentUid));
            long containerMemoryInMB = sla.getNewContainerConfig().getMaximumMemoryCapacityInMB();
            int numberOfRunningContainers = 0;
            for (GridServiceContainer gridServiceContainer : ContainersSlaUtils.getContainersByZoneOnAgentUid(this.pu.getAdmin(), zone, agentUid)) {
                if (containersMarkedForDeallocation.contains(gridServiceContainer)) continue;
                ++numberOfRunningContainers;
            }
            int numberOfFutureContainers = 0;
            for (FutureGridServiceContainer futureContainer : futureContainers) {
                if (!futureContainer.getGridServiceAgent().getUid().equals(agentUid)) continue;
                ++numberOfFutureContainers;
            }
            GridServiceAgent gridServiceAgent = agents.getAgentByUID(agentUid);
            if (gridServiceAgent == null || !gridServiceAgent.isDiscovered()) {
                throw new IllegalStateException("agent " + agentUid + " is not discovered");
            }
            int numberOfContainersToStart = (int)Math.ceil(1.0 * (double)allocatedMemory / (double)containerMemoryInMB) - numberOfRunningContainers - numberOfFutureContainers;
            if (numberOfContainersToStart <= 0) continue;
            if (sla.isAtMostOneContainerScalePerMachine()) {
                if (numberOfFutureContainers > 0) {
                    this.logger.info((Object)("Waiting to start " + numberOfContainersToStart + " containers on machine " + ContainersSlaUtils.machineToString(gridServiceAgent.getMachine()) + "= ceil(allocatedMemory/containerMemory) - runningContainers - futureContainers =ceil(" + allocatedMemory + "/" + containerMemoryInMB + ") - " + numberOfRunningContainers + " - " + numberOfFutureContainers + "= " + numberOfContainersToStart));
                    continue;
                }
                this.logger.info((Object)("Starting 1 out of " + numberOfContainersToStart + " containers on machine " + ContainersSlaUtils.machineToString(gridServiceAgent.getMachine()) + "= ceil(allocatedMemory/containerMemory) - runningContainers - futureContainers =ceil(" + allocatedMemory + "/" + containerMemoryInMB + ") - " + numberOfRunningContainers + " - " + numberOfFutureContainers + "= " + numberOfContainersToStart));
                this.startContainer(sla, gridServiceAgent);
                continue;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Starting " + numberOfContainersToStart + " containers on machine" + ContainersSlaUtils.machineToString(gridServiceAgent.getMachine()) + "= ceil(allocatedMemory/containerMemory) - runningContainers - futureContainers =ceil(" + allocatedMemory + "/" + containerMemoryInMB + ") - " + numberOfRunningContainers + " - " + numberOfFutureContainers + "= " + numberOfContainersToStart));
            }
            for (int i = 0; i < numberOfContainersToStart; ++i) {
                this.startContainer(sla, gridServiceAgent);
            }
        }
    }

    private long getMemoryInMB(CapacityRequirements capacityRequirements) {
        return capacityRequirements.getRequirement(new MemoryCapacityRequirement().getType()).getMemoryInMB();
    }

    private void startContainer(ContainersSlaPolicy sla, GridServiceAgent gsa) {
        this.state.addFutureContainer(this.pu, ContainersSlaUtils.startGridServiceContainerAsync((InternalAdmin)this.pu.getAdmin(), (InternalGridServiceAgent)gsa, sla.getNewContainerConfig(), this.logger, START_CONTAINER_TIMEOUT_FAILURE_SECONDS, TimeUnit.SECONDS));
    }

    private void cleanFutureContainers(ContainersSlaPolicy sla) throws FailedToStartNewGridServiceContainersException {
        FutureGridServiceContainer future;
        while ((future = this.state.removeNextDoneFutureContainer(this.pu)) != null) {
            Exception exception = null;
            try {
                GridServiceContainer container = (GridServiceContainer)future.get();
                if (container.isDiscovered()) {
                    this.logger.info((Object)("Container started successfully " + ContainersSlaUtils.gscToString(container)));
                }
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof TimeoutException || cause instanceof AdminException || cause instanceof InterruptedException) {
                    exception = e;
                }
                throw new IllegalStateException("Unexpected Exception when starting a new container.", e);
            }
            catch (TimeoutException e) {
                exception = e;
            }
            if (exception == null) continue;
            this.state.failedFutureContainer(future);
            FailedToStartNewGridServiceContainersException ex = new FailedToStartNewGridServiceContainersException(future.getGridServiceAgent().getMachine(), this.pu, exception);
            if (sla.isUndeploying()) {
                this.logger.info((Object)"Ignoring failure to start new container since undeploying.", (Throwable)ex);
                continue;
            }
            throw ex;
        }
        this.cleanFailedFutureContainers();
    }

    private void cleanContainersMarkedForShutdown(ProcessingUnit pu) {
        for (final GridServiceContainer container : this.state.getContainersMarkedForDeallocation(pu)) {
            boolean isContainerDiscovered = container.isDiscovered();
            if (!isContainerDiscovered) {
                this.logger.debug((Object)("Container " + ContainersSlaUtils.gscToString(container) + " has shutdown. Un-marking it from containers marked for shutdown list."));
                this.state.unmarkForShutdownContainer(pu, container);
                continue;
            }
            if (container.getProcessingUnitInstances().length > 0) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Cannot kill container " + ContainersSlaUtils.gscToString(container) + " since there are still processing unit instances running. An instance of this container may be awaiting relocation until more gsc's are available."));
                continue;
            }
            ((InternalAdmin)pu.getAdmin()).scheduleAdminOperation(new Runnable(){

                @Override
                public void run() {
                    boolean hasProcessingUnitInstances;
                    try {
                        hasProcessingUnitInstances = ((InternalGridServiceContainer)container).hasProcessingUnitInstances();
                    }
                    catch (AdminException e) {
                        DefaultContainersSlaEnforcementEndpoint.this.logger.info((Object)("Cannot determine number of processing unit instances running on container " + ContainersSlaUtils.gscToString(container)), (Throwable)e);
                        return;
                    }
                    if (hasProcessingUnitInstances) {
                        DefaultContainersSlaEnforcementEndpoint.this.logger.debug((Object)("Processing unit instances in container " + ContainersSlaUtils.gscToString(container) + " are shutting down. Suspect instance uids:" + Arrays.toString(((InternalGridServiceContainer)container).getUnconfirmedRemovedProcessingUnitInstancesUid())));
                    } else {
                        DefaultContainersSlaEnforcementEndpoint.this.logger.info((Object)("Killing container " + ContainersSlaUtils.gscToString(container) + " since it is not running any processing unit instances."));
                        try {
                            container.kill();
                        }
                        catch (AdminException e) {
                            DefaultContainersSlaEnforcementEndpoint.this.logger.info((Object)("Cannot kill container " + ContainersSlaUtils.gscToString(container)), (Throwable)e);
                        }
                        catch (IllegalArgumentException e) {
                            DefaultContainersSlaEnforcementEndpoint.this.logger.info((Object)("Cannot kill container " + ContainersSlaUtils.gscToString(container)), (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    private void validateEndpointNotDestroyed(ProcessingUnit pu) {
        if (pu == null) {
            throw new IllegalArgumentException("pu cannot be null");
        }
        if (this.state.isProcessingUnitDestroyed(pu)) {
            throw new IllegalStateException("endpoint destroyed");
        }
    }

    private void cleanFailedFutureContainers() {
        for (FutureGridServiceContainer future : this.state.getFailedFutureContainers()) {
            int passedSeconds = (int)((System.currentTimeMillis() - future.getTimestamp().getTime()) / 1000L);
            GridServiceAgent agent = future.getGridServiceAgent();
            if (!agent.isDiscovered()) {
                this.logger.info((Object)("Forgetting failure to start container on machine " + ContainersSlaUtils.machineToString(agent.getMachine()) + " that occurred " + passedSeconds + " seconds ago since grid service agent no longer exists."));
                this.state.removeFailedFuture(future);
                continue;
            }
            this.terminateOrphanContainersOfAgent(agent, future);
            if ((long)passedSeconds <= START_CONTAINER_TIMEOUT_FAILURE_FORGET_SECONDS) continue;
            this.logger.info((Object)("Forgetting failure to start container on machine " + ContainersSlaUtils.machineToString(agent.getMachine()) + " that occurred " + passedSeconds + " seconds ago due to timeout."));
            this.state.removeFailedFuture(future);
        }
    }

    private void terminateOrphanContainersOfAgent(final GridServiceAgent agent, FutureGridServiceContainer suspectedFuture) {
        int suspectedOrphanContainerAgentId;
        try {
            suspectedOrphanContainerAgentId = suspectedFuture.getAgentId();
        }
        catch (TimeoutException e) {
            return;
        }
        catch (ExecutionException e) {
            return;
        }
        HashSet<Integer> agentIds = new HashSet<Integer>();
        for (AgentProcessDetails processDetails : agent.getProcessesDetails()) {
            if (!processDetails.getServiceType().toLowerCase().equals("gsc")) continue;
            agentIds.add(processDetails.getAgentId());
        }
        for (GridServiceContainer container : agent.getAdmin().getGridServiceContainers()) {
            if (!container.getGridServiceAgent().equals(agent)) continue;
            agentIds.remove(container.getAgentId());
        }
        for (FutureGridServiceContainer future : this.state.getFutureContainers()) {
            if (!future.getGridServiceAgent().equals(agent) || !future.isStarted()) continue;
            try {
                agentIds.remove(future.getAgentId());
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {}
        }
        if (agentIds.contains(suspectedOrphanContainerAgentId)) {
            ((InternalAdmin)this.pu.getAdmin()).scheduleAdminOperation(new Runnable(){

                @Override
                public void run() {
                    try {
                        agent.killByAgentId(suspectedOrphanContainerAgentId);
                        DefaultContainersSlaEnforcementEndpoint.this.logger.warn((Object)("Terminated orphan container that did not register with lookup service on machine " + ContainersSlaUtils.machineToString(agent.getMachine()) + " agentId=" + suspectedOrphanContainerAgentId));
                    }
                    catch (AdminException e) {
                        DefaultContainersSlaEnforcementEndpoint.this.logger.warn((Object)("Error terminating orphan container that did not register with lookup service on machine " + ContainersSlaUtils.machineToString(agent.getMachine()) + " agentId=" + suspectedOrphanContainerAgentId), (Throwable)e);
                    }
                }
            });
        }
    }
}

