/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.containers.exceptions;

import java.io.IOException;
import org.openspaces.admin.internal.gsc.events.DefaultElasticGridServiceContainerProvisioningFailureEvent;
import org.openspaces.admin.internal.pu.elastic.events.InternalElasticProcessingUnitFailureEvent;
import org.openspaces.admin.machine.Machine;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.grid.gsm.containers.ContainersSlaUtils;
import org.openspaces.grid.gsm.containers.exceptions.ContainersSlaEnforcementInProgressException;
import org.openspaces.grid.gsm.sla.exceptions.SlaEnforcementFailure;

public class FailedToStartNewGridServiceContainersException
extends ContainersSlaEnforcementInProgressException
implements SlaEnforcementFailure {
    private static final long serialVersionUID = 1L;
    private final String machineUid;

    public FailedToStartNewGridServiceContainersException(Machine machine, ProcessingUnit pu, Exception reason) {
        super(pu, FailedToStartNewGridServiceContainersException.createMessage(machine, reason), reason);
        this.machineUid = machine.getUid();
    }

    private static String createMessage(Machine machine, Exception reason) {
        Throwable rootCause = reason;
        for (int i = 0; i < 10 && rootCause != null && rootCause.getCause() != null && rootCause.getCause() != rootCause && !(rootCause instanceof IOException); rootCause = rootCause.getCause(), ++i) {
        }
        return "Failed to start container on machine." + ContainersSlaUtils.machineToString(machine) + "." + (rootCause != null ? " Caused By:" + rootCause.getMessage() : "");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.machineUid == null ? 0 : this.machineUid.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FailedToStartNewGridServiceContainersException other = (FailedToStartNewGridServiceContainersException)obj;
        return !(this.machineUid == null ? other.machineUid != null : !this.machineUid.equals(other.machineUid));
    }

    @Override
    public InternalElasticProcessingUnitFailureEvent toEvent() {
        DefaultElasticGridServiceContainerProvisioningFailureEvent event = new DefaultElasticGridServiceContainerProvisioningFailureEvent();
        event.setFailureDescription(this.getMessage());
        event.setProcessingUnitName(this.getProcessingUnitName());
        return event;
    }
}

