/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.machines;

import org.openspaces.admin.zone.config.ZonesConfig;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;
import org.openspaces.grid.gsm.machines.MachinesSlaUtils;
import org.openspaces.grid.gsm.machines.isolation.ElasticProcessingUnitMachineIsolation;
import org.openspaces.grid.gsm.machines.plugins.NonBlockingElasticMachineProvisioning;
import org.openspaces.grid.gsm.sla.ServiceLevelAgreementPolicy;
import org.openspaces.grid.gsm.strategy.DiscoveredMachinesCache;

public abstract class AbstractMachinesSlaPolicy
extends ServiceLevelAgreementPolicy {
    private int maxNumberOfMachines;
    private int minimumNumberOfMachines;
    private long containerMemoryCapacityInMB;
    private NonBlockingElasticMachineProvisioning machineProvisioning;
    private ElasticProcessingUnitMachineIsolation machineIsolation;
    private int maxNumberOfContainersPerMachine;
    private DiscoveredMachinesCache machinesCache;
    private ZonesConfig zones;
    private boolean allowAboveAverageMemoryPerMachine;

    public ZonesConfig getGridServiceAgentZones() {
        return this.zones;
    }

    public void setGridServiceAgentZones(ZonesConfig zones) {
        this.zones = zones;
    }

    public DiscoveredMachinesCache getDiscoveredMachinesCache() {
        return this.machinesCache;
    }

    public void setDiscoveredMachinesCache(DiscoveredMachinesCache machinesCache) {
        this.machinesCache = machinesCache;
    }

    public int getMinimumNumberOfMachines() {
        return this.minimumNumberOfMachines;
    }

    public void setMinimumNumberOfMachines(int minimumNumberOfMachines) {
        this.minimumNumberOfMachines = minimumNumberOfMachines;
    }

    public long getReservedMemoryCapacityPerMachineInMB() {
        return MachinesSlaUtils.getMemoryInMB(this.getReservedCapacityPerMachine());
    }

    public void setContainerMemoryCapacityInMB(long containerMemoryCapacityInMB) {
        this.containerMemoryCapacityInMB = containerMemoryCapacityInMB;
    }

    public long getContainerMemoryCapacityInMB() {
        return this.containerMemoryCapacityInMB;
    }

    public NonBlockingElasticMachineProvisioning getMachineProvisioning() {
        return this.machineProvisioning;
    }

    public void setMachineProvisioning(NonBlockingElasticMachineProvisioning machineProvisioning) {
        this.machineProvisioning = machineProvisioning;
    }

    public void setMaximumNumberOfMachines(int maxNumberOfMachines) {
        this.maxNumberOfMachines = maxNumberOfMachines;
    }

    public int getMaximumNumberOfMachines() {
        return this.maxNumberOfMachines;
    }

    public ElasticProcessingUnitMachineIsolation getMachineIsolation() {
        return this.machineIsolation;
    }

    public void setMachineIsolation(ElasticProcessingUnitMachineIsolation isolation) {
        this.machineIsolation = isolation;
    }

    public CapacityRequirements getReservedCapacityPerMachine() {
        return this.machineProvisioning.getConfig().getReservedCapacityPerMachine();
    }

    public CapacityRequirements getReservedCapacityPerManagementMachine() {
        return this.machineProvisioning.getConfig().getReservedCapacityPerManagementMachine();
    }

    public void setMaximumNumberOfContainersPerMachine(int maxNumberOfContainersPerMachine) {
        this.maxNumberOfContainersPerMachine = maxNumberOfContainersPerMachine;
    }

    public int getMaximumNumberOfContainersPerMachine() {
        return this.maxNumberOfContainersPerMachine;
    }

    public boolean isUndeploying() {
        return false;
    }

    @Override
    public void validate() {
        if (this.containerMemoryCapacityInMB <= 0L) {
            throw new IllegalArgumentException("Container memory capacity must be defined.");
        }
        if (this.machineProvisioning == null) {
            throw new IllegalArgumentException("machine provisioning cannot be null");
        }
        if (this.machineIsolation == null) {
            throw new IllegalArgumentException("machine isolation cannot be null");
        }
        if (this.maxNumberOfMachines < 0) {
            throw new IllegalArgumentException("maximum number of machines cannot be " + this.getMaximumNumberOfMachines());
        }
        if (this.minimumNumberOfMachines < 0) {
            throw new IllegalArgumentException("minimum number of machines cannot be " + this.getMinimumNumberOfMachines());
        }
        if (this.minimumNumberOfMachines > this.maxNumberOfMachines) {
            throw new IllegalArgumentException("minimum number of machines (" + this.getMinimumNumberOfMachines() + ") cannot be bigger than maximum number of machines (" + this.getMaximumNumberOfMachines() + ")");
        }
        if (this.machinesCache == null) {
            throw new IllegalArgumentException("Provisioned agents cannot be null");
        }
        if (this.getGridServiceAgentZones() == null) {
            throw new IllegalArgumentException("Exact Zones cannot be null in Capacity Machines Sla Policy");
        }
    }

    public abstract boolean isStopMachineSupported();

    public abstract String getScaleStrategyName();

    public boolean isAllowAboveAverageMemoryPerMachine() {
        return this.allowAboveAverageMemoryPerMachine;
    }

    public void setAllowAboveAverageMemoryPerMachine(boolean allowAboveAverageMemoryPerMachine) {
        this.allowAboveAverageMemoryPerMachine = allowAboveAverageMemoryPerMachine;
    }
}

