/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.grid.gsm.machines;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.openspaces.grid.gsm.capacity.CapacityRequirement;
import org.openspaces.grid.gsm.capacity.CapacityRequirementType;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;
import org.openspaces.grid.gsm.capacity.CapacityRequirementsPerAgent;
import org.openspaces.grid.gsm.capacity.MemoryCapacityRequirement;

public class BinPackingSolver {
    private Log logger;
    private long containerMemoryCapacityInMB;
    private CapacityRequirementsPerAgent unallocatedCapacity;
    private CapacityRequirementsPerAgent allocatedCapacityForPu;
    private CapacityRequirementsPerAgent allocatedCapacityResult;
    private CapacityRequirementsPerAgent deallocatedCapacityResult;
    private String debugTrace = "";
    private long maxMemoryCapacityInMB;
    private int minimumNumberOfMachines;
    private HashMap<String, Long> agentPriority = new HashMap();
    private long maxMemoryCapacityPerMachineInMB;
    private boolean allowMoreThanAverageMemoryPerMachine = false;

    public BinPackingSolver() {
        this.allocatedCapacityResult = new CapacityRequirementsPerAgent();
        this.deallocatedCapacityResult = new CapacityRequirementsPerAgent();
    }

    public boolean isAllowMoreThanAverageMemoryPerMachine() {
        return this.allowMoreThanAverageMemoryPerMachine;
    }

    public void setAllowMoreThanAverageMemoryPerMachine(boolean allowMoreThanAverageMemoryPerMachine) {
        this.allowMoreThanAverageMemoryPerMachine = allowMoreThanAverageMemoryPerMachine;
    }

    public void setMinimumNumberOfMachines(int minimumNumberOfMachines) {
        this.minimumNumberOfMachines = minimumNumberOfMachines;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setContainerMemoryCapacityInMB(long containerMemoryCapacityInMB) {
        this.containerMemoryCapacityInMB = containerMemoryCapacityInMB;
    }

    public void setUnallocatedCapacity(CapacityRequirementsPerAgent unallocatedCapacity) {
        this.unallocatedCapacity = unallocatedCapacity;
    }

    public void setAgentAllocationPriority(Map<String, Long> agentPriority) {
        this.agentPriority = new HashMap<String, Long>(agentPriority);
    }

    public void setAllocatedCapacityForPu(CapacityRequirementsPerAgent allocatedCapacityForPu) {
        this.allocatedCapacityForPu = allocatedCapacityForPu;
    }

    public void setMaxAllocatedMemoryCapacityOfPuInMB(long maxMemoryInMB) {
        this.maxMemoryCapacityInMB = maxMemoryInMB;
    }

    public void setMaxAllocatedMemoryCapacityOfPuPerMachineInMB(long maxMemoryCapacityPerMachineInMB) {
        this.maxMemoryCapacityPerMachineInMB = maxMemoryCapacityPerMachineInMB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void solveManualCapacityScaleIn(CapacityRequirements capacityToDeallocate) {
        boolean success = false;
        try {
            this.debugTrace = "BinPackingSolver: manual capacity scale in " + capacityToDeallocate;
            this.validateInput();
            this.unallocatedCapacity = this.roundFloorMemoryToContainerMemory(this.unallocatedCapacity);
            CapacityRequirements goalCapacity = this.getGoalCapacityScaleIn(capacityToDeallocate);
            this.removeExcessMachines(goalCapacity);
            this.removeExcessContainers(goalCapacity);
            this.rebalanceExistingContainers();
            this.debugTrace = this.debugTrace + " allocatedCapacityResult=" + this.getAllocatedCapacityResult().toDetailedString() + " deallocatedCapacityResult=" + this.getDeallocatedCapacityResult().toDetailedString();
            this.validateResult();
            success = true;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)this.debugTrace);
            } else if (!success && this.logger.isInfoEnabled()) {
                this.logger.info((Object)this.debugTrace);
            }
        }
    }

    private void validateResult() {
        if (this.getMemoryInMB(this.allocatedCapacityForPu) > this.maxMemoryCapacityInMB) {
            throw new IllegalStateException("Allocated memory is more than maximum " + this.maxMemoryCapacityInMB + "MB: " + this.allocatedCapacityForPu.toDetailedString());
        }
        if (this.allocatedCapacityForPu.getAgentUids().size() >= this.minimumNumberOfMachines) {
            long maxMemoryPerMachine = this.getMaxMemoryPerMachine();
            for (String agentUid : this.allocatedCapacityForPu.getAgentUids()) {
                long agentMemory = this.getMemoryInMB(this.allocatedCapacityForPu.getAgentCapacity(agentUid));
                if (agentMemory <= maxMemoryPerMachine) continue;
                throw new IllegalStateException("Agent " + agentUid + " bin packing solver results in " + agentMemory + "MB which is more than the maximum allowed " + maxMemoryPerMachine + "MB.");
            }
        }
    }

    private long getMaxMemoryPerMachine() {
        return this.getMaxMemoryPerMachine(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void solveManualCapacityScaleOut(CapacityRequirements capacityToAllocate) {
        boolean success = false;
        try {
            CapacityRequirements requestedGoalCapacity;
            this.debugTrace = "BinPackingSolver: manual capacity scale out " + capacityToAllocate;
            this.validateInput();
            this.unallocatedCapacity = this.roundFloorMemoryToContainerMemory(this.unallocatedCapacity);
            CapacityRequirements realisticGoalCapacity = requestedGoalCapacity = this.getGoalCapacityScaleOut(capacityToAllocate);
            boolean startExcessContainersToSatisfyNonMemoryShortage = false;
            this.allocateNewMemoryCapacityForPu(this.getMemoryInMB(realisticGoalCapacity));
            this.allocateNewCapacityForPu(realisticGoalCapacity, startExcessContainersToSatisfyNonMemoryShortage);
            if (!this.allocatedCapacityForPu.getTotalAllocatedCapacity().greaterOrEquals(realisticGoalCapacity)) {
                if (this.getMemoryInMB(realisticGoalCapacity) == this.getMemoryInMB(this.allocatedCapacityForPu)) {
                    startExcessContainersToSatisfyNonMemoryShortage = true;
                    this.allocateNewCapacityForPu(requestedGoalCapacity, startExcessContainersToSatisfyNonMemoryShortage);
                }
                realisticGoalCapacity = realisticGoalCapacity.min(this.allocatedCapacityForPu.getTotalAllocatedCapacity());
            }
            this.removeExcessMachines(realisticGoalCapacity);
            this.removeExcessContainers(realisticGoalCapacity);
            this.rebalanceExistingContainers();
            this.debugTrace = this.debugTrace + " allocatedCapacityResult=" + this.getAllocatedCapacityResult().toDetailedString() + " deallocatedCapacityResult=" + this.getDeallocatedCapacityResult().toDetailedString();
            if (this.allocatedCapacityForPu.getTotalAllocatedCapacity().equals(requestedGoalCapacity)) {
                this.validateResult();
            }
            success = true;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)this.debugTrace);
            } else if (!success && this.logger.isInfoEnabled()) {
                this.logger.info((Object)this.debugTrace);
            }
        }
    }

    private void removeExcessContainers(CapacityRequirements goalCapacity) {
        boolean retry;
        if (!this.allocatedCapacityForPu.getTotalAllocatedCapacity().greaterOrEquals(goalCapacity)) {
            throw new IllegalStateException("Removing containers assumes that the goal " + goalCapacity + " is already satisfied.");
        }
        CapacityRequirements oneContainer = new CapacityRequirements(new MemoryCapacityRequirement((Long)this.containerMemoryCapacityInMB));
        CapacityRequirements maxNonMemoryCapacityPerContainer = this.getMaximumNonMemoryCapacityPerContainer();
        block0: do {
            retry = false;
            for (String agentUid : this.allocatedCapacityForPu.getAgentUids()) {
                CapacityRequirements nonMemoryCapacityPerContainerAfterRemovingContainer;
                if (!this.allocatedCapacityForPu.getTotalAllocatedCapacity().subtractOrZero(oneContainer).greaterOrEquals(goalCapacity)) continue block0;
                if (this.getNumberOfContainers(agentUid) <= 1 || (nonMemoryCapacityPerContainerAfterRemovingContainer = this.getAverageNonMemoryCapacityPerContainer(agentUid, 1)).greaterThan(maxNonMemoryCapacityPerContainer)) continue;
                this.deallocateCapacityOnMachine(agentUid, oneContainer);
                retry = true;
            }
        } while (retry);
        int excessNumberOfContainers = (int)Math.floor(1.0 * (double)(this.getMemoryInMB(this.allocatedCapacityForPu) - this.getMemoryInMB(goalCapacity)) / (double)this.containerMemoryCapacityInMB);
        if (excessNumberOfContainers < 1) {
            return;
        }
        if (this.getMaximumNonMemoryCapacityPerContainer().equals(this.getAverageNonMemoryCapacityPerContainer())) {
            String chosenAgentUid = this.allocatedCapacityForPu.getAgentUids().iterator().next();
            int containersOnChosenAgent = this.getNumberOfContainers(chosenAgentUid);
            for (int containersToRemoveFromChosen = containersOnChosenAgent - 1; containersToRemoveFromChosen > 0; --containersToRemoveFromChosen) {
                CapacityRequirements agentCapacity = this.allocatedCapacityForPu.getAgentCapacity(chosenAgentUid);
                CapacityRequirements requiredNonMemoryCapacityPerContainer = agentCapacity.set(new MemoryCapacityRequirement()).divide(containersOnChosenAgent - containersToRemoveFromChosen);
                boolean success = true;
                HashMap<String, Integer> numberOfContainersToRemovePerAgent = new HashMap<String, Integer>();
                for (String agentUid : this.allocatedCapacityForPu.getAgentUids()) {
                    int n = this.getNumberOfContainers(agentUid);
                    CapacityRequirements nonMemoryCapacity = this.allocatedCapacityForPu.getAgentCapacity(agentUid).set(new MemoryCapacityRequirement());
                    int requiredNumberOfContainers = nonMemoryCapacity.divideExactly(requiredNonMemoryCapacityPerContainer);
                    if (requiredNumberOfContainers == -1) {
                        success = false;
                        break;
                    }
                    if (requiredNumberOfContainers > n) {
                        throw new IllegalStateException("Cannot add containers requiredNumberOfContainers=" + requiredNumberOfContainers + " numberOfContainers=" + n);
                    }
                    numberOfContainersToRemovePerAgent.put(agentUid, n - requiredNumberOfContainers);
                }
                if (!success) continue;
                int numberOfContainersToRemove = 0;
                Iterator<Object> iterator = numberOfContainersToRemovePerAgent.values().iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    numberOfContainersToRemove += n;
                }
                if (numberOfContainersToRemove > excessNumberOfContainers) break;
                for (Map.Entry entry : numberOfContainersToRemovePerAgent.entrySet()) {
                    for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                        this.deallocateCapacityOnMachine((String)entry.getKey(), oneContainer);
                    }
                }
                break;
            }
        }
    }

    private boolean removeOverMaximumContainers(CapacityRequirements goalCapacity) {
        boolean retry;
        boolean success = false;
        block0: do {
            retry = false;
            for (String sourceAgentUid : this.allocatedCapacityForPu.getAgentUids()) {
                while (this.removeExcessContainer(sourceAgentUid, this.calcOverMaximumMemory(), goalCapacity)) {
                    retry = true;
                    success = true;
                }
                if (!retry) continue;
                continue block0;
            }
        } while (retry);
        return success;
    }

    private long calcOverMaximumMemory() {
        return this.getMemoryInMB(this.allocatedCapacityForPu) - this.maxMemoryCapacityInMB;
    }

    private boolean removeExcessContainer(String sourceAgentUid, long excessMemory, CapacityRequirements goalCapacity) {
        boolean success = false;
        CapacityRequirements allocatedCapacityOnSourceMachine = this.allocatedCapacityForPu.getAgentCapacity(sourceAgentUid);
        int numberOfContainersOnSourceMachine = (int)(this.getMemoryInMB(allocatedCapacityOnSourceMachine) / this.containerMemoryCapacityInMB);
        if (excessMemory > 0L && numberOfContainersOnSourceMachine >= 2) {
            this.deallocateCapacityOnMachine(sourceAgentUid, new MemoryCapacityRequirement((Long)this.containerMemoryCapacityInMB));
            success = true;
        }
        return success;
    }

    private boolean removeExcessMachines(CapacityRequirements goalCapacity) {
        boolean success = false;
        if (this.allocatedCapacityForPu.getAgentUids().size() > this.minimumNumberOfMachines) {
            boolean retry;
            block0: do {
                retry = false;
                CapacityRequirements excessCapacity = this.allocatedCapacityForPu.getTotalAllocatedCapacity().subtractOrZero(goalCapacity);
                ArrayList<String> sortedAgentUids = new ArrayList<String>(this.allocatedCapacityForPu.getAgentUids());
                Collections.sort(sortedAgentUids, new Comparator<String>(){

                    @Override
                    public int compare(String agentUid1, String agentUid2) {
                        return Long.valueOf(this.getAgentPriority(agentUid1)).compareTo(this.getAgentPriority(agentUid2));
                    }

                    private long getAgentPriority(String agentUid) {
                        long priority = 0L;
                        if (BinPackingSolver.this.agentPriority.containsKey(agentUid)) {
                            priority = (Long)BinPackingSolver.this.agentPriority.get(agentUid);
                        }
                        return priority;
                    }
                });
                for (String sourceAgentUid : sortedAgentUids) {
                    if (!this.removeExcessMachineStep(sourceAgentUid, excessCapacity, goalCapacity)) continue;
                    retry = true;
                    success = true;
                    continue block0;
                }
            } while (retry);
        }
        return success;
    }

    private boolean removeExcessMachineStep(String sourceAgentUid, CapacityRequirements excessCapacity, CapacityRequirements goalCapacity) {
        boolean retry = false;
        CapacityRequirements allocatedCapacityOnSourceMachine = this.allocatedCapacityForPu.getAgentCapacity(sourceAgentUid);
        CapacityRequirements remainingCapacityToRelocate = allocatedCapacityOnSourceMachine.subtractOrZero(excessCapacity);
        if (this.relocateCapacityToOtherMachines(sourceAgentUid, remainingCapacityToRelocate, goalCapacity)) {
            CapacityRequirements remaminingCapacityOnSourceMachine = this.allocatedCapacityForPu.getAgentCapacityOrZero(sourceAgentUid);
            if (!excessCapacity.greaterOrEquals(remaminingCapacityOnSourceMachine)) {
                throw new IllegalStateException("Cannot remove machine since it has " + remaminingCapacityOnSourceMachine + " and excess capacity is " + excessCapacity);
            }
            this.deallocateCapacityOnMachine(sourceAgentUid, remaminingCapacityOnSourceMachine);
            retry = true;
        }
        return retry;
    }

    private boolean relocateCapacityToOtherMachines(String sourceAgentUid, CapacityRequirements remainingCapacityToRelocate, CapacityRequirements goalCapacity) {
        boolean retry = false;
        HashMap<String, CapacityRequirements> capacityToRelocatePerTargetMachine = new HashMap<String, CapacityRequirements>();
        for (String string : this.allocatedCapacityForPu.getAgentUids()) {
            if (remainingCapacityToRelocate.equalsZero()) break;
            if (string.equals(sourceAgentUid)) continue;
            CapacityRequirements unallocatedCapacityOnTarget = this.unallocatedCapacity.getAgentCapacityOrZero(string);
            long maxMemoryPerMachine = Math.min(this.maxMemoryCapacityPerMachineInMB, (long)Math.ceil((double)this.getMemoryInMB(goalCapacity) / (1.0 * (double)this.minimumNumberOfMachines)));
            long maxUnallocatedMemoryOnTarget = Math.max(0L, maxMemoryPerMachine - this.getMemoryInMB(this.allocatedCapacityForPu.getAgentCapacityOrZero(string)));
            if (this.getMemoryInMB(unallocatedCapacityOnTarget) > maxUnallocatedMemoryOnTarget) {
                unallocatedCapacityOnTarget = unallocatedCapacityOnTarget.max(new MemoryCapacityRequirement((Long)maxUnallocatedMemoryOnTarget));
            }
            CapacityRequirements capacityToRelocate = unallocatedCapacityOnTarget.min(remainingCapacityToRelocate);
            if ((capacityToRelocate = this.roundFloorMemoryToContainerMemory(capacityToRelocate)).equalsZero()) continue;
            remainingCapacityToRelocate = remainingCapacityToRelocate.subtract(capacityToRelocate);
            capacityToRelocatePerTargetMachine.put(string, capacityToRelocate);
        }
        if (remainingCapacityToRelocate.equalsZero()) {
            for (Map.Entry entry : capacityToRelocatePerTargetMachine.entrySet()) {
                CapacityRequirements capacity = (CapacityRequirements)entry.getValue();
                String targetAgentUid = (String)entry.getKey();
                this.deallocateCapacityOnMachine(sourceAgentUid, capacity);
                this.allocateCapacityOnMachine(targetAgentUid, capacity);
            }
            retry = true;
        }
        return retry;
    }

    private CapacityRequirementsPerAgent roundFloorMemoryToContainerMemory(CapacityRequirementsPerAgent clusterCapacityRequirements) {
        for (String agent : clusterCapacityRequirements.getAgentUids()) {
            CapacityRequirements agentCapacity = clusterCapacityRequirements.getAgentCapacity(agent);
            CapacityRequirements fixedAgentCapacity = this.roundFloorMemoryToContainerMemory(agentCapacity);
            if (fixedAgentCapacity == agentCapacity) continue;
            clusterCapacityRequirements = clusterCapacityRequirements.set(agent, fixedAgentCapacity);
        }
        return clusterCapacityRequirements;
    }

    private void allocateNewMemoryCapacityForPu(long goalMemoryCapacityInMB) {
        long memoryToAllocateOnMachine;
        block0: do {
            memoryToAllocateOnMachine = 0L;
            CapacityRequirementsPerAgent unallocatedMemory = this.unallocatedCapacity;
            for (String agentUid : unallocatedMemory.getAgentUids()) {
                if (this.getMemoryInMB(unallocatedMemory.getAgentCapacity(agentUid)) != 0L) continue;
                unallocatedMemory = unallocatedMemory.subtractAgent(agentUid);
            }
            long memoryShortage = goalMemoryCapacityInMB - this.getMemoryInMB(this.allocatedCapacityForPu);
            if (memoryShortage < 0L) {
                throw new IllegalStateException("memoryShortage cannot be negative");
            }
            if (memoryShortage == 0L || unallocatedMemory.equalsZero()) break;
            if (unallocatedMemory.getAgentUids().size() > 1 && memoryShortage > this.containerMemoryCapacityInMB) {
                for (String agentUid1 : unallocatedMemory.getAgentUids()) {
                    for (String agentUid2 : unallocatedMemory.getAgentUids()) {
                        if (agentUid1.equals(agentUid2) || (memoryToAllocateOnMachine = this.calculateMemoryToAllocateOnTwoMachines(agentUid1, agentUid2, memoryShortage)) <= 0L) continue;
                        this.allocateCapacityOnMachine(agentUid1, new MemoryCapacityRequirement((Long)memoryToAllocateOnMachine));
                        this.allocateCapacityOnMachine(agentUid2, new MemoryCapacityRequirement((Long)memoryToAllocateOnMachine));
                        break;
                    }
                    if (memoryToAllocateOnMachine <= 0L) continue;
                    break;
                }
            }
            if (memoryToAllocateOnMachine != 0L) continue;
            for (String agentUid : unallocatedMemory.getAgentUids()) {
                memoryToAllocateOnMachine = this.calculateMemoryToAllocateOnSingleMachine(agentUid, memoryShortage);
                if (memoryToAllocateOnMachine <= 0L) continue;
                this.allocateCapacityOnMachine(agentUid, new MemoryCapacityRequirement((Long)memoryToAllocateOnMachine));
                continue block0;
            }
        } while (memoryToAllocateOnMachine > 0L);
    }

    private long calculateMemoryToAllocateOnTwoMachines(String agentUid2, String agentUid1, long memoryShortage) {
        long maxMemoryPerMachine;
        long memoryToAllocateOnEachMachine;
        long memoryToAllocateOnMachine1 = this.calculateMemoryToAllocateOnMachine(agentUid1, (int)Math.floor((double)memoryShortage / 2.0));
        long memoryToAllocateOnMachine2 = this.calculateMemoryToAllocateOnMachine(agentUid2, memoryToAllocateOnMachine1);
        long allocatedMemoryForPuOnMachine1 = this.getMemoryInMB(this.allocatedCapacityForPu.getAgentCapacityOrZero(agentUid1));
        long allocatedMemoryForPuOnMachine2 = this.getMemoryInMB(this.allocatedCapacityForPu.getAgentCapacityOrZero(agentUid2));
        for (memoryToAllocateOnEachMachine = Math.min(memoryToAllocateOnMachine1, memoryToAllocateOnMachine2); memoryToAllocateOnEachMachine > 0L && (memoryToAllocateOnEachMachine + allocatedMemoryForPuOnMachine1 > (maxMemoryPerMachine = this.getMaxMemoryPerMachine(memoryToAllocateOnEachMachine * 2L)) || memoryToAllocateOnEachMachine + allocatedMemoryForPuOnMachine2 > maxMemoryPerMachine); memoryToAllocateOnEachMachine -= this.containerMemoryCapacityInMB) {
        }
        return memoryToAllocateOnEachMachine;
    }

    private long calculateMemoryToAllocateOnSingleMachine(String agentUid, long memoryShortage) {
        long maxMemoryPerMachine;
        long memoryToAllocateOnMachine;
        long allocatedMemoryForPuOnMachine1 = this.getMemoryInMB(this.allocatedCapacityForPu.getAgentCapacityOrZero(agentUid));
        for (memoryToAllocateOnMachine = this.calculateMemoryToAllocateOnMachine(agentUid, memoryShortage); memoryToAllocateOnMachine > 0L && memoryToAllocateOnMachine + allocatedMemoryForPuOnMachine1 > (maxMemoryPerMachine = this.getMaxMemoryPerMachine(memoryToAllocateOnMachine)); memoryToAllocateOnMachine -= this.containerMemoryCapacityInMB) {
        }
        return memoryToAllocateOnMachine;
    }

    private long calculateMemoryToAllocateOnMachine(String agentUid, long memoryShortage) {
        memoryShortage -= memoryShortage % this.containerMemoryCapacityInMB;
        long unallocatedMemoryOnMachine = this.getMemoryInMB(this.unallocatedCapacity.getAgentCapacityOrZero(agentUid));
        if (unallocatedMemoryOnMachine % this.containerMemoryCapacityInMB > 0L) {
            throw new IllegalStateException("unallocated memory " + this.containerMemoryCapacityInMB + "MB must be in multiples of " + this.containerMemoryCapacityInMB);
        }
        long memoryToAllocateOnMachine = Math.min(memoryShortage, unallocatedMemoryOnMachine);
        return memoryToAllocateOnMachine;
    }

    private void allocateNewCapacityForPu(CapacityRequirements goalCapacity, boolean startExtraContainersToSatisfyNonMemoryShortage) {
        if (this.getMemoryInMB(goalCapacity) % this.containerMemoryCapacityInMB != 0L) {
            throw new IllegalArgumentException("goalCapacity memory (" + this.getMemoryInMB(goalCapacity) + "MB) must divide by containerMemoryCapacityInMB (" + this.containerMemoryCapacityInMB + "MB)");
        }
        for (String agentUid : this.unallocatedCapacity.getAgentUids()) {
            CapacityRequirements allocateOnMachine = new CapacityRequirements(new CapacityRequirement[0]);
            for (CapacityRequirement goalCapacityRequirement : goalCapacity.getRequirements()) {
                CapacityRequirement unallocatedCapacityOnMachine;
                if (goalCapacityRequirement instanceof MemoryCapacityRequirement) continue;
                long unallocatedMemoryOnMachine = this.getMemoryInMB(this.unallocatedCapacity.getAgentCapacityOrZero(agentUid));
                long allocatedMemoryForPuOnMachine = this.getMemoryInMB(this.allocatedCapacityForPu.getAgentCapacityOrZero(agentUid).add(allocateOnMachine));
                CapacityRequirement capacityShortage = goalCapacityRequirement.subtract(this.allocatedCapacityForPu.getTotalAllocatedCapacity().getRequirement(goalCapacityRequirement.getType()));
                CapacityRequirement capacityToAllocateOnMachine = capacityShortage.min(unallocatedCapacityOnMachine = this.unallocatedCapacity.getAgentCapacity(agentUid).getRequirement(goalCapacityRequirement.getType()));
                if (capacityToAllocateOnMachine.equalsZero()) continue;
                if (allocatedMemoryForPuOnMachine == 0L && unallocatedMemoryOnMachine >= this.containerMemoryCapacityInMB && startExtraContainersToSatisfyNonMemoryShortage && (long)this.allocatedCapacityForPu.getAgentUids().size() < this.maxMemoryCapacityInMB / this.containerMemoryCapacityInMB) {
                    allocatedMemoryForPuOnMachine = this.containerMemoryCapacityInMB;
                    allocateOnMachine = allocateOnMachine.add(new MemoryCapacityRequirement((Long)this.containerMemoryCapacityInMB));
                }
                if (allocatedMemoryForPuOnMachine <= 0L) continue;
                allocateOnMachine = allocateOnMachine.add(capacityToAllocateOnMachine);
            }
            this.validateNotBreachedMaxMemoryCapacityInMB();
            String agentUidToDeallocateOneContainer = null;
            if (this.getMemoryInMB(this.allocatedCapacityForPu) + this.getMemoryInMB(allocateOnMachine) > this.maxMemoryCapacityInMB) {
                if (this.getMemoryInMB(this.allocatedCapacityForPu.getAgentCapacityOrZero(agentUid)) != 0L) {
                    throw new IllegalStateException("We should not allocated a new container on a machine that already has allocated containers.");
                }
                if (this.getMemoryInMB(allocateOnMachine) != this.containerMemoryCapacityInMB) {
                    throw new IllegalStateException("We should not add memory of more than one container to a machine that does not have any containers.");
                }
                for (String candidateAgentUidToDeallocate : this.allocatedCapacityForPu.getAgentUids()) {
                    if (this.getMemoryInMB(this.allocatedCapacityForPu.getAgentCapacity(candidateAgentUidToDeallocate)) < this.containerMemoryCapacityInMB * 2L) continue;
                    agentUidToDeallocateOneContainer = candidateAgentUidToDeallocate;
                }
            }
            if (agentUidToDeallocateOneContainer != null) {
                this.deallocateCapacityOnMachine(agentUidToDeallocateOneContainer, new MemoryCapacityRequirement((Long)this.containerMemoryCapacityInMB));
            }
            this.allocateCapacityOnMachine(agentUid, allocateOnMachine);
        }
    }

    private long getMaxMemoryPerMachine(long additionalMemoryToAllocate) {
        long totalMemory = this.getMemoryInMB(this.allocatedCapacityForPu) + additionalMemoryToAllocate;
        long memoryToConsider = (long)Math.ceil((double)totalMemory / (1.0 * (double)this.minimumNumberOfMachines));
        if (this.allowMoreThanAverageMemoryPerMachine) {
            memoryToConsider = totalMemory;
        }
        return Math.max(this.containerMemoryCapacityInMB, Math.min(memoryToConsider, this.maxMemoryCapacityPerMachineInMB));
    }

    void rebalanceExistingContainers() {
        this.rebalanceMemoryCapacity();
        this.rebalanceNonMemoryCapacity();
    }

    private void rebalanceMemoryCapacity() {
        long allocatedMemory = this.getMemoryInMB(this.allocatedCapacityForPu);
        int numberOfContainers = (int)(allocatedMemory / this.containerMemoryCapacityInMB);
        int numberOfMachines = this.allocatedCapacityForPu.getAgentUids().size();
        int minNumberOfContainersPerMachine = (int)Math.floor(1.0 * (double)numberOfContainers / (double)numberOfMachines);
        int maxNumberOfContainersPerMachine = (int)Math.ceil(1.0 * (double)numberOfContainers / (double)numberOfMachines);
        final long minMemoryPerMachine = (long)minNumberOfContainersPerMachine * this.containerMemoryCapacityInMB;
        final long maxMemoryPerMachine = (long)maxNumberOfContainersPerMachine * this.containerMemoryCapacityInMB;
        ArrayList<String> sortedAgentUids = new ArrayList<String>(this.allocatedCapacityForPu.getAgentUids());
        Collections.sort(sortedAgentUids, new Comparator<String>(){

            @Override
            public int compare(String agent1, String agent2) {
                long weight1 = BinPackingSolver.this.calcMemoryExcessAboveAverage(maxMemoryPerMachine, agent1) - BinPackingSolver.this.calcMemoryShortageBelowAverage(minMemoryPerMachine, agent1);
                long weight2 = BinPackingSolver.this.calcMemoryExcessAboveAverage(maxMemoryPerMachine, agent2) - BinPackingSolver.this.calcMemoryShortageBelowAverage(minMemoryPerMachine, agent2);
                return (int)Math.signum(weight1 - weight2);
            }
        });
        int targetIndex = 0;
        int sourceIndex = sortedAgentUids.size() - 1;
        while (targetIndex < sourceIndex) {
            String sourceAgentUid = (String)sortedAgentUids.get(sourceIndex);
            String targetAgentUid = (String)sortedAgentUids.get(targetIndex);
            long sourceMemoryExcess = this.calcMemoryExcessAboveAverage(maxMemoryPerMachine, sourceAgentUid);
            long targetMemoryShortage = this.calcMemoryShortageBelowAverage(minMemoryPerMachine, targetAgentUid);
            long memoryToRelocate = 0L;
            if (sourceMemoryExcess == 0L && targetMemoryShortage == 0L) {
                --sourceIndex;
                ++targetIndex;
            } else if (sourceMemoryExcess > 0L && sourceMemoryExcess > targetMemoryShortage) {
                long freeMemoryOnTarget = this.calcMemoryShortageBelowAverage(maxMemoryPerMachine, targetAgentUid);
                if (freeMemoryOnTarget <= sourceMemoryExcess) {
                    memoryToRelocate = freeMemoryOnTarget;
                    ++targetIndex;
                } else {
                    memoryToRelocate = sourceMemoryExcess;
                    --sourceIndex;
                }
            } else if (targetMemoryShortage > 0L) {
                long movableMemoryOnSource = this.calcMemoryExcessAboveAverage(minMemoryPerMachine, sourceAgentUid);
                if (movableMemoryOnSource <= targetMemoryShortage) {
                    memoryToRelocate = movableMemoryOnSource;
                    --sourceIndex;
                } else {
                    memoryToRelocate = targetMemoryShortage;
                    ++targetIndex;
                }
            }
            if ((memoryToRelocate -= memoryToRelocate % this.containerMemoryCapacityInMB) <= 0L) continue;
            this.deallocateCapacityOnMachine(sourceAgentUid, new MemoryCapacityRequirement((Long)memoryToRelocate));
            this.allocateCapacityOnMachine(targetAgentUid, new MemoryCapacityRequirement((Long)memoryToRelocate));
        }
    }

    private long calcMemoryExcessAboveAverage(long average, String agent) {
        if (average % this.containerMemoryCapacityInMB != 0L) {
            throw new IllegalArgumentException("average does not divide by " + this.containerMemoryCapacityInMB);
        }
        long allocated = this.getMemoryInMB(this.allocatedCapacityForPu.getAgentCapacityOrZero(agent));
        return Math.max(allocated - average, 0L);
    }

    private long calcMemoryShortageBelowAverage(long average, String agent) {
        if (average % this.containerMemoryCapacityInMB != 0L) {
            throw new IllegalArgumentException("average does not divide by " + this.containerMemoryCapacityInMB);
        }
        long shortage = Math.max(average - this.getMemoryInMB(this.allocatedCapacityForPu.getAgentCapacityOrZero(agent)), 0L);
        long unallocated = this.roundMemoryToContainerMemory(this.getMemoryInMB(this.unallocatedCapacity.getAgentCapacityOrZero(agent)));
        return Math.min(shortage, unallocated);
    }

    private void rebalanceNonMemoryCapacity() {
        int numberOfContainers = (int)(this.getMemoryInMB(this.allocatedCapacityForPu) / this.containerMemoryCapacityInMB);
        CapacityRequirements totalAllocatedCapacity = this.allocatedCapacityForPu.getTotalAllocatedCapacity();
        for (CapacityRequirement capacityRequirement : totalAllocatedCapacity.getRequirements()) {
            CapacityRequirement goalCapacityPerContainer;
            if (capacityRequirement instanceof MemoryCapacityRequirement || (goalCapacityPerContainer = capacityRequirement.divide(numberOfContainers)).equalsZero()) continue;
            for (String sourceAgentUid : this.allocatedCapacityForPu.getAgentUids()) {
                this.relocateNonMemoryCapacityFromSourceMachine(goalCapacityPerContainer, sourceAgentUid);
            }
        }
    }

    private CapacityRequirements getMaximumNonMemoryCapacityPerContainer() {
        CapacityRequirements maxNonMemoryCapacityPerContainer = new CapacityRequirements(new CapacityRequirement[0]);
        for (String agentUid : this.allocatedCapacityForPu.getAgentUids()) {
            maxNonMemoryCapacityPerContainer = maxNonMemoryCapacityPerContainer.max(this.getAverageNonMemoryCapacityPerContainer(agentUid, 0));
        }
        return maxNonMemoryCapacityPerContainer;
    }

    private CapacityRequirements getAverageNonMemoryCapacityPerContainer(String agentUid, int numberOfContainerToRemove) {
        return this.allocatedCapacityForPu.getAgentCapacity(agentUid).set(new MemoryCapacityRequirement()).divide(this.getNumberOfContainers(agentUid) - numberOfContainerToRemove);
    }

    private int getNumberOfContainers(String agentUid) {
        long allocatedMemory = this.getMemoryInMB(this.allocatedCapacityForPu.getAgentCapacity(agentUid));
        int numberOfContainers = (int)(allocatedMemory / this.containerMemoryCapacityInMB);
        return numberOfContainers;
    }

    private CapacityRequirements getAverageNonMemoryCapacityPerContainer() {
        return this.allocatedCapacityForPu.getTotalAllocatedCapacity().set(new MemoryCapacityRequirement()).divide(this.getNumberOfContainers());
    }

    private int getNumberOfContainers() {
        long allocatedMemory = this.getMemoryInMB(this.allocatedCapacityForPu);
        int numberOfContainers = (int)(allocatedMemory / this.containerMemoryCapacityInMB);
        return numberOfContainers;
    }

    private void relocateNonMemoryCapacityFromSourceMachine(CapacityRequirement goalCapacityPerContainer, String sourceAgentUid) {
        if (goalCapacityPerContainer instanceof MemoryCapacityRequirement) {
            throw new IllegalStateException("This method cannot move containers");
        }
        for (String targetAgentUid : this.unallocatedCapacity.getAgentUids()) {
            CapacityRequirementType<? extends CapacityRequirement> goalType = goalCapacityPerContainer.getType();
            CapacityRequirement capacityOnSourceMachine = this.allocatedCapacityForPu.getAgentCapacity(sourceAgentUid).getRequirement(goalType);
            int numberOfContainersOnSourceMachine = (int)(this.getMemoryInMB(this.allocatedCapacityForPu.getAgentCapacity(sourceAgentUid)) / this.containerMemoryCapacityInMB);
            if (numberOfContainersOnSourceMachine == 0) continue;
            CapacityRequirement goalCapacityOnSourceMachine = goalCapacityPerContainer.multiply(numberOfContainersOnSourceMachine);
            CapacityRequirement capacityToRelocateFromSource = capacityOnSourceMachine.subtractOrZero(goalCapacityOnSourceMachine);
            if (capacityToRelocateFromSource.equalsZero()) break;
            if (sourceAgentUid.equals(targetAgentUid)) continue;
            CapacityRequirements capacityOnTargetMachine = this.allocatedCapacityForPu.getAgentCapacityOrZero(targetAgentUid);
            long memoryOnTargetMachine = this.getMemoryInMB(capacityOnTargetMachine);
            int numberOfContainersOnTargetMachine = (int)(memoryOnTargetMachine / this.containerMemoryCapacityInMB);
            CapacityRequirement goalCapacityOnTargetMachine = goalCapacityPerContainer.multiply(numberOfContainersOnTargetMachine);
            CapacityRequirement capacityRequiredOnTarget = goalCapacityOnTargetMachine.subtractOrZero(capacityOnTargetMachine.getRequirement(goalType));
            CapacityRequirement unallocatedCapacityOnTarget = this.unallocatedCapacity.getAgentCapacity(targetAgentUid).getRequirement(goalType);
            CapacityRequirement capacityToRelocateToTarget = capacityToRelocateFromSource.min(capacityRequiredOnTarget).min(unallocatedCapacityOnTarget);
            if (capacityToRelocateToTarget.equalsZero()) continue;
            this.deallocateCapacityOnMachine(sourceAgentUid, capacityToRelocateToTarget);
            this.allocateCapacityOnMachine(targetAgentUid, capacityToRelocateToTarget);
        }
    }

    private CapacityRequirements getGoalCapacityScaleOut(CapacityRequirements capacityToAllocate) {
        capacityToAllocate = capacityToAllocate.min(this.unallocatedCapacity.getTotalAllocatedCapacity());
        CapacityRequirements goalCapacity = this.allocatedCapacityForPu.getTotalAllocatedCapacity().add(capacityToAllocate);
        goalCapacity = this.roundCeilMemoryToContainerMemory(goalCapacity);
        goalCapacity = goalCapacity.max(new MemoryCapacityRequirement((Long)this.maxMemoryCapacityInMB));
        return goalCapacity;
    }

    private CapacityRequirements getGoalCapacityScaleIn(CapacityRequirements capacityToDeallocate) {
        CapacityRequirements goalCapacity = this.allocatedCapacityForPu.getTotalAllocatedCapacity().subtract(capacityToDeallocate);
        goalCapacity = this.roundCeilMemoryToContainerMemory(goalCapacity);
        long minimumMemoryInMB = (long)this.minimumNumberOfMachines * this.containerMemoryCapacityInMB;
        if (this.getMemoryInMB(goalCapacity) < minimumMemoryInMB) {
            throw new IllegalArgumentException("cannot deallocate " + this.getMemoryInMB(capacityToDeallocate) + "MB, since only allocated " + this.getMemoryInMB(this.allocatedCapacityForPu) + " and minimum memory is " + minimumMemoryInMB);
        }
        return goalCapacity;
    }

    private long roundMemoryToContainerMemory(long memoryInMB) {
        long partialContainerMemory = memoryInMB % this.containerMemoryCapacityInMB;
        if (partialContainerMemory > 0L) {
            memoryInMB = this.containerMemoryCapacityInMB - partialContainerMemory;
        }
        return memoryInMB;
    }

    private CapacityRequirements roundCeilMemoryToContainerMemory(CapacityRequirements capacity) {
        long partialContainerMemory = this.getMemoryInMB(capacity) % this.containerMemoryCapacityInMB;
        if (partialContainerMemory > 0L) {
            capacity = capacity.add(new MemoryCapacityRequirement((Long)(this.containerMemoryCapacityInMB - partialContainerMemory)));
        }
        return capacity;
    }

    private CapacityRequirements roundFloorMemoryToContainerMemory(CapacityRequirements capacity) {
        long partialContainerMemory = this.getMemoryInMB(capacity) % this.containerMemoryCapacityInMB;
        if (partialContainerMemory > 0L) {
            capacity = capacity.subtract(new MemoryCapacityRequirement((Long)partialContainerMemory));
        }
        return capacity;
    }

    private void allocateCapacityOnMachine(String agentUid, CapacityRequirement capacityToAllocateOnAgent) {
        this.allocateCapacityOnMachine(agentUid, new CapacityRequirements(capacityToAllocateOnAgent));
    }

    private void allocateCapacityOnMachine(String agentUid, CapacityRequirements capacityToAllocateOnAgent) {
        if (capacityToAllocateOnAgent.equalsZero()) {
            return;
        }
        if (this.getMemoryInMB(capacityToAllocateOnAgent) % this.containerMemoryCapacityInMB != 0L) {
            throw new IllegalArgumentException("allocatedCapacityOnSourceMachine memory (" + this.getMemoryInMB(capacityToAllocateOnAgent) + "MB) must divide by containerMemoryCapacityInMB (" + this.containerMemoryCapacityInMB + "MB)");
        }
        CapacityRequirements deallocated = capacityToAllocateOnAgent.min(this.deallocatedCapacityResult.getAgentCapacityOrZero(agentUid));
        if (!deallocated.equalsZero()) {
            this.deallocatedCapacityResult = this.deallocatedCapacityResult.subtract(agentUid, deallocated);
            capacityToAllocateOnAgent = capacityToAllocateOnAgent.subtract(deallocated);
        }
        if (!capacityToAllocateOnAgent.equalsZero()) {
            this.allocatedCapacityResult = this.allocatedCapacityResult.add(agentUid, capacityToAllocateOnAgent);
            this.unallocatedCapacity = this.unallocatedCapacity.subtract(agentUid, capacityToAllocateOnAgent);
            this.allocatedCapacityForPu = this.allocatedCapacityForPu.add(agentUid, capacityToAllocateOnAgent);
        }
        this.validateNotBreachedMaxMemoryCapacityInMB();
    }

    private void validateNotBreachedMaxMemoryCapacityInMB() {
        if (this.getMemoryInMB(this.allocatedCapacityForPu) > this.maxMemoryCapacityInMB) {
            throw new IllegalStateException("Allocated memory above allowed maximum");
        }
    }

    private void deallocateCapacityOnMachine(String agentUid, CapacityRequirement capacityToDeallocateOnAgent) {
        this.deallocateCapacityOnMachine(agentUid, new CapacityRequirements(capacityToDeallocateOnAgent));
    }

    private void deallocateCapacityOnMachine(String agentUid, CapacityRequirements capacityToDeallocateOnAgent) {
        if (this.getMemoryInMB(capacityToDeallocateOnAgent) % this.containerMemoryCapacityInMB != 0L) {
            throw new IllegalArgumentException("allocatedCapacityOnSourceMachine memory (" + this.getMemoryInMB(capacityToDeallocateOnAgent) + "MB) must divide by containerMemoryCapacityInMB (" + this.containerMemoryCapacityInMB + "MB)");
        }
        CapacityRequirements allocated = capacityToDeallocateOnAgent.min(this.allocatedCapacityResult.getAgentCapacityOrZero(agentUid));
        if (!allocated.equalsZero()) {
            this.allocatedCapacityResult = this.allocatedCapacityResult.subtract(agentUid, allocated);
            this.unallocatedCapacity = this.unallocatedCapacity.add(agentUid, allocated);
            this.allocatedCapacityForPu = this.allocatedCapacityForPu.subtract(agentUid, allocated);
            capacityToDeallocateOnAgent = capacityToDeallocateOnAgent.subtract(allocated);
        }
        if (!capacityToDeallocateOnAgent.equalsZero()) {
            this.deallocatedCapacityResult = this.deallocatedCapacityResult.add(agentUid, capacityToDeallocateOnAgent);
            this.unallocatedCapacity = this.unallocatedCapacity.add(agentUid, capacityToDeallocateOnAgent);
            this.allocatedCapacityForPu = this.allocatedCapacityForPu.subtract(agentUid, capacityToDeallocateOnAgent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void solveNumberOfMachines(int numberOfMachines) {
        boolean success = false;
        try {
            CapacityRequirements capacityToAllocateOnAgent;
            String agentUid2;
            this.debugTrace = "BinPackingSolver: number of machines " + numberOfMachines;
            this.validateInput();
            this.unallocatedCapacity = this.roundFloorMemoryToContainerMemory(this.unallocatedCapacity);
            Collection<String> agentUidsOfPu = this.allocatedCapacityForPu.getAgentUids();
            if (!agentUidsOfPu.isEmpty()) {
                for (String agentUid2 : this.unallocatedCapacity.getAgentUids()) {
                    if (!agentUidsOfPu.contains(agentUid2)) continue;
                    this.unallocatedCapacity = this.unallocatedCapacity.subtractAgent(agentUid2);
                }
            }
            while (this.allocatedCapacityResult.getAgentUids().size() < numberOfMachines && (agentUid2 = this.findFreeAgentUid(capacityToAllocateOnAgent = new CapacityRequirements(new MemoryCapacityRequirement((Long)this.containerMemoryCapacityInMB)))) != null) {
                if (this.isNewContainerWillBreachMaximumMemory()) {
                    this.removeContainerFromMachineWithMoreThanOneContainerAndMaxUnallocatedMemory();
                }
                if (this.isNewContainerWillBreachMaximumMemory()) break;
                if (!this.deallocatedCapacityResult.getAgentCapacityOrZero(agentUid2).equalsZero()) {
                    throw new IllegalStateException("Impossible to allocate and deallocate from the same agent " + agentUid2);
                }
                this.allocatedCapacityResult = this.allocatedCapacityResult.add(agentUid2, capacityToAllocateOnAgent);
                this.allocatedCapacityForPu = this.allocatedCapacityForPu.add(agentUid2, capacityToAllocateOnAgent);
                this.unallocatedCapacity = this.unallocatedCapacity.subtractAgent(agentUid2);
            }
            this.debugTrace = this.debugTrace + " allocatedCapacityResult=" + this.getAllocatedCapacityResult().toDetailedString() + " deallocatedCapacityResult=" + this.getDeallocatedCapacityResult().toDetailedString();
            success = true;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)this.debugTrace);
            } else if (!success && this.logger.isInfoEnabled()) {
                this.logger.info((Object)this.debugTrace);
            }
        }
    }

    private void removeContainerFromMachineWithMoreThanOneContainerAndMaxUnallocatedMemory() {
        long maxUnallocatedMemoryInMB = Long.MAX_VALUE;
        String agentUidToRemoveContainer = null;
        for (String agentUid : this.allocatedCapacityForPu.getAgentUids()) {
            long unallocated = this.getMemoryInMB(this.unallocatedCapacity.getAgentCapacityOrZero(agentUid));
            long allocatedByPu = this.getMemoryInMB(this.allocatedCapacityForPu.getAgentCapacity(agentUid));
            if (allocatedByPu < this.containerMemoryCapacityInMB * 2L || maxUnallocatedMemoryInMB >= unallocated) continue;
            maxUnallocatedMemoryInMB = unallocated;
            agentUidToRemoveContainer = agentUid;
        }
        if (agentUidToRemoveContainer != null) {
            CapacityRequirements capacityToRemove = new CapacityRequirements(new MemoryCapacityRequirement((Long)this.containerMemoryCapacityInMB));
            if (!this.allocatedCapacityResult.getAgentCapacity(agentUidToRemoveContainer).equalsZero()) {
                throw new IllegalStateException("Impossible to allocate and deallocate from the same agent " + agentUidToRemoveContainer);
            }
            this.deallocatedCapacityResult = this.deallocatedCapacityResult.add(agentUidToRemoveContainer, capacityToRemove);
            this.allocatedCapacityForPu = this.allocatedCapacityForPu.subtract(agentUidToRemoveContainer, capacityToRemove);
        }
    }

    private boolean isNewContainerWillBreachMaximumMemory() {
        return this.getMemoryInMB(this.allocatedCapacityForPu) + this.containerMemoryCapacityInMB > this.maxMemoryCapacityInMB;
    }

    private void validateInput() {
        if (this.allocatedCapacityForPu == null) {
            throw new IllegalArgumentException("allocatedCapacityForPu");
        }
        if (this.unallocatedCapacity == null) {
            throw new IllegalArgumentException("unallocatedCapacity");
        }
        this.debugTrace = this.debugTrace + " containerMemoryCapacityInMB=" + this.containerMemoryCapacityInMB + " maxMemoryCapacityInMB=" + this.maxMemoryCapacityInMB + " unallocatedCapacity=" + this.unallocatedCapacity.toDetailedString() + " allocatedCapacityForPu=" + this.allocatedCapacityForPu.toDetailedString() + " minimumNumberOfMachines=" + this.minimumNumberOfMachines + " maxMemoryCapacityPerMachineInMB=" + this.maxMemoryCapacityPerMachineInMB;
        if (this.containerMemoryCapacityInMB == 0L) {
            throw new IllegalArgumentException("containerMemoryCapacityInMB");
        }
        if (this.maxMemoryCapacityInMB == 0L) {
            throw new IllegalArgumentException("maxMemoryCapacityInMB");
        }
        if (this.maxMemoryCapacityInMB % this.containerMemoryCapacityInMB != 0L) {
            throw new IllegalArgumentException("max memory capacity must divide by " + this.containerMemoryCapacityInMB);
        }
        if (this.getMemoryInMB(this.allocatedCapacityForPu) > this.maxMemoryCapacityInMB) {
            throw new IllegalArgumentException("total PU allocated capacity (" + this.getMemoryInMB(this.allocatedCapacityForPu) + "MB) exceeds the specified max memory (" + this.maxMemoryCapacityInMB + "MB)");
        }
        if (this.maxMemoryCapacityPerMachineInMB == 0L) {
            throw new IllegalArgumentException("maxMemoryCapacityPerMachineInMB");
        }
        if (this.maxMemoryCapacityPerMachineInMB % this.containerMemoryCapacityInMB != 0L) {
            throw new IllegalArgumentException("max memory capacity per machine must divide by " + this.containerMemoryCapacityInMB);
        }
        for (String agentUid : this.allocatedCapacityForPu.getAgentUids()) {
            if (this.getMemoryInMB(this.allocatedCapacityForPu.getAgentCapacity(agentUid)) <= this.maxMemoryCapacityPerMachineInMB) continue;
            throw new IllegalArgumentException("PU allocated capacity on agent " + agentUid + " exceeds the specified max memory capacity per container");
        }
        for (String agentUid : this.allocatedCapacityForPu.getAgentUids()) {
            CapacityRequirements agentCapacity = this.allocatedCapacityForPu.getAgentCapacity(agentUid);
            if (this.getMemoryInMB(agentCapacity) % this.containerMemoryCapacityInMB == 0L) continue;
            throw new IllegalArgumentException("agentCapacity memory (" + this.getMemoryInMB(agentCapacity) + "MB) must divide by containerMemoryCapacityInMB (" + this.containerMemoryCapacityInMB + "MB)");
        }
        if (this.minimumNumberOfMachines < 0) {
            throw new IllegalArgumentException("minimumNumberOfMachines");
        }
    }

    private String findFreeAgentUid(CapacityRequirements capacityToAllocateOnAgent) {
        this.logger.debug((Object)("Looking for an agent to allocate " + capacityToAllocateOnAgent));
        long minUnallocatedMemoryInMB = Long.MAX_VALUE;
        String chosenAgentUid = null;
        for (String agentUid : this.unallocatedCapacity.getAgentUids()) {
            if (!(this.getMemoryInMB(capacityToAllocateOnAgent) != 0L || this.allocatedCapacityForPu.getAgentUids().contains(agentUid) && this.getMemoryInMB(this.allocatedCapacityForPu.getAgentCapacityOrZero(agentUid)) != 0L)) {
                this.logger.debug((Object)("Cannot allocate on agent " + agentUid + " without memory, since it does not already have any memory allocated"));
                continue;
            }
            CapacityRequirements unallocatedCapacityOnAgent = this.unallocatedCapacity.getAgentCapacity(agentUid);
            if (!unallocatedCapacityOnAgent.greaterOrEquals(capacityToAllocateOnAgent)) {
                this.logger.debug((Object)("Cannot allocate on agent " + agentUid + " since it does not have enough unallocated capacity"));
                continue;
            }
            if (minUnallocatedMemoryInMB <= this.getMemoryInMB(unallocatedCapacityOnAgent)) continue;
            chosenAgentUid = agentUid;
            minUnallocatedMemoryInMB = this.getMemoryInMB(unallocatedCapacityOnAgent);
        }
        if (chosenAgentUid != null) {
            this.logger.debug((Object)("Chosen agent " + chosenAgentUid + " to allocate " + capacityToAllocateOnAgent + " since it has the least amount of unallocated memory " + minUnallocatedMemoryInMB));
        } else {
            this.logger.debug((Object)("Cannot find agent that can allocate " + capacityToAllocateOnAgent));
        }
        return chosenAgentUid;
    }

    public CapacityRequirementsPerAgent getAllocatedCapacityResult() {
        return this.allocatedCapacityResult;
    }

    public CapacityRequirementsPerAgent getDeallocatedCapacityResult() {
        return this.deallocatedCapacityResult;
    }

    public CapacityRequirementsPerAgent getAllocatedCapacityForPu() {
        return this.allocatedCapacityForPu;
    }

    public CapacityRequirementsPerAgent getUnallocatedCapacity() {
        return this.unallocatedCapacity;
    }

    public void reset() {
        this.debugTrace = "";
        this.deallocatedCapacityResult = new CapacityRequirementsPerAgent();
        this.allocatedCapacityResult = new CapacityRequirementsPerAgent();
    }

    private long getMemoryInMB(CapacityRequirementsPerAgent clusterCapacity) {
        return this.getMemoryInMB(clusterCapacity.getTotalAllocatedCapacity());
    }

    private long getMemoryInMB(CapacityRequirements capacity) {
        return capacity.getRequirement(new MemoryCapacityRequirement().getType()).getMemoryInMB();
    }

    public String toString() {
        return "BinPackingSolver{containerMemoryCapacityInMB=" + this.containerMemoryCapacityInMB + ", unallocatedCapacity=" + this.unallocatedCapacity + ", allocatedCapacityForPu=" + this.allocatedCapacityForPu + ", allocatedCapacityResult=" + this.allocatedCapacityResult + ", deallocatedCapacityResult=" + this.deallocatedCapacityResult + ", debugTrace='" + this.debugTrace + '\'' + ", maxMemoryCapacityInMB=" + this.maxMemoryCapacityInMB + ", minimumNumberOfMachines=" + this.minimumNumberOfMachines + ", agentPriority=" + this.agentPriority + ", maxMemoryCapacityPerMachineInMB=" + this.maxMemoryCapacityPerMachineInMB + ", allowMoreThanAverageMemoryPerMachine=" + this.allowMoreThanAverageMemoryPerMachine + '}';
    }
}

